/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.map;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import org.apache.commons.math3.util.FastMath;
import org.jdesktop.swingx.JXMapViewer;

public class SelectionAdapter
extends MouseAdapter {
    private boolean dragging;
    private JXMapViewer viewer;
    private Point2D startPos = new Point2D.Double();
    private Point2D endPos = new Point2D.Double();

    public SelectionAdapter(JXMapViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 3) {
            return;
        }
        this.startPos.setLocation(e.getX(), e.getY());
        this.endPos.setLocation(e.getX(), e.getY());
        this.dragging = true;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.dragging) {
            return;
        }
        this.endPos.setLocation(e.getX(), e.getY());
        this.viewer.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.dragging) {
            return;
        }
        if (e.getButton() != 3) {
            return;
        }
        this.viewer.repaint();
        this.dragging = false;
    }

    public Rectangle getRectangle() {
        if (this.dragging) {
            int x1 = (int)FastMath.min((double)this.startPos.getX(), (double)this.endPos.getX());
            int y1 = (int)FastMath.min((double)this.startPos.getY(), (double)this.endPos.getY());
            int x2 = (int)FastMath.max((double)this.startPos.getX(), (double)this.endPos.getX());
            int y2 = (int)FastMath.max((double)this.startPos.getY(), (double)this.endPos.getY());
            return new Rectangle(x1, y1, x2 - x1, y2 - y1);
        }
        return null;
    }
}

