/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.map;

import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.map.PlottableEntityHistory;
import io.github.dsheirer.map.PlottableEntityRenderer;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.painter.AbstractPainter;

public class PlottableEntityPainter
extends AbstractPainter<JXMapViewer> {
    private PlottableEntityRenderer mRenderer;
    private Set<PlottableEntityHistory> mEntities = new HashSet<PlottableEntityHistory>();

    public PlottableEntityPainter(AliasModel aliasModel, IconModel iconModel) {
        this.mRenderer = new PlottableEntityRenderer(aliasModel, iconModel);
        this.setAntialiasing(true);
        this.setCacheable(false);
    }

    public void addEntity(PlottableEntityHistory entity) {
        this.mEntities.add(entity);
    }

    public void removeEntity(PlottableEntityHistory entity) {
        this.mEntities.remove(entity);
    }

    public void clearEntities() {
        this.mEntities.clear();
    }

    private Set<PlottableEntityHistory> getEntities() {
        return Collections.unmodifiableSet(this.mEntities);
    }

    @Override
    protected void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        g.translate(-viewportBounds.getX(), -viewportBounds.getY());
        Set<PlottableEntityHistory> entities = this.getEntities();
        for (PlottableEntityHistory entity : entities) {
            this.mRenderer.paintPlottableEntity(g, map, entity, true);
        }
        g.translate(viewportBounds.getX(), viewportBounds.getY());
    }
}

