/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.map;

import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.map.IPlottableUpdateListener;
import io.github.dsheirer.map.MapMouseListener;
import io.github.dsheirer.map.MapService;
import io.github.dsheirer.map.PlottableEntityHistory;
import io.github.dsheirer.map.PlottableEntityPainter;
import io.github.dsheirer.map.SelectionAdapter;
import io.github.dsheirer.settings.MapViewSetting;
import io.github.dsheirer.settings.SettingsManager;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.OSMTileFactoryInfo;
import org.jdesktop.swingx.input.PanKeyListener;
import org.jdesktop.swingx.input.ZoomMouseWheelListenerCursor;
import org.jdesktop.swingx.mapviewer.DefaultTileFactory;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class MapPanel
extends JPanel
implements IPlottableUpdateListener {
    private static final long serialVersionUID = 1L;
    private SettingsManager mSettingsManager;
    private MapService mMapService;
    private JXMapViewer mMapViewer = new JXMapViewer();
    private PlottableEntityPainter mMapPainter;

    public MapPanel(MapService mapService, AliasModel aliasModel, IconModel iconModel, SettingsManager settingsManager) {
        this.mSettingsManager = settingsManager;
        this.mMapService = mapService;
        this.mMapPainter = new PlottableEntityPainter(aliasModel, iconModel);
        this.init();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[grow,fill]"));
        this.mMapViewer.setOverlayPainter(this.mMapPainter);
        this.mMapService.addListener(this);
        OSMTileFactoryInfo info = new OSMTileFactoryInfo();
        DefaultTileFactory tileFactory = new DefaultTileFactory(info);
        this.mMapViewer.setTileFactory(tileFactory);
        tileFactory.setThreadPoolSize(8);
        GeoPosition syracuse = new GeoPosition(43.048, -76.147);
        int zoom = 7;
        MapViewSetting view = this.mSettingsManager.getMapViewSetting("Default", syracuse, zoom);
        this.mMapViewer.setAddressLocation(view.getGeoPosition());
        this.mMapViewer.setZoom(view.getZoom());
        MapMouseListener listener = new MapMouseListener(this.mMapViewer, this.mSettingsManager);
        this.mMapViewer.addMouseListener(listener);
        this.mMapViewer.addMouseMotionListener(listener);
        this.mMapViewer.addMouseWheelListener(new ZoomMouseWheelListenerCursor(this.mMapViewer));
        this.mMapViewer.addKeyListener(new PanKeyListener(this.mMapViewer));
        SelectionAdapter sa = new SelectionAdapter(this.mMapViewer);
        this.mMapViewer.addMouseListener(sa);
        this.mMapViewer.addMouseMotionListener(sa);
        this.add((Component)this.mMapViewer, "span");
    }

    @Override
    public void entitiesUpdated() {
        EventQueue.invokeLater(() -> this.mMapViewer.repaint());
    }

    @Override
    public void addPlottableEntity(PlottableEntityHistory entity) {
        this.mMapPainter.addEntity(entity);
        this.entitiesUpdated();
    }

    @Override
    public void removePlottableEntity(PlottableEntityHistory entity) {
        this.mMapPainter.removeEntity(entity);
        this.entitiesUpdated();
    }
}

