/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.map;

import io.github.dsheirer.settings.SettingsManager;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class MapMouseListener
extends MouseInputAdapter
implements MouseWheelListener {
    private JXMapViewer mJXMapViewer;
    private SettingsManager mSettingsManager;
    private Point mPreviousPoint;
    private Point mCurrentPoint;

    public MapMouseListener(JXMapViewer viewer, SettingsManager settingsManager) {
        this.mJXMapViewer = viewer;
        this.mSettingsManager = settingsManager;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        int maxHeight;
        if (!SwingUtilities.isLeftMouseButton(event)) {
            return;
        }
        Point current = event.getPoint();
        double x = this.mJXMapViewer.getCenter().getX() - (current.getX() - this.mPreviousPoint.getX());
        double y = this.mJXMapViewer.getCenter().getY() - (current.getY() - this.mPreviousPoint.getY());
        if (!this.mJXMapViewer.isNegativeYAllowed() && y < 0.0) {
            y = 0.0;
        }
        if (y > (double)(maxHeight = (int)(this.mJXMapViewer.getTileFactory().getMapSize(this.mJXMapViewer.getZoom()).getHeight() * (double)this.mJXMapViewer.getTileFactory().getTileSize(this.mJXMapViewer.getZoom())))) {
            y = maxHeight;
        }
        this.mPreviousPoint = current;
        this.mJXMapViewer.setCenter(new Point2D.Double(x, y));
        this.mJXMapViewer.repaint();
        this.mJXMapViewer.setCursor(Cursor.getPredefinedCursor(13));
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (!SwingUtilities.isLeftMouseButton(event)) {
            return;
        }
        this.mPreviousPoint = null;
        this.mJXMapViewer.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapMouseListener.this.mJXMapViewer.requestFocusInWindow();
            }
        });
    }

    @Override
    public void mousePressed(MouseEvent event) {
        boolean doubleClick;
        this.mCurrentPoint = event.getPoint();
        this.mPreviousPoint = event.getPoint();
        boolean left = SwingUtilities.isLeftMouseButton(event);
        boolean middle = SwingUtilities.isMiddleMouseButton(event);
        boolean right = SwingUtilities.isRightMouseButton(event);
        boolean bl = doubleClick = event.getClickCount() == 2;
        if (middle || left && doubleClick) {
            this.recenterMap(event);
        } else if (right) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem mapViewItem = new JMenuItem("Set Default Location & Zoom");
            mapViewItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    GeoPosition position = MapMouseListener.this.mJXMapViewer.convertPointToGeoPosition(MapMouseListener.this.mCurrentPoint);
                    MapMouseListener.this.mSettingsManager.setMapViewSetting("Default", position, MapMouseListener.this.mJXMapViewer.getZoom());
                }
            });
            popup.add(mapViewItem);
            popup.show(this.mJXMapViewer, event.getX(), event.getY());
        }
    }

    private void recenterMap(MouseEvent event) {
        Rectangle bounds = this.mJXMapViewer.getViewportBounds();
        double x = bounds.getX() + (double)event.getX();
        double y = bounds.getY() + (double)event.getY();
        this.mJXMapViewer.setCenter(new Point2D.Double(x, y));
        this.mJXMapViewer.setZoom(this.mJXMapViewer.getZoom() - 1);
        this.mJXMapViewer.repaint();
    }
}

