/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.jmbe;

import io.github.dsheirer.jmbe.github.Asset;
import io.github.dsheirer.jmbe.github.GitHub;
import io.github.dsheirer.jmbe.github.Release;
import io.github.dsheirer.util.FileUtil;
import io.github.dsheirer.util.OSType;
import io.github.dsheirer.util.ThreadPool;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.apache.commons.io.FileUtils;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmbeCreator {
    private static final Logger mLog = LoggerFactory.getLogger(JmbeCreator.class);
    public static final String GITHUB_JMBE_RELEASES_URL = "https://api.github.com/repos/dsheirer/jmbe/releases";
    public static final String CREATOR_SCRIPT_LINUX = "creator";
    public static final String CREATOR_SCRIPT_WINDOWS = "creator.bat";
    private StringProperty mConsoleOutput = new SimpleStringProperty();
    private BooleanProperty mCompleteProperty = new SimpleBooleanProperty();
    private boolean mHasErrors = false;
    private Release mRelease;
    private Path mLibraryPath;
    private StringBuilder mConsoleStringBuilder = new StringBuilder();

    public JmbeCreator(Release release, Path library) {
        this.mRelease = release;
        this.mLibraryPath = library;
    }

    public Path getLibraryPath() {
        return this.mLibraryPath;
    }

    public BooleanProperty completeProperty() {
        return this.mCompleteProperty;
    }

    public StringProperty consoleOutputProperty() {
        return this.mConsoleOutput;
    }

    private void printToConsole(String message) {
        this.mConsoleStringBuilder.append(message).append("\n");
        String console = this.mConsoleStringBuilder.toString();
        Platform.runLater(() -> this.consoleOutputProperty().setValue(console));
    }

    public boolean hasErrors() {
        return this.mHasErrors;
    }

    public void execute() {
        Asset asset = JmbeCreator.getJMBECreatorAsset(this.mRelease);
        if (asset != null) {
            ThreadPool.CACHED.execute(() -> {
                block20: {
                    Path tempDirectory = null;
                    try {
                        tempDirectory = Files.createTempDirectory("sdrtrunk-jmbe-creator", new FileAttribute[0]);
                        this.printToConsole("Created: Temp Directory [" + tempDirectory.toString() + "]");
                        this.printToConsole("Downloading: JMBE Creator [" + asset.toString() + "]");
                        this.printToConsole("Please wait ...");
                        Path creator = GitHub.downloadArtifact(asset.getDownloadUrl(), tempDirectory);
                        if (creator == null) break block20;
                        this.printToConsole("Downloaded: JMBE Creator [" + creator.toString() + "]");
                        Path unzipped = creator.getParent();
                        Archiver archiver = ArchiverFactory.createArchiver((ArchiveFormat)ArchiveFormat.ZIP);
                        archiver.extract(creator.toFile(), unzipped.toFile());
                        this.printToConsole("Unzipped: [" + unzipped.toString() + "]");
                        Path script = null;
                        OSType osType = OSType.getCurrentOSType();
                        if (osType.isLinux() || osType.isOsx()) {
                            script = FileUtil.findFile(unzipped, CREATOR_SCRIPT_LINUX);
                        } else if (osType.isWindows()) {
                            script = FileUtil.findFile(unzipped, CREATOR_SCRIPT_WINDOWS);
                        }
                        if (script != null) {
                            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                            processBuilder.command(script.toString(), this.mLibraryPath.toString());
                            try {
                                String line;
                                Process process = processBuilder.start();
                                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                                while ((line = reader.readLine()) != null) {
                                    this.printToConsole(line);
                                }
                                int exitCode = process.waitFor();
                                if (exitCode == 0) {
                                    this.printToConsole("Library Created Successfully!");
                                    Platform.runLater(() -> this.completeProperty().set(true));
                                    break block20;
                                }
                                this.terminateWithErrors("Failed: Exit Code [" + exitCode + "]");
                                mLog.error("Script failed with exit code: " + exitCode);
                            }
                            catch (InterruptedException ie) {
                                this.terminateWithErrors("Failed: Script Process was interrupted");
                                mLog.error("Interrupted", (Throwable)ie);
                            }
                            break block20;
                        }
                        this.terminateWithErrors("Failed: Unable to find JMBE creator launch script for this OS");
                        mLog.error("Script was null.  Unable to find JMBE creator launch script");
                    }
                    catch (Throwable t) {
                        this.terminateWithErrors("Failed: Unknown Error - " + t.getLocalizedMessage());
                        mLog.error("Failed to create the JMBE library", t);
                    }
                    finally {
                        if (tempDirectory != null) {
                            try {
                                FileUtils.deleteDirectory((File)tempDirectory.toFile());
                                this.printToConsole("Deleted: Temporary Directory [" + tempDirectory.toString() + "]");
                            }
                            catch (IOException ioe) {
                                this.printToConsole("Failed: Deleting Temporary Directory [" + tempDirectory.toString() + "]");
                                mLog.error("Error deleting temporary directory [" + tempDirectory.toString() + "]");
                            }
                        }
                    }
                }
            });
        } else {
            this.terminateWithErrors("Failed: Unable to identify correct JMBE creator utility from GitHub repository for this computer's operating system and architecture");
            mLog.error("Unable to create JMBE library.  Can't find JMBE Creator for this OS and architecture");
        }
    }

    private void terminateWithErrors(String message) {
        this.printToConsole(message);
        this.printToConsole("Please follow the instructions for manually creating and installing the JMBE library");
        Platform.runLater(() -> {
            this.mHasErrors = true;
            this.mCompleteProperty.set(true);
        });
    }

    public static Asset getJMBECreatorAsset(Release release) {
        OSType osType = OSType.getCurrentOSType();
        if (release != null) {
            for (Asset asset : release.getAssets()) {
                if (!JmbeCreator.isCorrectAsset(asset, osType)) continue;
                return asset;
            }
        }
        return null;
    }

    public static boolean isCorrectAsset(Asset asset, OSType osType) {
        if (JmbeCreator.isJMBECreator(asset)) {
            String name = asset.getName();
            switch (osType) {
                case LINUX_AARCH_64: {
                    return name.contains("linux") && name.contains("aarch64");
                }
                case LINUX_ARM_32: {
                    return name.contains("linux") && name.contains("arm32");
                }
                case LINUX_X86_32: {
                    return name.contains("linux") && name.contains("_32");
                }
                case LINUX_X86_64: {
                    return name.contains("linux") && name.contains("_64");
                }
                case OSX_AARCH_64: {
                    return name.contains("osx") && name.contains("aarch64");
                }
                case OSX_X86_64: {
                    return name.contains("osx") && name.contains("_64");
                }
                case WINDOWS_AARCH_64: {
                    return name.contains("windows") && name.contains("aarch64");
                }
                case WINDOWS_X86_32: {
                    return name.contains("windows") && name.contains("_32");
                }
                case WINDOWS_X86_64: {
                    return name.contains("windows") && name.contains("_64");
                }
            }
            return false;
        }
        return false;
    }

    private static boolean isJMBECreator(Asset asset) {
        return asset.getName() != null && asset.getName().startsWith("jmbe-creator");
    }

    public static void main(String[] args) {
        Release release = GitHub.getLatestRelease(GITHUB_JMBE_RELEASES_URL);
        Path library = Paths.get("/home/denny/temp/jmbe.jar", new String[0]);
        JmbeCreator jmbeCreator = new JmbeCreator(release, library);
        jmbeCreator.execute();
        while (true) {
            // Infinite loop
        }
    }
}

