/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.identifier.patch;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.patch.PatchGroup;
import io.github.dsheirer.identifier.patch.PatchGroupIdentifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PatchGroupManager {
    private Map<Integer, PatchGroupIdentifier> mPatchGroupMap = new HashMap<Integer, PatchGroupIdentifier>();

    public void clear() {
        this.mPatchGroupMap.clear();
    }

    public synchronized void addPatchGroup(PatchGroupIdentifier patchGroupIdentifier) {
        PatchGroup update = (PatchGroup)patchGroupIdentifier.getValue();
        if ((Integer)update.getPatchGroup().getValue() > 0) {
            if (this.mPatchGroupMap.containsKey(update.getPatchGroup().getValue())) {
                PatchGroup existingPatchGroup = (PatchGroup)this.mPatchGroupMap.get(update.getPatchGroup().getValue()).getValue();
                if (existingPatchGroup.getVersion() == update.getVersion()) {
                    existingPatchGroup.addPatchedTalkgroups(update.getPatchedTalkgroupIdentifiers());
                    existingPatchGroup.addPatchedRadios(update.getPatchedRadioIdentifiers());
                } else {
                    this.mPatchGroupMap.put((Integer)update.getPatchGroup().getValue(), patchGroupIdentifier);
                }
            } else {
                this.mPatchGroupMap.put((Integer)update.getPatchGroup().getValue(), patchGroupIdentifier);
            }
        }
    }

    public synchronized void addPatchGroups(List<Identifier> identifiers) {
        for (Identifier identifier : identifiers) {
            if (!(identifier instanceof PatchGroupIdentifier)) continue;
            this.addPatchGroup((PatchGroupIdentifier)identifier);
        }
    }

    public synchronized void removePatchGroup(PatchGroupIdentifier patchGroupIdentifier) {
        int id = (Integer)((PatchGroup)patchGroupIdentifier.getValue()).getPatchGroup().getValue();
        this.mPatchGroupMap.remove(id);
    }

    public synchronized void removePatchGroups(List<Identifier> identifiers) {
        for (Identifier identifier : identifiers) {
            if (!(identifier instanceof PatchGroupIdentifier)) continue;
            this.removePatchGroup((PatchGroupIdentifier)identifier);
        }
    }

    public List<Identifier> update(List<Identifier> identifiers) {
        ArrayList<Identifier> updated = new ArrayList<Identifier>();
        for (Identifier identifier : identifiers) {
            updated.add(this.update(identifier));
        }
        return updated;
    }

    public Identifier update(Identifier identifier) {
        if (identifier != null && identifier.getIdentifierClass() == IdentifierClass.USER && identifier.getRole() == Role.TO) {
            switch (identifier.getForm()) {
                case TALKGROUP: {
                    TalkgroupIdentifier talkgroupIdentifier;
                    Identifier mapValue;
                    if (!(identifier instanceof TalkgroupIdentifier) || (mapValue = (Identifier)this.mPatchGroupMap.get((talkgroupIdentifier = (TalkgroupIdentifier)identifier).getValue())) == null) break;
                    return mapValue;
                }
                case PATCH_GROUP: {
                    PatchGroupIdentifier patchGroupIdentifier;
                    int patchGroupId;
                    Identifier mapValue;
                    if (!(identifier instanceof PatchGroupIdentifier) || (mapValue = (Identifier)this.mPatchGroupMap.get(patchGroupId = ((Integer)((PatchGroup)(patchGroupIdentifier = (PatchGroupIdentifier)identifier).getValue()).getPatchGroup().getValue()).intValue())) == null) break;
                    return mapValue;
                }
            }
        }
        return identifier;
    }
}

