/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.identifier;

import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.IdentifierUpdateNotification;
import io.github.dsheirer.identifier.IdentifierUpdateProvider;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.configuration.AliasListConfigurationIdentifier;
import io.github.dsheirer.sample.Listener;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableIdentifierCollection
extends IdentifierCollection
implements IdentifierUpdateProvider,
Listener<IdentifierUpdateNotification> {
    private static final Logger mLog = LoggerFactory.getLogger(MutableIdentifierCollection.class);
    private Listener<IdentifierUpdateNotification> mListener;

    public MutableIdentifierCollection(int timeslot) {
        super(timeslot);
    }

    public MutableIdentifierCollection() {
        super(0);
    }

    public MutableIdentifierCollection(Collection<Identifier> identifiers) {
        this(identifiers, 0);
    }

    public MutableIdentifierCollection(Collection<Identifier> identifiers, int timeslot) {
        super(timeslot);
        for (Identifier identifier : identifiers) {
            this.update(identifier);
        }
    }

    public void broadcastIdentifiers() {
        for (Identifier identifier : this.getIdentifiers()) {
            this.notifyAdd(identifier);
        }
    }

    @Override
    public void setIdentifierUpdateListener(Listener<IdentifierUpdateNotification> listener) {
        this.mListener = listener;
    }

    @Override
    public void removeIdentifierUpdateListener() {
        this.mListener = null;
    }

    private void notifyAdd(Identifier identifier) {
        if (this.mListener != null) {
            this.mListener.receive(new IdentifierUpdateNotification(identifier, IdentifierUpdateNotification.Operation.ADD, this.getTimeslot()));
        }
    }

    private void notifyRemove(Identifier identifier) {
        if (this.mListener != null) {
            this.mListener.receive(new IdentifierUpdateNotification(identifier, IdentifierUpdateNotification.Operation.REMOVE, this.getTimeslot()));
        }
    }

    private void add(Identifier identifier) {
        if (identifier.isValid() && !this.mIdentifiers.contains(identifier)) {
            this.mIdentifiers.add(identifier);
            this.notifyAdd(identifier);
        }
        if (identifier instanceof AliasListConfigurationIdentifier) {
            this.mAliasListConfigurationIdentifier = (AliasListConfigurationIdentifier)identifier;
        }
    }

    private void silentAdd(Identifier identifier) {
        if (identifier.isValid() && !this.mIdentifiers.contains(identifier)) {
            this.mIdentifiers.add(identifier);
        }
        if (identifier instanceof AliasListConfigurationIdentifier) {
            this.mAliasListConfigurationIdentifier = (AliasListConfigurationIdentifier)identifier;
        }
    }

    public void remove(Identifier identifier) {
        if (this.mIdentifiers.remove(identifier)) {
            this.notifyRemove(identifier);
        }
        if (identifier instanceof AliasListConfigurationIdentifier) {
            this.mAliasListConfigurationIdentifier = null;
        }
    }

    public void silentRemove(Identifier identifier) {
        this.mIdentifiers.remove(identifier);
        if (identifier instanceof AliasListConfigurationIdentifier) {
            this.mAliasListConfigurationIdentifier = null;
        }
    }

    public void update(Identifier identifier) {
        if (identifier != null) {
            Identifier existing = this.getIdentifier(identifier.getIdentifierClass(), identifier.getForm(), identifier.getRole());
            if (existing != null) {
                if (!existing.equals(identifier)) {
                    this.remove(existing);
                    this.add(identifier);
                }
            } else {
                this.add(identifier);
            }
        }
    }

    public void silentUpdate(Identifier identifier) {
        if (identifier != null) {
            Identifier existing = this.getIdentifier(identifier.getIdentifierClass(), identifier.getForm(), identifier.getRole());
            if (existing != null) {
                if (!existing.equals(identifier)) {
                    this.silentRemove(existing);
                    this.silentAdd(identifier);
                }
            } else {
                this.silentAdd(identifier);
            }
        }
    }

    public void update(Collection<Identifier> identifiers) {
        for (Identifier identifier : identifiers) {
            this.update(identifier);
        }
    }

    public void clear() {
        ArrayList identifiers = new ArrayList();
        for (Identifier identifier : identifiers) {
            this.remove(identifier);
        }
    }

    public void remove(IdentifierClass identifierClass) {
        ArrayList identifiers = new ArrayList(this.mIdentifiers);
        for (Identifier identifier : identifiers) {
            if (identifier.getIdentifierClass() != identifierClass) continue;
            this.remove(identifier);
        }
    }

    public void remove(Form form) {
        ArrayList identifiers = new ArrayList(this.mIdentifiers);
        for (Identifier identifier : identifiers) {
            if (identifier.getForm() != form) continue;
            this.remove(identifier);
        }
    }

    public void remove(Role role) {
        ArrayList identifiers = new ArrayList(this.mIdentifiers);
        for (Identifier identifier : identifiers) {
            if (identifier.getRole() != role) continue;
            this.remove(identifier);
        }
    }

    public void remove(IdentifierClass identifierClass, Form form, Role role) {
        ArrayList identifiers = new ArrayList(this.mIdentifiers);
        for (Identifier identifier : identifiers) {
            if (identifier.getIdentifierClass() != identifierClass || identifier.getForm() != form || identifier.getRole() != role) continue;
            this.remove(identifier);
        }
    }

    public void remove(IdentifierClass identifierClass, Role role) {
        ArrayList identifiers = new ArrayList(this.mIdentifiers);
        for (Identifier identifier : identifiers) {
            if (identifier.getIdentifierClass() != identifierClass || identifier.getRole() != role) continue;
            this.remove(identifier);
        }
    }

    @Override
    public void receive(IdentifierUpdateNotification identifierUpdateNotification) {
        if (identifierUpdateNotification.getTimeslot() == this.getTimeslot()) {
            if (identifierUpdateNotification.isAdd() || identifierUpdateNotification.isSilentAdd()) {
                this.silentUpdate(identifierUpdateNotification.getIdentifier());
            } else if (identifierUpdateNotification.isRemove() || identifierUpdateNotification.isSilentRemove()) {
                this.silentRemove(identifierUpdateNotification.getIdentifier());
            }
        }
    }

    public IdentifierCollection copyOf() {
        IdentifierCollection copy = new IdentifierCollection(this.getIdentifiers(), this.getTimeslot());
        return copy;
    }
}

