/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.icon;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.github.dsheirer.icon.Icon;
import io.github.dsheirer.icon.IconSet;
import io.github.dsheirer.properties.SystemProperties;
import io.github.dsheirer.util.ThreadPool;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconModel {
    private static final Logger mLog = LoggerFactory.getLogger(IconModel.class);
    public static final int DEFAULT_ICON_SIZE = 12;
    public static final String DEFAULT_ICON = "No Icon";
    private Path mIconFolderPath;
    private Path mIconFilePath;
    private Path mIconBackupFilePath;
    private Path mIconLockFilePath;
    private AtomicBoolean mSavingIcons = new AtomicBoolean();
    private ObservableList<Icon> mIcons = FXCollections.observableArrayList(Icon.extractor());
    private StringProperty mDefaultIconName = new SimpleStringProperty();
    private Map<String, ImageIcon> mResizedIcons = new HashMap<String, ImageIcon>();
    private Icon mDefaultIcon;
    private IconSet mStandardIcons;

    public IconModel() {
        IconSet iconSet = this.load();
        if (iconSet == null) {
            iconSet = this.getStandardIconSet();
        }
        IconSet standardIcons = this.getStandardIconSet();
        this.mIcons.addAll(iconSet.getIcons());
        for (Icon icon : this.mIcons) {
            if (iconSet.getDefaultIcon() != null && iconSet.getDefaultIcon().matches(icon.getName())) {
                icon.setDefaultIcon(true);
                this.mDefaultIcon = icon;
            }
            if (!standardIcons.getIcons().contains(icon)) continue;
            icon.setStandardIcon(true);
        }
        if (this.mDefaultIcon == null && !this.mIcons.isEmpty()) {
            this.setDefaultIcon((Icon)this.mIcons.get(0));
        }
        this.mIcons.addListener(c -> this.scheduleSave());
    }

    public void addIcon(Icon icon) {
        if (icon != null && !this.mIcons.contains((Object)icon)) {
            this.mIcons.add((Object)icon);
        }
    }

    public void removeIcon(Icon icon) {
        if (icon != null && !icon.getStandardIcon() && !icon.getDefaultIcon()) {
            this.mIcons.remove((Object)icon);
        }
    }

    public void setDefaultIcon(Icon icon) {
        if (icon != null) {
            if (this.mDefaultIcon != null) {
                this.mDefaultIcon.setDefaultIcon(false);
            }
            this.mDefaultIcon = icon;
            this.mDefaultIcon.setDefaultIcon(true);
        }
    }

    public Icon getIcon(String iconName) {
        if (iconName != null) {
            for (Icon icon : this.iconsProperty()) {
                if (icon.getName() == null || !icon.getName().contentEquals(iconName)) continue;
                return icon;
            }
        }
        return this.getDefaultIcon();
    }

    public ObservableList<Icon> iconsProperty() {
        return this.mIcons;
    }

    public Icon getDefaultIcon() {
        return this.mDefaultIcon;
    }

    public ImageIcon getIcon(String name, int height) {
        String scaledIconName;
        ImageIcon mapValue;
        if (name == null) {
            name = this.getDefaultIcon().getName();
        }
        if ((mapValue = this.mResizedIcons.get(scaledIconName = name + height)) != null) {
            return mapValue;
        }
        Icon icon = this.getIcon(name);
        ImageIcon scaledIcon = IconModel.getScaledIcon(icon.getIcon(), height);
        if (scaledIcon != null) {
            this.mResizedIcons.put(scaledIconName, scaledIcon);
        }
        return scaledIcon;
    }

    public static ImageIcon getScaledIcon(ImageIcon original, int height) {
        if (original != null) {
            double scale = (double)original.getIconHeight() / (double)height;
            int scaledWidth = (int)((double)original.getIconWidth() / scale);
            Image scaledImage = original.getImage().getScaledInstance(scaledWidth, height, 4);
            return new ImageIcon(scaledImage);
        }
        return null;
    }

    public static ImageIcon getScaledIcon(String path, int height) {
        if (path != null) {
            Icon icon = new Icon("", path);
            return IconModel.getScaledIcon(icon.getIcon(), height);
        }
        return null;
    }

    private Path getIconFolderPath() {
        if (this.mIconFolderPath == null) {
            SystemProperties props = SystemProperties.getInstance();
            this.mIconFolderPath = props.getApplicationFolder("settings");
        }
        return this.mIconFolderPath;
    }

    private Path getIconFilePath() {
        if (this.mIconFilePath == null) {
            this.mIconFilePath = this.getIconFolderPath().resolve("icons.xml");
        }
        return this.mIconFilePath;
    }

    private Path getIconBackupFilePath() {
        if (this.mIconBackupFilePath == null) {
            this.mIconBackupFilePath = this.getIconFolderPath().resolve("icons.backup");
        }
        return this.mIconBackupFilePath;
    }

    private Path getIconLockFilePath() {
        if (this.mIconLockFilePath == null) {
            this.mIconLockFilePath = this.getIconFolderPath().resolve("icons.lock");
        }
        return this.mIconLockFilePath;
    }

    private void save() {
        IconSet iconSet = new IconSet();
        iconSet.setDefaultIcon(this.getDefaultIcon().getName());
        iconSet.setIcons(new ArrayList<Icon>((Collection<Icon>)this.mIcons));
        if (Files.exists(this.getIconFilePath(), new LinkOption[0])) {
            try {
                Files.copy(this.getIconFilePath(), this.getIconBackupFilePath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                mLog.error("Error creating backup copy of current icons prior to saving updates [" + this.getIconFilePath().toString() + "]", (Throwable)e);
            }
        }
        if (!Files.exists(this.getIconLockFilePath(), new LinkOption[0])) {
            try {
                Files.createFile(this.getIconLockFilePath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                mLog.error("Error creating temporary lock file prior to saving icons [" + this.getIconLockFilePath().toString() + "]", (Throwable)e);
            }
        }
        try (OutputStream out = Files.newOutputStream(this.getIconFilePath(), new OpenOption[0]);){
            JacksonXmlModule xmlModule = new JacksonXmlModule();
            xmlModule.setDefaultUseWrapper(false);
            XmlMapper objectMapper = new XmlMapper(xmlModule);
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            objectMapper.writeValue(out, (Object)iconSet);
            out.flush();
            if (Files.exists(this.getIconLockFilePath(), new LinkOption[0])) {
                Files.delete(this.getIconLockFilePath());
            }
        }
        catch (IOException ioe) {
            mLog.error("IO error while writing icons to a file [" + this.getIconFilePath().toString() + "]", (Throwable)ioe);
        }
        catch (Exception e) {
            mLog.error("Error while saving icons [" + this.getIconFilePath().toString() + "]", (Throwable)e);
        }
    }

    public IconSet load() {
        mLog.info("loading icons file [" + this.getIconFilePath().toString() + "]");
        IconSet iconSet = null;
        if (Files.exists(this.getIconLockFilePath(), new LinkOption[0])) {
            try {
                Files.delete(this.getIconFilePath());
                if (Files.exists(this.getIconBackupFilePath(), new LinkOption[0])) {
                    Files.copy(this.getIconBackupFilePath(), this.getIconFilePath(), new CopyOption[0]);
                }
                Files.delete(this.getIconLockFilePath());
            }
            catch (IOException ioe) {
                mLog.error("Previous icons save attempt was incomplete and there was an error restoring the icons backup file", (Throwable)ioe);
            }
        }
        if (Files.exists(this.getIconFilePath(), new LinkOption[0])) {
            JacksonXmlModule xmlModule = new JacksonXmlModule();
            xmlModule.setDefaultUseWrapper(false);
            XmlMapper objectMapper = new XmlMapper(xmlModule);
            try (InputStream in = Files.newInputStream(this.getIconFilePath(), new OpenOption[0]);){
                iconSet = (IconSet)objectMapper.readValue(in, IconSet.class);
            }
            catch (IOException ioe) {
                mLog.error("IO error while reading icons file", (Throwable)ioe);
            }
        } else {
            mLog.info("Icons file not found at [" + this.getIconFilePath().toString() + "]");
        }
        return iconSet;
    }

    private IconSet getStandardIconSet() {
        if (this.mStandardIcons == null) {
            this.mStandardIcons = new IconSet();
            Icon defaultIcon = new Icon(DEFAULT_ICON, "images/no_icon.png");
            this.mStandardIcons.add(defaultIcon);
            this.mStandardIcons.setDefaultIcon(defaultIcon.getName());
            this.mStandardIcons.add(new Icon("Ambulance", "images/ambulance.png"));
            this.mStandardIcons.add(new Icon("Block Truck", "images/concrete_block_truck.png"));
            this.mStandardIcons.add(new Icon("CWID", "images/cwid.png"));
            this.mStandardIcons.add(new Icon("Dispatcher", "images/dispatcher.png"));
            this.mStandardIcons.add(new Icon("Dump Truck", "images/dump_truck_red.png"));
            this.mStandardIcons.add(new Icon("Fire Truck", "images/fire_truck.png"));
            this.mStandardIcons.add(new Icon("Garbage Truck", "images/garbage_truck.png"));
            this.mStandardIcons.add(new Icon("Loader", "images/loader.png"));
            this.mStandardIcons.add(new Icon("Police", "images/police.png"));
            this.mStandardIcons.add(new Icon("Propane Truck", "images/propane_truck.png"));
            this.mStandardIcons.add(new Icon("Rescue Truck", "images/rescue_truck.png"));
            this.mStandardIcons.add(new Icon("School Bus", "images/school_bus.png"));
            this.mStandardIcons.add(new Icon("Taxi", "images/taxi.png"));
            this.mStandardIcons.add(new Icon("Train", "images/train.png"));
            this.mStandardIcons.add(new Icon("Transport Bus", "images/opt_bus.png"));
            this.mStandardIcons.add(new Icon("Van", "images/van.png"));
        }
        return this.mStandardIcons;
    }

    private void scheduleSave() {
        if (this.mSavingIcons.compareAndSet(false, true)) {
            ThreadPool.SCHEDULED.schedule(new IconSaveTask(), 2L, TimeUnit.SECONDS);
        }
    }

    public class IconSaveTask
    implements Runnable {
        @Override
        public void run() {
            IconModel.this.save();
            IconModel.this.mSavingIcons.set(false);
        }
    }
}

