/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.viewer;

import io.github.dsheirer.gui.viewer.DmrViewer;
import io.github.dsheirer.gui.viewer.P25P1Viewer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordingViewer
extends VBox {
    private static final Logger mLog = LoggerFactory.getLogger(RecordingViewer.class);
    private MenuBar mMenuBar;
    private TabPane mTabPane;
    private int mTabCounterDmr = 1;
    private int mTabCounterP25P1 = 1;

    public RecordingViewer() {
        VBox.setVgrow((Node)this.getTabPane(), (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.getMenuBar(), this.getTabPane()});
    }

    public MenuBar getMenuBar() {
        if (this.mMenuBar == null) {
            this.mMenuBar = new MenuBar();
            Menu fileMenu = new Menu("File");
            Menu createNewViewerMenu = new Menu("New Viewer ...");
            MenuItem dmrMenuItem = new MenuItem("DMR");
            dmrMenuItem.onActionProperty().set(event -> {
                LabeledTab tab = new LabeledTab(this, "DMR-" + this.mTabCounterDmr++, (Node)new DmrViewer());
                this.getTabPane().getTabs().add((Object)tab);
                this.getTabPane().getSelectionModel().select((Object)tab);
            });
            MenuItem p25p1MenuItem = new MenuItem("P25P1");
            p25p1MenuItem.onActionProperty().set(event -> {
                LabeledTab tab = new LabeledTab(this, "P25P1-" + this.mTabCounterP25P1++, (Node)new P25P1Viewer());
                this.getTabPane().getTabs().add((Object)tab);
                this.getTabPane().getSelectionModel().select((Object)tab);
            });
            createNewViewerMenu.getItems().addAll((Object[])new MenuItem[]{dmrMenuItem, p25p1MenuItem});
            MenuItem exitMenu = new MenuItem("Exit");
            exitMenu.onActionProperty().set(event -> ((Stage)this.getScene().getWindow()).close());
            fileMenu.getItems().addAll((Object[])new MenuItem[]{createNewViewerMenu, new SeparatorMenuItem(), exitMenu});
            this.mMenuBar.getMenus().add((Object)fileMenu);
        }
        return this.mMenuBar;
    }

    public TabPane getTabPane() {
        if (this.mTabPane == null) {
            this.mTabPane = new TabPane();
            this.mTabPane.setMaxHeight(Double.MAX_VALUE);
            this.mTabPane.getTabs().add((Object)new LabeledTab(this, "DMR-" + this.mTabCounterDmr++, (Node)new DmrViewer()));
            this.mTabPane.getTabs().add((Object)new LabeledTab(this, "P25P1-" + this.mTabCounterP25P1++, (Node)new P25P1Viewer()));
        }
        return this.mTabPane;
    }

    public static void main(String[] args) {
        Application viewer = new Application(){

            public void start(Stage primaryStage) throws Exception {
                Scene scene = new Scene((Parent)new RecordingViewer(), 1100.0, 800.0);
                primaryStage.setTitle("Message Recording Viewer (.bits)");
                primaryStage.setScene(scene);
                primaryStage.show();
            }
        };
        Runnable r = () -> {
            try {
                viewer.start(new Stage());
            }
            catch (Exception e) {
                mLog.error("Error starting message recording viewer application", (Throwable)e);
            }
        };
        Platform.startup((Runnable)r);
    }

    public class LabeledTab
    extends Tab {
        private Label mLabel = new Label();
        private TextField mTextField = new TextField();

        public LabeledTab(RecordingViewer this$0, String label, Node node) {
            super(null, node);
            this.mLabel.setText(label);
            this.setGraphic((Node)this.mLabel);
            this.mLabel.setOnMouseClicked(event -> {
                if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() > 1 || event.getButton().equals((Object)MouseButton.SECONDARY)) {
                    this.setGraphic((Node)this.mTextField);
                    this.mTextField.setText(this.mLabel.getText());
                    this.mTextField.selectAll();
                    this.mTextField.requestFocus();
                }
            });
            this.mTextField.setOnAction(event -> {
                this.mLabel.setText(this.mTextField.getText());
                this.setGraphic((Node)this.mLabel);
            });
            this.mTextField.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.mLabel.setText(this.mTextField.getText());
                    this.setGraphic((Node)this.mLabel);
                }
            });
        }

        public LabeledTab(RecordingViewer this$0, String label) {
            this(this$0, label, null);
        }
    }
}

