/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.preference;

import io.github.dsheirer.gui.preference.DecodeEventViewPreferenceEditor;
import io.github.dsheirer.gui.preference.PreferenceEditorType;
import io.github.dsheirer.gui.preference.TalkgroupFormatPreferenceEditor;
import io.github.dsheirer.gui.preference.application.ApplicationPreferenceEditor;
import io.github.dsheirer.gui.preference.calibration.VectorCalibrationPreferenceEditor;
import io.github.dsheirer.gui.preference.decoder.JmbeLibraryPreferenceEditor;
import io.github.dsheirer.gui.preference.directory.DirectoryPreferenceEditor;
import io.github.dsheirer.gui.preference.duplicate.DuplicateCallPreferenceEditor;
import io.github.dsheirer.gui.preference.mp3.MP3PreferenceEditor;
import io.github.dsheirer.gui.preference.playback.PlaybackPreferenceEditor;
import io.github.dsheirer.gui.preference.record.RecordPreferenceEditor;
import io.github.dsheirer.gui.preference.tuner.TunerPreferenceEditor;
import io.github.dsheirer.preference.UserPreferences;
import javafx.scene.Node;

public class PreferenceEditorFactory {
    public static Node getEditor(PreferenceEditorType preferenceEditorType, UserPreferences userPreferences) {
        switch (preferenceEditorType) {
            case APPLICATION: {
                return new ApplicationPreferenceEditor(userPreferences);
            }
            case AUDIO_DUPLICATE_CALL_DETECTION: {
                return new DuplicateCallPreferenceEditor(userPreferences);
            }
            case AUDIO_MP3: {
                return new MP3PreferenceEditor(userPreferences);
            }
            case AUDIO_OUTPUT: {
                return new PlaybackPreferenceEditor(userPreferences);
            }
            case AUDIO_RECORD: {
                return new RecordPreferenceEditor(userPreferences);
            }
            case CHANNEL_EVENT: {
                return new DecodeEventViewPreferenceEditor(userPreferences);
            }
            case DIRECTORY: {
                return new DirectoryPreferenceEditor(userPreferences);
            }
            case JMBE_LIBRARY: {
                return new JmbeLibraryPreferenceEditor(userPreferences);
            }
            case SOURCE_TUNERS: {
                return new TunerPreferenceEditor(userPreferences);
            }
            case TALKGROUP_FORMAT: {
                return new TalkgroupFormatPreferenceEditor(userPreferences);
            }
            case VECTOR_CALIBRATION: {
                return new VectorCalibrationPreferenceEditor(userPreferences);
            }
        }
        return null;
    }
}

