/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.streaming;

import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastFactory;
import io.github.dsheirer.audio.broadcast.BroadcastFormat;
import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import io.github.dsheirer.audio.broadcast.ConfiguredBroadcast;
import io.github.dsheirer.audio.broadcast.broadcastify.BroadcastifyFeedConfiguration;
import io.github.dsheirer.gui.playlist.streaming.AbstractBroadcastEditor;
import io.github.dsheirer.gui.playlist.streaming.StreamAliasSelectionEditor;
import io.github.dsheirer.gui.playlist.streaming.StreamEditorFactory;
import io.github.dsheirer.gui.playlist.streaming.UnknownStreamEditor;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.rrapi.type.UserFeedBroadcast;
import io.github.dsheirer.util.ThreadPool;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingEditor
extends SplitPane {
    private static final Logger mLog = LoggerFactory.getLogger(StreamingEditor.class);
    private final PlaylistManager mPlaylistManager;
    private TableView<ConfiguredBroadcast> mConfiguredBroadcastTableView;
    private MenuButton mNewButton;
    private Button mDeleteButton;
    private Button mRefreshButton;
    private TabPane mTabPane;
    private Tab mConfigurationTab;
    private Tab mAliasTab;
    private Label mRadioReferenceLoginLabel;
    private AbstractBroadcastEditor<?> mCurrentEditor;
    private final UnknownStreamEditor mUnknownEditor;
    private Map<BroadcastServerType, AbstractBroadcastEditor<?>> mEditorMap = new EnumMap(BroadcastServerType.class);
    private final List<UserFeedBroadcast> mBroadcastifyFeeds = new ArrayList<UserFeedBroadcast>();
    private ScrollPane mEditorScrollPane;
    private StreamAliasSelectionEditor mStreamAliasSelectionEditor;
    private final StreamConfigurationEditorModificationListener mStreamConfigurationEditorModificationListener = new StreamConfigurationEditorModificationListener();

    public StreamingEditor(PlaylistManager playlistManager) {
        this.mPlaylistManager = playlistManager;
        this.mUnknownEditor = new UnknownStreamEditor(this.mPlaylistManager);
        this.mPlaylistManager.getRadioReference().availableProperty().addListener((observable, oldValue, newValue) -> this.refreshBroadcastifyStreams());
        this.refreshBroadcastifyStreams();
        VBox buttonsBox = new VBox();
        buttonsBox.getChildren().addAll((Object[])new Node[]{this.getNewButton(), this.getDeleteButton(), this.getRefreshButton()});
        buttonsBox.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        buttonsBox.setSpacing(10.0);
        VBox tableAndLabelBox = new VBox();
        VBox.setVgrow(this.getConfiguredBroadcastTableView(), (Priority)Priority.ALWAYS);
        tableAndLabelBox.getChildren().addAll((Object[])new Node[]{this.getConfiguredBroadcastTableView(), this.getRadioReferenceLoginLabel()});
        HBox editorBox = new HBox();
        editorBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        HBox.setHgrow((Node)tableAndLabelBox, (Priority)Priority.ALWAYS);
        editorBox.getChildren().addAll((Object[])new Node[]{tableAndLabelBox, buttonsBox});
        editorBox.setPrefHeight(50.0);
        this.setOrientation(Orientation.VERTICAL);
        this.getItems().addAll((Object[])new Node[]{editorBox, this.getTabPane()});
    }

    private void setEditor(AbstractBroadcastEditor<?> editor) {
        if (editor != this.getCurrentEditor()) {
            if (this.mCurrentEditor != null) {
                this.mCurrentEditor.modifiedProperty().removeListener((ChangeListener)this.mStreamConfigurationEditorModificationListener);
            }
            this.mCurrentEditor = editor;
            this.mCurrentEditor.modifiedProperty().addListener((ChangeListener)this.mStreamConfigurationEditorModificationListener);
            this.getEditorScrollPane().setContent((Node)this.getCurrentEditor());
        }
    }

    private ScrollPane getEditorScrollPane() {
        if (this.mEditorScrollPane == null) {
            this.mEditorScrollPane = new ScrollPane();
            this.mEditorScrollPane.setMaxWidth(Double.MAX_VALUE);
            this.mEditorScrollPane.setFitToWidth(true);
            this.mEditorScrollPane.setContent((Node)this.getCurrentEditor());
        }
        return this.mEditorScrollPane;
    }

    private void setBroadcastConfiguration(ConfiguredBroadcast configuredBroadcast) {
        if (this.getCurrentEditor().modifiedProperty().get()) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.getButtonTypes().clear();
            alert.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.NO, ButtonType.YES});
            alert.setTitle("Save Changes");
            alert.setHeaderText("Streaming configuration has been modified");
            alert.setContentText("Do you want to save these changes?");
            alert.initOwner(this.getNewButton().getScene().getWindow());
            alert.setResizable(true);
            alert.onShownProperty().addListener(e -> Platform.runLater(() -> alert.setResizable(false)));
            alert.showAndWait().ifPresent(buttonType -> {
                if (buttonType == ButtonType.YES) {
                    this.getCurrentEditor().save();
                }
            });
        }
        this.getDeleteButton().setDisable(configuredBroadcast == null);
        if (configuredBroadcast == null) {
            this.setEditor(this.mUnknownEditor);
        } else {
            BroadcastServerType configType = configuredBroadcast.getBroadcastServerType();
            if (configType == null) {
                this.setEditor(this.mUnknownEditor);
            } else {
                BroadcastServerType editorType = this.getCurrentEditor().getBroadcastServerType();
                if (editorType == null || editorType != configType) {
                    AbstractBroadcastEditor editor = this.mEditorMap.get((Object)configType);
                    if (editor == null && (editor = StreamEditorFactory.getEditor(configType, this.mPlaylistManager)) != null) {
                        this.mEditorMap.put(configType, editor);
                    }
                    if (editor == null) {
                        editor = this.mUnknownEditor;
                    }
                    this.setEditor(editor);
                }
            }
        }
        BroadcastConfiguration broadcastConfiguration = configuredBroadcast != null ? configuredBroadcast.getBroadcastConfiguration() : null;
        this.getCurrentEditor().setItem(broadcastConfiguration);
        this.getStreamAliasSelectionEditor().setBroadcastConfiguration(broadcastConfiguration);
    }

    private void refreshBroadcastifyStreams() {
        if (this.mPlaylistManager.getRadioReference().availableProperty().get()) {
            ThreadPool.CACHED.submit(() -> {
                try {
                    List feeds = this.mPlaylistManager.getRadioReference().getService().getUserFeeds();
                    this.mBroadcastifyFeeds.clear();
                    this.mBroadcastifyFeeds.addAll(feeds);
                }
                catch (Throwable t) {
                    mLog.error("Unable to refresh broadcastify stream configuration(s)");
                }
            });
        }
    }

    private StreamAliasSelectionEditor getStreamAliasSelectionEditor() {
        if (this.mStreamAliasSelectionEditor == null) {
            this.mStreamAliasSelectionEditor = new StreamAliasSelectionEditor(this.mPlaylistManager);
        }
        return this.mStreamAliasSelectionEditor;
    }

    private Label getRadioReferenceLoginLabel() {
        if (this.mRadioReferenceLoginLabel == null) {
            this.mRadioReferenceLoginLabel = new Label("Note: use Radio Reference tab to login and access Broadcastify stream configuration(s)");
            this.mRadioReferenceLoginLabel.visibleProperty().bind((ObservableValue)this.mPlaylistManager.getRadioReference().availableProperty().not());
        }
        return this.mRadioReferenceLoginLabel;
    }

    private AbstractBroadcastEditor getCurrentEditor() {
        if (this.mCurrentEditor == null) {
            this.mCurrentEditor = this.mUnknownEditor;
        }
        return this.mCurrentEditor;
    }

    private TabPane getTabPane() {
        if (this.mTabPane == null) {
            this.mTabPane = new TabPane();
            this.mTabPane.setMaxHeight(Double.MAX_VALUE);
            this.mTabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
            this.mTabPane.getTabs().addAll((Object[])new Tab[]{this.getConfigurationTab(), this.getAliasTab()});
        }
        return this.mTabPane;
    }

    private Tab getConfigurationTab() {
        if (this.mConfigurationTab == null) {
            this.mConfigurationTab = new Tab("Configuration");
            this.mConfigurationTab.setContent((Node)this.getEditorScrollPane());
        }
        return this.mConfigurationTab;
    }

    private Tab getAliasTab() {
        if (this.mAliasTab == null) {
            this.mAliasTab = new Tab("Aliases");
            this.mAliasTab.setContent((Node)this.getStreamAliasSelectionEditor());
        }
        return this.mAliasTab;
    }

    private MenuButton getNewButton() {
        if (this.mNewButton == null) {
            this.mNewButton = new MenuButton("New");
            this.mNewButton.setMaxWidth(Double.MAX_VALUE);
            this.mNewButton.setOnShowing(event -> {
                this.mNewButton.getItems().clear();
                for (UserFeedBroadcast feed : this.mBroadcastifyFeeds) {
                    if (this.mPlaylistManager.getBroadcastModel().getBroadcastConfiguration(feed.getDescription()) != null) continue;
                    this.mNewButton.getItems().add((Object)new CreateBroadcastifyMenuItem(feed));
                }
                for (BroadcastServerType type : BroadcastServerType.values()) {
                    if (type == BroadcastServerType.BROADCASTIFY || type == BroadcastServerType.UNKNOWN) continue;
                    this.mNewButton.getItems().add((Object)new CreateBroadcastConfigurationMenuItem(type));
                }
            });
        }
        return this.mNewButton;
    }

    private Button getRefreshButton() {
        if (this.mRefreshButton == null) {
            this.mRefreshButton = new Button("Refresh");
            this.mRefreshButton.setTooltip(new Tooltip("Refresh streams available from Broadcastify"));
            this.mRefreshButton.setOnAction(event -> this.refreshBroadcastifyStreams());
        }
        return this.mRefreshButton;
    }

    private Button getDeleteButton() {
        if (this.mDeleteButton == null) {
            this.mDeleteButton = new Button("Delete");
            this.mDeleteButton.setMaxWidth(Double.MAX_VALUE);
            this.mDeleteButton.setOnAction(event -> {
                BroadcastConfiguration config = ((ConfiguredBroadcast)this.getConfiguredBroadcastTableView().getSelectionModel().getSelectedItem()).getBroadcastConfiguration();
                if (config != null) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to delete the selected stream?", new ButtonType[]{ButtonType.NO, ButtonType.YES});
                    alert.setTitle("Delete Stream Configuration");
                    alert.setHeaderText("Are you sure?");
                    alert.initOwner(this.getDeleteButton().getScene().getWindow());
                    Optional result = alert.showAndWait();
                    if (result.get() == ButtonType.YES) {
                        this.mPlaylistManager.getBroadcastModel().removeBroadcastConfiguration(config);
                    }
                }
            });
        }
        return this.mDeleteButton;
    }

    private TableView<ConfiguredBroadcast> getConfiguredBroadcastTableView() {
        if (this.mConfiguredBroadcastTableView == null) {
            this.mConfiguredBroadcastTableView = new TableView();
            this.mConfiguredBroadcastTableView.setPlaceholder((Node)new Label("Click the New button to create a new audio streaming configuration"));
            this.mConfiguredBroadcastTableView.setItems(this.mPlaylistManager.getBroadcastModel().getConfiguredBroadcasts());
            TableColumn enabledColumn = new TableColumn("Enabled");
            enabledColumn.setCellValueFactory((Callback)new PropertyValueFactory("enabled"));
            enabledColumn.setCellFactory(param -> {
                TableCell<ConfiguredBroadcast, Boolean> tableCell = new TableCell<ConfiguredBroadcast, Boolean>(this){

                    protected void updateItem(Boolean item, boolean empty) {
                        this.setAlignment(Pos.CENTER);
                        this.setText(null);
                        if (empty || item == null || !item.booleanValue()) {
                            this.setGraphic(null);
                        } else {
                            IconNode iconNode = new IconNode((IconCode)FontAwesome.CHECK);
                            iconNode.setFill((Paint)Color.GREEN);
                            this.setGraphic((Node)iconNode);
                        }
                    }
                };
                return tableCell;
            });
            TableColumn nameColumn = new TableColumn("Name");
            nameColumn.setPrefWidth(300.0);
            nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
            TableColumn typeColumn = new TableColumn();
            typeColumn.setPrefWidth(125.0);
            typeColumn.setText("Format");
            typeColumn.setCellValueFactory((Callback)new PropertyValueFactory("broadcastServerType"));
            TableColumn stateColumn = new TableColumn("Stream Status");
            stateColumn.setCellValueFactory((Callback)new PropertyValueFactory("broadcastState"));
            this.mConfiguredBroadcastTableView.getColumns().addAll((Object[])new TableColumn[]{enabledColumn, nameColumn, typeColumn, stateColumn});
            this.mConfiguredBroadcastTableView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.setBroadcastConfiguration((ConfiguredBroadcast)newValue));
        }
        return this.mConfiguredBroadcastTableView;
    }

    public class StreamConfigurationEditorModificationListener
    implements ChangeListener<Boolean> {
        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            ConfiguredBroadcast configuredBroadcast;
            if (oldValue != null && newValue != null && oldValue.booleanValue() && !newValue.booleanValue() && (configuredBroadcast = (ConfiguredBroadcast)StreamingEditor.this.getConfiguredBroadcastTableView().getSelectionModel().getSelectedItem()) != null) {
                StreamingEditor.this.getConfiguredBroadcastTableView().getSelectionModel().select(null);
                StreamingEditor.this.getConfiguredBroadcastTableView().getSelectionModel().select((Object)configuredBroadcast);
            }
        }
    }

    public class CreateBroadcastifyMenuItem
    extends MenuItem {
        private UserFeedBroadcast mUserFeedBroadcast;

        public CreateBroadcastifyMenuItem(UserFeedBroadcast userFeedBroadcast) {
            this.mUserFeedBroadcast = userFeedBroadcast;
            this.setText("Broadcastify Feed: " + this.mUserFeedBroadcast.getDescription());
            this.setOnAction(event -> {
                BroadcastifyFeedConfiguration configuration = BroadcastifyFeedConfiguration.from(this.mUserFeedBroadcast);
                if (configuration != null) {
                    ConfiguredBroadcast configuredBroadcast = StreamingEditor.this.mPlaylistManager.getBroadcastModel().addBroadcastConfiguration(configuration);
                    StreamingEditor.this.getConfiguredBroadcastTableView().getSelectionModel().select((Object)configuredBroadcast);
                }
            });
        }
    }

    public class CreateBroadcastConfigurationMenuItem
    extends MenuItem {
        private BroadcastServerType mBroadcastServerType;

        public CreateBroadcastConfigurationMenuItem(BroadcastServerType type) {
            this.setText(type.toString());
            this.mBroadcastServerType = type;
            this.setOnAction(event -> {
                BroadcastConfiguration config = BroadcastFactory.getConfiguration(this.mBroadcastServerType, BroadcastFormat.MP3);
                ConfiguredBroadcast configuredBroadcast = StreamingEditor.this.mPlaylistManager.getBroadcastModel().addBroadcastConfiguration(config);
                StreamingEditor.this.getConfiguredBroadcastTableView().getSelectionModel().select((Object)configuredBroadcast);
            });
        }
    }
}

