/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.streaming;

import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import io.github.dsheirer.audio.broadcast.shoutcast.v2.ShoutcastV2Configuration;
import io.github.dsheirer.gui.control.IntegerTextField;
import io.github.dsheirer.gui.playlist.streaming.AbstractStreamEditor;
import io.github.dsheirer.playlist.PlaylistManager;
import javafx.beans.value.ChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import org.controlsfx.control.ToggleSwitch;

public class ShoutcastV2StreamEditor
extends AbstractStreamEditor<ShoutcastV2Configuration> {
    private GridPane mEditorPane;
    private TextField mUserIdTextField;
    private IntegerTextField mStreamIdTextField;
    private TextField mUrlTextField;
    private TextField mGenreTextField;
    private ToggleSwitch mPublicToggleSwitch;

    public ShoutcastV2StreamEditor(PlaylistManager playlistManager) {
        super(playlistManager);
    }

    @Override
    public BroadcastServerType getBroadcastServerType() {
        return BroadcastServerType.SHOUTCAST_V2;
    }

    @Override
    public void setItem(ShoutcastV2Configuration item) {
        super.setItem(item);
        this.getUrlTextField().setDisable(item == null);
        this.getGenreTextField().setDisable(item == null);
        this.getPublicToggleSwitch().setDisable(item == null);
        this.getUserIdTextField().setDisable(item == null);
        this.getStreamIdTextField().setDisable(item == null);
        if (item != null) {
            this.getUrlTextField().setText(item.getURL());
            this.getGenreTextField().setText(item.getGenre());
            this.getPublicToggleSwitch().setSelected(item.isPublic());
            this.getStreamIdTextField().set(item.getStreamID());
            this.getUserIdTextField().setText(item.getUserID());
        } else {
            this.getUrlTextField().setText(null);
            this.getGenreTextField().setText(null);
            this.getPublicToggleSwitch().setSelected(false);
            this.getStreamIdTextField().set(0);
            this.getUserIdTextField().setText(null);
        }
        this.modifiedProperty().set(false);
    }

    @Override
    public void save() {
        if (this.getItem() != null) {
            ((ShoutcastV2Configuration)this.getItem()).setURL(this.getUrlTextField().getText());
            ((ShoutcastV2Configuration)this.getItem()).setGenre(this.getGenreTextField().getText());
            ((ShoutcastV2Configuration)this.getItem()).setPublic(this.getPublicToggleSwitch().isSelected());
            ((ShoutcastV2Configuration)this.getItem()).setUserID(this.getUserIdTextField().getText());
            ((ShoutcastV2Configuration)this.getItem()).setStreamID(this.getStreamIdTextField().get());
        }
        super.save();
    }

    @Override
    protected GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            this.mEditorPane = new GridPane();
            this.mEditorPane.setPadding(new Insets(10.0, 5.0, 10.0, 10.0));
            this.mEditorPane.setVgap(10.0);
            this.mEditorPane.setHgap(5.0);
            Label formatLabel = new Label("Format");
            GridPane.setHalignment((Node)formatLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)formatLabel, (int)0, (int)0);
            this.mEditorPane.getChildren().add((Object)formatLabel);
            this.getFormatField().setText(this.getBroadcastServerType().toString());
            GridPane.setConstraints((Node)this.getFormatField(), (int)1, (int)0);
            this.mEditorPane.getChildren().add((Object)this.getFormatField());
            Label enabledLabel = new Label("Enabled");
            GridPane.setHalignment((Node)enabledLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)enabledLabel, (int)2, (int)0);
            this.mEditorPane.getChildren().add((Object)enabledLabel);
            GridPane.setConstraints((Node)this.getEnabledSwitch(), (int)3, (int)0);
            this.mEditorPane.getChildren().add((Object)this.getEnabledSwitch());
            Label systemLabel = new Label("Name");
            GridPane.setHalignment((Node)systemLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)systemLabel, (int)0, (int)1);
            this.mEditorPane.getChildren().add((Object)systemLabel);
            GridPane.setConstraints((Node)this.getNameTextField(), (int)1, (int)1);
            this.mEditorPane.getChildren().add((Object)this.getNameTextField());
            Label publicLabel = new Label("Public");
            GridPane.setHalignment((Node)publicLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)publicLabel, (int)2, (int)1);
            this.mEditorPane.getChildren().add((Object)publicLabel);
            GridPane.setConstraints((Node)this.getPublicToggleSwitch(), (int)3, (int)1);
            this.mEditorPane.getChildren().add((Object)this.getPublicToggleSwitch());
            Label hostLabel = new Label("Server");
            GridPane.setHalignment((Node)hostLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)hostLabel, (int)0, (int)2);
            this.mEditorPane.getChildren().add((Object)hostLabel);
            GridPane.setConstraints((Node)this.getHostTextField(), (int)1, (int)2);
            this.mEditorPane.getChildren().add((Object)this.getHostTextField());
            Label portLabel = new Label("Port");
            GridPane.setHalignment((Node)portLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)portLabel, (int)2, (int)2);
            this.mEditorPane.getChildren().add((Object)portLabel);
            GridPane.setConstraints((Node)this.getPortTextField(), (int)3, (int)2);
            this.mEditorPane.getChildren().add((Object)this.getPortTextField());
            Label userIdLabel = new Label("User ID");
            GridPane.setHalignment((Node)userIdLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)userIdLabel, (int)0, (int)3);
            this.mEditorPane.getChildren().add((Object)userIdLabel);
            GridPane.setConstraints((Node)this.getUserIdTextField(), (int)1, (int)3);
            this.mEditorPane.getChildren().add((Object)this.getUserIdTextField());
            Label streamIdLabel = new Label("Stream ID");
            GridPane.setHalignment((Node)streamIdLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)streamIdLabel, (int)2, (int)3);
            this.mEditorPane.getChildren().add((Object)streamIdLabel);
            GridPane.setConstraints((Node)this.getStreamIdTextField(), (int)3, (int)3);
            this.mEditorPane.getChildren().add((Object)this.getStreamIdTextField());
            Label passwordLabel = new Label("Password");
            GridPane.setHalignment((Node)passwordLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)passwordLabel, (int)0, (int)4);
            this.mEditorPane.getChildren().add((Object)passwordLabel);
            GridPane.setConstraints((Node)this.getMaskedPasswordTextField(), (int)1, (int)4);
            this.mEditorPane.getChildren().add((Object)this.getMaskedPasswordTextField());
            GridPane.setConstraints((Node)this.getUnMaskedPasswordTextField(), (int)1, (int)4);
            this.mEditorPane.getChildren().add((Object)this.getUnMaskedPasswordTextField());
            GridPane.setConstraints((Node)this.getShowPasswordCheckBox(), (int)2, (int)4);
            this.mEditorPane.getChildren().add((Object)this.getShowPasswordCheckBox());
            Label maxAgeLabel = new Label("Max Recording Age (seconds)");
            GridPane.setHalignment((Node)maxAgeLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)maxAgeLabel, (int)0, (int)5);
            this.mEditorPane.getChildren().add((Object)maxAgeLabel);
            GridPane.setConstraints((Node)this.getMaxAgeTextField(), (int)1, (int)5);
            this.mEditorPane.getChildren().add((Object)this.getMaxAgeTextField());
            Label delayLabel = new Label("Delay (seconds)");
            GridPane.setHalignment((Node)delayLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)delayLabel, (int)2, (int)5);
            this.mEditorPane.getChildren().add((Object)delayLabel);
            GridPane.setConstraints((Node)this.getDelayTextField(), (int)3, (int)5);
            this.mEditorPane.getChildren().add((Object)this.getDelayTextField());
            Label descriptionLabel = new Label("Description");
            GridPane.setHalignment((Node)descriptionLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)descriptionLabel, (int)0, (int)6);
            this.mEditorPane.getChildren().add((Object)descriptionLabel);
            GridPane.setConstraints((Node)this.getUrlTextField(), (int)1, (int)6, (int)3, (int)1);
            this.mEditorPane.getChildren().add((Object)this.getUrlTextField());
            Label genreLabel = new Label("Genre");
            GridPane.setHalignment((Node)genreLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)genreLabel, (int)0, (int)7);
            this.mEditorPane.getChildren().add((Object)genreLabel);
            GridPane.setConstraints((Node)this.getGenreTextField(), (int)1, (int)7, (int)3, (int)1);
            this.mEditorPane.getChildren().add((Object)this.getGenreTextField());
        }
        return this.mEditorPane;
    }

    private TextField getUserIdTextField() {
        if (this.mUserIdTextField == null) {
            this.mUserIdTextField = new TextField();
            this.mUserIdTextField.setDisable(true);
            this.mUserIdTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mUserIdTextField;
    }

    private IntegerTextField getStreamIdTextField() {
        if (this.mStreamIdTextField == null) {
            this.mStreamIdTextField = new IntegerTextField();
            this.mStreamIdTextField.setDisable(true);
            this.mStreamIdTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mStreamIdTextField;
    }

    private TextField getUrlTextField() {
        if (this.mUrlTextField == null) {
            this.mUrlTextField = new TextField();
            this.mUrlTextField.setDisable(true);
            this.mUrlTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mUrlTextField;
    }

    private TextField getGenreTextField() {
        if (this.mGenreTextField == null) {
            this.mGenreTextField = new TextField();
            this.mGenreTextField.setDisable(true);
            this.mGenreTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mGenreTextField;
    }

    private ToggleSwitch getPublicToggleSwitch() {
        if (this.mPublicToggleSwitch == null) {
            this.mPublicToggleSwitch = new ToggleSwitch();
            this.mPublicToggleSwitch.setDisable(true);
            this.mPublicToggleSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mPublicToggleSwitch;
    }
}

