/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.streaming;

import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import io.github.dsheirer.audio.broadcast.rdioscanner.RdioScannerConfiguration;
import io.github.dsheirer.gui.control.IntegerTextField;
import io.github.dsheirer.gui.playlist.streaming.AbstractBroadcastEditor;
import io.github.dsheirer.playlist.PlaylistManager;
import javafx.beans.value.ChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdioScannerEditor
extends AbstractBroadcastEditor<RdioScannerConfiguration> {
    private static final Logger mLog = LoggerFactory.getLogger(RdioScannerEditor.class);
    private static final String API_PATH = "/api/call-upload";
    private IntegerTextField mSystemIdTextField;
    private IntegerTextField mMaxAgeTextField;
    private TextField mApiKeyTextField;
    private TextField mHostTextField;
    private GridPane mEditorPane;

    public RdioScannerEditor(PlaylistManager playlistManager) {
        super(playlistManager);
    }

    @Override
    public void setItem(RdioScannerConfiguration item) {
        super.setItem(item);
        this.getSystemIdTextField().setDisable(item == null);
        this.getApiKeyTextField().setDisable(item == null);
        this.getHostTextField().setDisable(item == null);
        this.getMaxAgeTextField().setDisable(item == null);
        if (item != null) {
            this.getSystemIdTextField().set(item.getSystemID());
            this.getApiKeyTextField().setText(item.getApiKey());
            String url = item.getHost();
            if (url != null) {
                url = url.replace(API_PATH, "");
            }
            this.getHostTextField().setText(url);
            this.getMaxAgeTextField().set((int)(item.getMaximumRecordingAge() / 1000L));
        } else {
            this.getSystemIdTextField().set(0);
            this.getApiKeyTextField().setText(null);
            this.getHostTextField().setText(null);
            this.getMaxAgeTextField().set(0);
        }
        this.modifiedProperty().set(false);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void save() {
        if (this.getItem() != null) {
            int systemID = this.getSystemIdTextField().get() != null ? this.getSystemIdTextField().get() : 0;
            ((RdioScannerConfiguration)this.getItem()).setSystemID(systemID);
            Object host = this.getHostTextField().getText();
            if (host != null) {
                host = ((String)host).replace(API_PATH, "");
                host = (String)host + API_PATH;
                ((RdioScannerConfiguration)this.getItem()).setHost((String)host);
            }
            ((RdioScannerConfiguration)this.getItem()).setApiKey(this.getApiKeyTextField().getText());
            ((RdioScannerConfiguration)this.getItem()).setMaximumRecordingAge(this.getMaxAgeTextField().get() * 1000);
        }
        super.save();
    }

    @Override
    public BroadcastServerType getBroadcastServerType() {
        return BroadcastServerType.RDIOSCANNER_CALL;
    }

    @Override
    protected GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            this.mEditorPane = new GridPane();
            this.mEditorPane.setPadding(new Insets(10.0, 5.0, 10.0, 10.0));
            this.mEditorPane.setVgap(10.0);
            this.mEditorPane.setHgap(5.0);
            int row = 0;
            Label formatLabel = new Label("Format");
            GridPane.setHalignment((Node)formatLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)formatLabel, (int)0, (int)row);
            this.mEditorPane.getChildren().add((Object)formatLabel);
            GridPane.setConstraints((Node)this.getFormatField(), (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getFormatField());
            Label enabledLabel = new Label("Enabled");
            GridPane.setHalignment((Node)enabledLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)enabledLabel, (int)2, (int)row);
            this.mEditorPane.getChildren().add((Object)enabledLabel);
            GridPane.setConstraints((Node)this.getEnabledSwitch(), (int)3, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getEnabledSwitch());
            Label systemLabel = new Label("Name");
            GridPane.setHalignment((Node)systemLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)systemLabel, (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)systemLabel);
            GridPane.setConstraints((Node)this.getNameTextField(), (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getNameTextField());
            Label apiKeyLabel = new Label("API Key");
            GridPane.setHalignment((Node)apiKeyLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)apiKeyLabel, (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)apiKeyLabel);
            GridPane.setConstraints((Node)this.getApiKeyTextField(), (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getApiKeyTextField());
            Label systemIdLabel = new Label("System ID");
            GridPane.setHalignment((Node)systemIdLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)systemIdLabel, (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)systemIdLabel);
            GridPane.setConstraints((Node)this.getSystemIdTextField(), (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getSystemIdTextField());
            Label hostLabel = new Label("RdioScanner URL");
            GridPane.setHalignment((Node)hostLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)hostLabel, (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)hostLabel);
            GridPane.setConstraints((Node)this.getHostTextField(), (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getHostTextField());
            Label apiPath = new Label(API_PATH);
            GridPane.setHalignment((Node)apiPath, (HPos)HPos.LEFT);
            GridPane.setConstraints((Node)apiPath, (int)2, (int)row);
            this.mEditorPane.getChildren().add((Object)apiPath);
            Label maxAgeLabel = new Label("Max Recording Age (seconds)");
            GridPane.setHalignment((Node)maxAgeLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)maxAgeLabel, (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)maxAgeLabel);
            GridPane.setConstraints((Node)this.getMaxAgeTextField(), (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getMaxAgeTextField());
        }
        return this.mEditorPane;
    }

    private IntegerTextField getMaxAgeTextField() {
        if (this.mMaxAgeTextField == null) {
            this.mMaxAgeTextField = new IntegerTextField();
            this.mMaxAgeTextField.setDisable(true);
            this.mMaxAgeTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mMaxAgeTextField;
    }

    private TextField getHostTextField() {
        if (this.mHostTextField == null) {
            this.mHostTextField = new TextField();
            this.mHostTextField.setDisable(true);
            this.mHostTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mHostTextField;
    }

    private TextField getApiKeyTextField() {
        if (this.mApiKeyTextField == null) {
            this.mApiKeyTextField = new TextField();
            this.mApiKeyTextField.setDisable(true);
            this.mApiKeyTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mApiKeyTextField;
    }

    private IntegerTextField getSystemIdTextField() {
        if (this.mSystemIdTextField == null) {
            this.mSystemIdTextField = new IntegerTextField();
            this.mSystemIdTextField.setDisable(true);
            this.mSystemIdTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mSystemIdTextField;
    }
}

