/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.streaming;

import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import io.github.dsheirer.audio.broadcast.broadcastify.BroadcastifyCallBroadcaster;
import io.github.dsheirer.audio.broadcast.broadcastify.BroadcastifyCallConfiguration;
import io.github.dsheirer.gui.control.IntegerTextField;
import io.github.dsheirer.gui.playlist.streaming.AbstractBroadcastEditor;
import io.github.dsheirer.playlist.PlaylistManager;
import javafx.beans.value.ChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import org.controlsfx.control.ToggleSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastifyCallEditor
extends AbstractBroadcastEditor<BroadcastifyCallConfiguration> {
    private static final Logger mLog = LoggerFactory.getLogger(BroadcastifyCallEditor.class);
    private IntegerTextField mSystemIdTextField;
    private Button mTestButton;
    private IntegerTextField mMaxAgeTextField;
    private TextField mApiKeyTextField;
    private TextField mHostTextField;
    private GridPane mEditorPane;
    private ToggleSwitch mTestEnabledToggleSwitch;
    private IntegerTextField mTestIntervalTextField;

    public BroadcastifyCallEditor(PlaylistManager playlistManager) {
        super(playlistManager);
    }

    @Override
    public void setItem(BroadcastifyCallConfiguration item) {
        super.setItem(item);
        this.getSystemIdTextField().setDisable(item == null);
        this.getApiKeyTextField().setDisable(item == null);
        this.getHostTextField().setDisable(item == null);
        this.getMaxAgeTextField().setDisable(item == null);
        this.getTestEnabledToggleSwitch().setDisable(item == null);
        this.getTestIntervalTextField().setDisable(item == null);
        if (item != null) {
            this.getSystemIdTextField().set(item.getSystemID());
            this.getApiKeyTextField().setText(item.getApiKey());
            this.getHostTextField().setText(item.getHost());
            this.getMaxAgeTextField().set((int)(item.getMaximumRecordingAge() / 1000L));
            this.getTestEnabledToggleSwitch().setSelected(item.isTestEnabled());
            this.getTestIntervalTextField().set(item.getTestInterval());
        } else {
            this.getSystemIdTextField().set(0);
            this.getApiKeyTextField().setText(null);
            this.getHostTextField().setText(null);
            this.getMaxAgeTextField().set(0);
            this.getTestEnabledToggleSwitch().setSelected(false);
            this.getTestIntervalTextField().set(15);
        }
        this.modifiedProperty().set(false);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void save() {
        if (this.getItem() != null) {
            int systemID = this.getSystemIdTextField().get() != null ? this.getSystemIdTextField().get() : 0;
            ((BroadcastifyCallConfiguration)this.getItem()).setSystemID(systemID);
            ((BroadcastifyCallConfiguration)this.getItem()).setHost(this.getHostTextField().getText());
            ((BroadcastifyCallConfiguration)this.getItem()).setApiKey(this.getApiKeyTextField().getText());
            ((BroadcastifyCallConfiguration)this.getItem()).setMaximumRecordingAge(this.getMaxAgeTextField().get() * 1000);
            ((BroadcastifyCallConfiguration)this.getItem()).setTestEnabled(this.getTestEnabledToggleSwitch().isSelected());
            ((BroadcastifyCallConfiguration)this.getItem()).setTestInterval(this.getTestIntervalTextField().get());
        }
        super.save();
    }

    @Override
    public BroadcastServerType getBroadcastServerType() {
        return BroadcastServerType.BROADCASTIFY_CALL;
    }

    @Override
    protected GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            this.mEditorPane = new GridPane();
            this.mEditorPane.setPadding(new Insets(10.0, 5.0, 10.0, 10.0));
            this.mEditorPane.setVgap(10.0);
            this.mEditorPane.setHgap(5.0);
            int row = 0;
            Label formatLabel = new Label("Format");
            GridPane.setHalignment((Node)formatLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)formatLabel, (int)0, (int)row);
            this.mEditorPane.getChildren().add((Object)formatLabel);
            GridPane.setConstraints((Node)this.getFormatField(), (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getFormatField());
            Label enabledLabel = new Label("Enabled");
            GridPane.setHalignment((Node)enabledLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)enabledLabel, (int)2, (int)row);
            this.mEditorPane.getChildren().add((Object)enabledLabel);
            GridPane.setConstraints((Node)this.getEnabledSwitch(), (int)3, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getEnabledSwitch());
            Label systemLabel = new Label("Name");
            GridPane.setHalignment((Node)systemLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)systemLabel, (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)systemLabel);
            GridPane.setConstraints((Node)this.getNameTextField(), (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getNameTextField());
            Label apiKeyLabel = new Label("API Key");
            GridPane.setHalignment((Node)apiKeyLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)apiKeyLabel, (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)apiKeyLabel);
            GridPane.setConstraints((Node)this.getApiKeyTextField(), (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getApiKeyTextField());
            Label systemIdLabel = new Label("System ID");
            GridPane.setHalignment((Node)systemIdLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)systemIdLabel, (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)systemIdLabel);
            GridPane.setConstraints((Node)this.getSystemIdTextField(), (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getSystemIdTextField());
            Label hostLabel = new Label("Broadcastify URL");
            GridPane.setHalignment((Node)hostLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)hostLabel, (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)hostLabel);
            GridPane.setConstraints((Node)this.getHostTextField(), (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getHostTextField());
            Label maxAgeLabel = new Label("Max Recording Age (seconds)");
            GridPane.setHalignment((Node)maxAgeLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)maxAgeLabel, (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)maxAgeLabel);
            GridPane.setConstraints((Node)this.getMaxAgeTextField(), (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getMaxAgeTextField());
            Label testEnabledLabel = new Label("Send Periodic Keep-Alive");
            GridPane.setHalignment((Node)testEnabledLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)testEnabledLabel, (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)testEnabledLabel);
            GridPane.setConstraints((Node)this.getTestEnabledToggleSwitch(), (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getTestEnabledToggleSwitch());
            Label testIntervalLabel = new Label("Ping Interval (minutes)");
            GridPane.setHalignment((Node)testIntervalLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)testIntervalLabel, (int)3, (int)row);
            this.mEditorPane.getChildren().add((Object)testIntervalLabel);
            GridPane.setConstraints((Node)this.getTestIntervalTextField(), (int)4, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getTestIntervalTextField());
            GridPane.setConstraints((Node)this.getTestButton(), (int)1, (int)(++row));
            this.mEditorPane.getChildren().add((Object)this.getTestButton());
        }
        return this.mEditorPane;
    }

    private IntegerTextField getMaxAgeTextField() {
        if (this.mMaxAgeTextField == null) {
            this.mMaxAgeTextField = new IntegerTextField();
            this.mMaxAgeTextField.setDisable(true);
            this.mMaxAgeTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mMaxAgeTextField;
    }

    private TextField getHostTextField() {
        if (this.mHostTextField == null) {
            this.mHostTextField = new TextField();
            this.mHostTextField.setDisable(true);
            this.mHostTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mHostTextField;
    }

    private TextField getApiKeyTextField() {
        if (this.mApiKeyTextField == null) {
            this.mApiKeyTextField = new TextField();
            this.mApiKeyTextField.setDisable(true);
            this.mApiKeyTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mApiKeyTextField;
    }

    private IntegerTextField getSystemIdTextField() {
        if (this.mSystemIdTextField == null) {
            this.mSystemIdTextField = new IntegerTextField();
            this.mSystemIdTextField.setDisable(true);
            this.mSystemIdTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mSystemIdTextField;
    }

    private ToggleSwitch getTestEnabledToggleSwitch() {
        if (this.mTestEnabledToggleSwitch == null) {
            this.mTestEnabledToggleSwitch = new ToggleSwitch();
            this.mTestEnabledToggleSwitch.setDisable(true);
            this.mTestEnabledToggleSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mTestEnabledToggleSwitch;
    }

    private IntegerTextField getTestIntervalTextField() {
        if (this.mTestIntervalTextField == null) {
            this.mTestIntervalTextField = new IntegerTextField();
            this.mTestIntervalTextField.setDisable(true);
            this.mTestIntervalTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mTestIntervalTextField;
    }

    private Button getTestButton() {
        if (this.mTestButton == null) {
            this.mTestButton = new Button("Test Connection");
            this.mTestButton.setOnAction(event -> {
                int systemID = this.getSystemIdTextField().get();
                String apiKey = this.getApiKeyTextField().getText();
                String host = this.getHostTextField().getText();
                if (apiKey == null || apiKey.isEmpty()) {
                    Alert alert = new Alert(Alert.AlertType.ERROR, "Please enter an API Key", new ButtonType[]{ButtonType.OK});
                    alert.setTitle("Test Connection");
                    alert.setHeaderText("A valid API Key is required");
                    alert.initOwner(this.getTestButton().getScene().getWindow());
                    alert.show();
                    return;
                }
                if (systemID < 1) {
                    Alert alert = new Alert(Alert.AlertType.ERROR, "Please enter a non-zero System ID", new ButtonType[]{ButtonType.OK});
                    alert.setTitle("Test Connection");
                    alert.setHeaderText("A valid System ID is required");
                    alert.initOwner(this.getTestButton().getScene().getWindow());
                    alert.show();
                    return;
                }
                if (host == null || host.isEmpty()) {
                    Alert alert = new Alert(Alert.AlertType.ERROR, "Please enter a Broadcastify URL", new ButtonType[]{ButtonType.OK});
                    alert.setTitle("Test Connection");
                    alert.setHeaderText("A valid URL for Broadcastify is required");
                    alert.initOwner(this.getTestButton().getScene().getWindow());
                    alert.show();
                    return;
                }
                BroadcastifyCallConfiguration configToTest = new BroadcastifyCallConfiguration();
                configToTest.setSystemID(systemID);
                configToTest.setApiKey(apiKey);
                configToTest.setHost(host);
                String result = BroadcastifyCallBroadcaster.testConnection(configToTest);
                if (result != null && result.toLowerCase().startsWith("ok")) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Test successful.", new ButtonType[]{ButtonType.OK});
                    alert.setTitle("Test Result");
                    alert.setHeaderText("Success!");
                    alert.initOwner(this.getTestButton().getScene().getWindow());
                    alert.show();
                    return;
                }
                String message = null;
                if (result != null && result.toLowerCase().startsWith("1 invalid-api-key")) {
                    message = "Invalid API Key";
                } else if (result != null && result.toLowerCase().startsWith("1 api-key-access-denied")) {
                    message = "Invalid System ID";
                }
                Alert alert = new Alert(Alert.AlertType.ERROR, "Error: " + message, new ButtonType[]{ButtonType.OK});
                alert.setTitle("Test Result");
                alert.setHeaderText("Test Failed.");
                alert.initOwner(this.getTestButton().getScene().getWindow());
                alert.show();
            });
        }
        return this.mTestButton;
    }
}

