/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.streaming;

import io.github.dsheirer.audio.broadcast.BroadcastConfiguration;
import io.github.dsheirer.audio.broadcast.BroadcastEvent;
import io.github.dsheirer.audio.broadcast.BroadcastServerType;
import io.github.dsheirer.gui.playlist.Editor;
import io.github.dsheirer.playlist.PlaylistManager;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.controlsfx.control.ToggleSwitch;

public abstract class AbstractBroadcastEditor<T extends BroadcastConfiguration>
extends Editor<T> {
    private PlaylistManager mPlaylistManager;
    private Button mSaveButton;
    private Button mResetButton;
    private TextField mFormatField;
    private TextField mNameTextField;
    private ToggleSwitch mEnabledSwitch;
    protected EditorModificationListener mEditorModificationListener = new EditorModificationListener();

    public AbstractBroadcastEditor(PlaylistManager playlistManager) {
        this.mPlaylistManager = playlistManager;
        this.getFormatField().setText(this.getBroadcastServerType().toString());
        VBox buttonBox = new VBox();
        buttonBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        buttonBox.setSpacing(10.0);
        buttonBox.getChildren().addAll((Object[])new Node[]{this.getSaveButton(), this.getResetButton()});
        HBox editorBox = new HBox();
        HBox.setHgrow((Node)this.getEditorPane(), (Priority)Priority.ALWAYS);
        editorBox.getChildren().addAll((Object[])new Node[]{this.getEditorPane(), buttonBox});
        this.getChildren().addAll((Object[])new Node[]{editorBox});
    }

    protected PlaylistManager getPlaylistManager() {
        return this.mPlaylistManager;
    }

    protected abstract GridPane getEditorPane();

    public abstract BroadcastServerType getBroadcastServerType();

    @Override
    public void setItem(T item) {
        super.setItem(item);
        this.getNameTextField().setDisable(item == null);
        this.getEnabledSwitch().setDisable(item == null);
        if (item != null) {
            this.getNameTextField().setText(((BroadcastConfiguration)item).getName());
            this.getEnabledSwitch().selectedProperty().set(((BroadcastConfiguration)item).isEnabled());
        } else {
            this.getNameTextField().setText(null);
            this.getEnabledSwitch().selectedProperty().set(false);
        }
    }

    @Override
    public void save() {
        BroadcastConfiguration configuration = (BroadcastConfiguration)this.getItem();
        if (configuration != null) {
            configuration.setEnabled(this.getEnabledSwitch().isSelected());
            String previousName = configuration.getName();
            String updatedName = this.getNameTextField().getText();
            configuration.setName(this.getNameTextField().getText());
            if (previousName != null && !previousName.isEmpty() && !updatedName.contentEquals(previousName) && this.getPlaylistManager().getAliasModel().hasAliasesWithBroadcastChannel(previousName)) {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.getButtonTypes().clear();
                alert.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.NO, ButtonType.YES});
                alert.setTitle("Update Aliases");
                alert.setHeaderText("Rename requires updating aliases for this stream");
                alert.setContentText("Do you want to update aliases to new stream name?");
                alert.initOwner(this.getSaveButton().getScene().getWindow());
                alert.setResizable(true);
                alert.onShownProperty().addListener(e -> Platform.runLater(() -> alert.setResizable(false)));
                alert.showAndWait().ifPresent(buttonType -> {
                    if (buttonType == ButtonType.YES) {
                        this.getPlaylistManager().getAliasModel().updateBroadcastChannel(previousName, updatedName);
                    }
                });
            }
            this.mPlaylistManager.getBroadcastModel().process(new BroadcastEvent(configuration, BroadcastEvent.Event.CONFIGURATION_CHANGE));
        }
        this.modifiedProperty().set(false);
    }

    protected Button getSaveButton() {
        if (this.mSaveButton == null) {
            this.mSaveButton = new Button("Save");
            this.mSaveButton.setDisable(true);
            this.mSaveButton.setMaxWidth(Double.MAX_VALUE);
            this.mSaveButton.setOnAction(event -> this.save());
            this.mSaveButton.disableProperty().bind((ObservableValue)this.modifiedProperty().not());
        }
        return this.mSaveButton;
    }

    protected Button getResetButton() {
        if (this.mResetButton == null) {
            this.mResetButton = new Button("Reset");
            this.mResetButton.setDisable(true);
            this.mResetButton.setMaxWidth(Double.MAX_VALUE);
            this.mResetButton.setOnAction(event -> this.setItem((T)((BroadcastConfiguration)this.getItem())));
            this.mResetButton.disableProperty().bind((ObservableValue)this.modifiedProperty().not());
        }
        return this.mResetButton;
    }

    protected TextField getNameTextField() {
        if (this.mNameTextField == null) {
            this.mNameTextField = new TextField();
            this.mNameTextField.setDisable(true);
            this.mNameTextField.textProperty().addListener((ChangeListener)this.mEditorModificationListener);
        }
        return this.mNameTextField;
    }

    protected TextField getFormatField() {
        if (this.mFormatField == null) {
            this.mFormatField = new TextField();
            this.mFormatField.setDisable(true);
        }
        return this.mFormatField;
    }

    protected ToggleSwitch getEnabledSwitch() {
        if (this.mEnabledSwitch == null) {
            this.mEnabledSwitch = new ToggleSwitch();
            this.mEnabledSwitch.setDisable(true);
            this.mEnabledSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mEnabledSwitch;
    }

    public class EditorModificationListener
    implements ChangeListener<String> {
        public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
            AbstractBroadcastEditor.this.modifiedProperty().set(true);
        }
    }
}

