/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.radioreference;

import io.github.dsheirer.gui.playlist.radioreference.AgencyEditor;
import io.github.dsheirer.gui.playlist.radioreference.CountyAgency;
import io.github.dsheirer.gui.playlist.radioreference.Level;
import io.github.dsheirer.gui.playlist.radioreference.LoginDialog;
import io.github.dsheirer.gui.playlist.radioreference.RadioReferenceUnavailableAlert;
import io.github.dsheirer.gui.playlist.radioreference.SystemEditor;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.rrapi.RadioReferenceException;
import io.github.dsheirer.rrapi.type.Agency;
import io.github.dsheirer.rrapi.type.AuthorizationInformation;
import io.github.dsheirer.rrapi.type.Country;
import io.github.dsheirer.rrapi.type.CountryInfo;
import io.github.dsheirer.rrapi.type.County;
import io.github.dsheirer.rrapi.type.CountyInfo;
import io.github.dsheirer.rrapi.type.State;
import io.github.dsheirer.rrapi.type.StateInfo;
import io.github.dsheirer.service.radioreference.RadioReference;
import io.github.dsheirer.util.ThreadPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioReferenceEditor
extends BorderPane
implements Consumer<AuthorizationInformation> {
    private static final Logger mLog = LoggerFactory.getLogger(RadioReferenceEditor.class);
    private UserPreferences mUserPreferences;
    private RadioReference mRadioReference;
    private PlaylistManager mPlaylistManager;
    private VBox mTopBox;
    private HBox mCredentialsBox;
    private Label mRRStatusText;
    private TextField mUserNameText;
    private TextField mAccountExpiresText;
    private IconNode mTestPassIcon;
    private IconNode mTestFailIcon;
    private IconNode mTestExpiredIcon;
    private Button mLoginButton;
    private GridPane mComboBoxPane;
    private ComboBox<Country> mCountryComboBox;
    private ComboBox<State> mStateComboBox;
    private ComboBox<County> mCountyComboBox;
    private AgencyEditor mNationalAgencyEditor;
    private AgencyEditor mStateAgencyEditor;
    private AgencyEditor mCountyAgencyEditor;
    private SystemEditor mStateSystemEditor;
    private SystemEditor mCountySystemEditor;
    private TabPane mTabPane;
    private Tab mNationalAgencyTab;
    private Tab mStateAgencyTab;
    private Tab mCountyAgencyTab;
    private Tab mStateSystemTab;
    private Tab mCountySystemTab;

    public RadioReferenceEditor(UserPreferences userPreferences, PlaylistManager playlistManager) {
        this.mUserPreferences = userPreferences;
        this.mRadioReference = playlistManager.getRadioReference();
        this.mPlaylistManager = playlistManager;
        this.setTop((Node)this.getTopBox());
        this.setCenter((Node)this.getTabPane());
        this.login();
        if (this.mRadioReference.premiumAccountProperty().get()) {
            this.refreshCountries();
        }
        this.mRadioReference.premiumAccountProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.refreshCountries();
            }
        });
    }

    private void login() {
        AuthorizationInformation credentials;
        if (this.mUserPreferences.getRadioReferencePreference().hasStoredCredentials() && (credentials = this.mUserPreferences.getRadioReferencePreference().getAuthorizationInformation()) != null) {
            ThreadPool.CACHED.execute(() -> this.accept(credentials));
        }
    }

    private void refreshCountries() {
        this.getCountryComboBox().getItems().clear();
        int preferredCountryId = this.mUserPreferences.getRadioReferencePreference().getPreferredCountryId();
        ThreadPool.CACHED.execute(() -> {
            try {
                List countries = this.mRadioReference.getService().getCountries();
                Platform.runLater(() -> {
                    this.getCountryComboBox().getItems().addAll((Collection)countries);
                    if (preferredCountryId >= 0) {
                        for (Country country : countries) {
                            if (country.getCountryId() != preferredCountryId) continue;
                            this.getCountryComboBox().getSelectionModel().select((Object)country);
                            return;
                        }
                    }
                });
            }
            catch (Throwable t) {
                mLog.error("Error retrieving country list from radio reference", t);
                Platform.runLater(() -> new RadioReferenceUnavailableAlert((Node)this.getCountryComboBox()).showAndWait());
            }
        });
    }

    private TabPane getTabPane() {
        if (this.mTabPane == null) {
            this.mTabPane = new TabPane();
            this.mTabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
            this.mTabPane.getTabs().addAll((Object[])new Tab[]{this.getCountySystemTab(), this.getStateSystemTab(), this.getCountyAgencyTab(), this.getStateAgencyTab(), this.getNationalAgencyTab()});
            this.mTabPane.disableProperty().bind((ObservableValue)this.mRadioReference.premiumAccountProperty().not());
        }
        return this.mTabPane;
    }

    private Tab getNationalAgencyTab() {
        if (this.mNationalAgencyTab == null) {
            this.mNationalAgencyTab = new Tab("National Agencies");
            this.mNationalAgencyTab.setContent((Node)this.getNationalAgencyEditor());
            this.getNationalAgencyEditor().agencyCountProperty().addListener((observable, oldValue, newValue) -> {
                int count;
                int n = count = newValue != null ? newValue.intValue() : 0;
                if (count > 0) {
                    this.getNationalAgencyTab().setText("National Agencies (" + count + ")");
                } else {
                    this.getNationalAgencyTab().setText("National Agencies");
                }
            });
        }
        return this.mNationalAgencyTab;
    }

    private Tab getStateAgencyTab() {
        if (this.mStateAgencyTab == null) {
            this.mStateAgencyTab = new Tab("State Agencies");
            this.mStateAgencyTab.setContent((Node)this.getStateAgencyEditor());
            this.getStateAgencyEditor().agencyCountProperty().addListener((observable, oldValue, newValue) -> {
                int count;
                int n = count = newValue != null ? newValue.intValue() : 0;
                if (count > 0) {
                    this.getStateAgencyTab().setText("State Agencies (" + count + ")");
                } else {
                    this.getStateAgencyTab().setText("State Agencies");
                }
            });
        }
        return this.mStateAgencyTab;
    }

    private Tab getCountyAgencyTab() {
        if (this.mCountyAgencyTab == null) {
            this.mCountyAgencyTab = new Tab("County Agencies");
            this.mCountyAgencyTab.setContent((Node)this.getCountyAgencyEditor());
            this.getCountyAgencyEditor().agencyCountProperty().addListener((observable, oldValue, newValue) -> {
                int count;
                int n = count = newValue != null ? newValue.intValue() : 0;
                if (count > 0) {
                    this.getCountyAgencyTab().setText("County Agencies (" + count + ")");
                } else {
                    this.getCountyAgencyTab().setText("County Agencies");
                }
            });
        }
        return this.mCountyAgencyTab;
    }

    private Tab getStateSystemTab() {
        if (this.mStateSystemTab == null) {
            this.mStateSystemTab = new Tab("State Trunked Systems");
            this.mStateSystemTab.setContent((Node)this.getStateSystemEditor());
            this.getStateSystemEditor().systemCountProperty().addListener((observable, oldValue, newValue) -> {
                int count;
                int n = count = newValue != null ? newValue.intValue() : 0;
                if (count > 0) {
                    this.getStateSystemTab().setText("State Trunked Systems (" + count + ")");
                } else {
                    this.getStateSystemTab().setText("State Trunked Systems");
                }
            });
        }
        return this.mStateSystemTab;
    }

    private Tab getCountySystemTab() {
        if (this.mCountySystemTab == null) {
            this.mCountySystemTab = new Tab("County Trunked Systems");
            this.mCountySystemTab.setContent((Node)this.getCountySystemEditor());
            this.getCountySystemEditor().systemCountProperty().addListener((observable, oldValue, newValue) -> {
                int count;
                int n = count = newValue != null ? newValue.intValue() : 0;
                if (count > 0) {
                    this.getCountySystemTab().setText("County Trunked Systems (" + count + ")");
                } else {
                    this.getCountySystemTab().setText("County Trunked Systems");
                }
            });
        }
        return this.mCountySystemTab;
    }

    private AgencyEditor getNationalAgencyEditor() {
        if (this.mNationalAgencyEditor == null) {
            this.mNationalAgencyEditor = new AgencyEditor(this.mUserPreferences, this.mRadioReference, this.mPlaylistManager, Level.NATIONAL);
        }
        return this.mNationalAgencyEditor;
    }

    private AgencyEditor getStateAgencyEditor() {
        if (this.mStateAgencyEditor == null) {
            this.mStateAgencyEditor = new AgencyEditor(this.mUserPreferences, this.mRadioReference, this.mPlaylistManager, Level.STATE);
        }
        return this.mStateAgencyEditor;
    }

    private AgencyEditor getCountyAgencyEditor() {
        if (this.mCountyAgencyEditor == null) {
            this.mCountyAgencyEditor = new AgencyEditor(this.mUserPreferences, this.mRadioReference, this.mPlaylistManager, Level.COUNTY);
        }
        return this.mCountyAgencyEditor;
    }

    private SystemEditor getStateSystemEditor() {
        if (this.mStateSystemEditor == null) {
            this.mStateSystemEditor = new SystemEditor(this.mUserPreferences, this.mRadioReference, this.mPlaylistManager, Level.STATE);
        }
        return this.mStateSystemEditor;
    }

    private SystemEditor getCountySystemEditor() {
        if (this.mCountySystemEditor == null) {
            this.mCountySystemEditor = new SystemEditor(this.mUserPreferences, this.mRadioReference, this.mPlaylistManager, Level.COUNTY);
        }
        return this.mCountySystemEditor;
    }

    private VBox getTopBox() {
        if (this.mTopBox == null) {
            this.mTopBox = new VBox();
            this.mTopBox.setSpacing(5.0);
            this.mTopBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            this.mTopBox.getChildren().addAll((Object[])new Node[]{this.getCredentialsBox(), this.getComboBoxPane()});
        }
        return this.mTopBox;
    }

    private GridPane getComboBoxPane() {
        if (this.mComboBoxPane == null) {
            this.mComboBoxPane = new GridPane();
            this.mComboBoxPane.setHgap(5.0);
            this.mComboBoxPane.setVgap(2.0);
            ColumnConstraints column1 = new ColumnConstraints();
            column1.setPercentWidth(33.33);
            ColumnConstraints column2 = new ColumnConstraints();
            column2.setPercentWidth(33.33);
            ColumnConstraints column3 = new ColumnConstraints();
            column3.setPercentWidth(33.33);
            this.mComboBoxPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2, column3});
            Label countryLabel = new Label("Country");
            GridPane.setConstraints((Node)countryLabel, (int)0, (int)0);
            this.mComboBoxPane.getChildren().add((Object)countryLabel);
            GridPane.setConstraints(this.getCountryComboBox(), (int)0, (int)1);
            GridPane.setHgrow(this.getCountryComboBox(), (Priority)Priority.ALWAYS);
            this.mComboBoxPane.getChildren().add(this.getCountryComboBox());
            Label stateLabel = new Label("State");
            GridPane.setConstraints((Node)stateLabel, (int)1, (int)0);
            this.mComboBoxPane.getChildren().add((Object)stateLabel);
            GridPane.setConstraints(this.getStateComboBox(), (int)1, (int)1);
            GridPane.setHgrow(this.getStateComboBox(), (Priority)Priority.ALWAYS);
            this.mComboBoxPane.getChildren().add(this.getStateComboBox());
            Label countyLabel = new Label("County");
            GridPane.setConstraints((Node)countyLabel, (int)2, (int)0);
            this.mComboBoxPane.getChildren().add((Object)countyLabel);
            GridPane.setConstraints(this.getCountyComboBox(), (int)2, (int)1);
            GridPane.setHgrow(this.getCountyComboBox(), (Priority)Priority.ALWAYS);
            this.mComboBoxPane.getChildren().add(this.getCountyComboBox());
            this.mComboBoxPane.disableProperty().bind((ObservableValue)this.mRadioReference.premiumAccountProperty().not());
        }
        return this.mComboBoxPane;
    }

    private HBox getCredentialsBox() {
        if (this.mCredentialsBox == null) {
            this.mCredentialsBox = new HBox();
            this.mCredentialsBox.setAlignment(Pos.CENTER_RIGHT);
            this.mCredentialsBox.setSpacing(5.0);
            Region leftFiller = new Region();
            HBox.setHgrow((Node)leftFiller, (Priority)Priority.ALWAYS);
            this.mCredentialsBox.getChildren().add((Object)leftFiller);
            this.mCredentialsBox.getChildren().add((Object)this.getRRPremiumReqText());
            Region rightFiller = new Region();
            HBox.setHgrow((Node)rightFiller, (Priority)Priority.ALWAYS);
            this.mCredentialsBox.getChildren().add((Object)rightFiller);
            this.mCredentialsBox.getChildren().add((Object)new Label("User Name:"));
            this.mCredentialsBox.getChildren().add((Object)this.getUserNameText());
            this.mCredentialsBox.getChildren().add((Object)new Label("Expires:"));
            this.mCredentialsBox.getChildren().add((Object)this.getAccountExpiresText());
            this.mCredentialsBox.getChildren().add((Object)this.getTestFailIcon());
            this.mCredentialsBox.getChildren().add((Object)this.getTestPassIcon());
            this.mCredentialsBox.getChildren().add((Object)this.getTestExpiredIcon());
            this.mCredentialsBox.getChildren().add((Object)this.getLoginButton());
        }
        return this.mCredentialsBox;
    }

    private Label getRRPremiumReqText() {
        if (this.mRRStatusText == null) {
            this.mRRStatusText = new Label();
            this.mRRStatusText.setText("A premium Radio Reference subscription is required to import systems.");
            this.mRRStatusText.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)this.mRadioReference.availableProperty(), (ObservableBooleanValue)this.mRadioReference.premiumAccountProperty().not()));
            this.mRRStatusText.setTextFill((Paint)Color.ORANGERED);
            this.mRRStatusText.setStyle("-fx-font-weight: bold;");
        }
        return this.mRRStatusText;
    }

    private TextField getUserNameText() {
        if (this.mUserNameText == null) {
            this.mUserNameText = new TextField();
            this.mUserNameText.textProperty().bind((ObservableValue)this.mRadioReference.userNameProperty());
            this.mUserNameText.setDisable(true);
        }
        return this.mUserNameText;
    }

    private TextField getAccountExpiresText() {
        if (this.mAccountExpiresText == null) {
            this.mAccountExpiresText = new TextField();
            this.mAccountExpiresText.textProperty().bind((ObservableValue)this.mRadioReference.accountExpiresProperty());
            this.mAccountExpiresText.setDisable(true);
        }
        return this.mAccountExpiresText;
    }

    private IconNode getTestPassIcon() {
        if (this.mTestPassIcon == null) {
            this.mTestPassIcon = new IconNode((IconCode)FontAwesome.CHECK);
            this.mTestPassIcon.setFill((Paint)Color.GREEN);
            this.mTestPassIcon.setVisible(false);
            this.mTestPassIcon.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)this.mRadioReference.availableProperty(), (ObservableBooleanValue)this.mRadioReference.premiumAccountProperty()));
        }
        return this.mTestPassIcon;
    }

    private IconNode getTestFailIcon() {
        if (this.mTestFailIcon == null) {
            this.mTestFailIcon = new IconNode((IconCode)FontAwesome.TIMES);
            this.mTestFailIcon.setFill((Paint)Color.RED);
            this.mTestFailIcon.setVisible(false);
            this.mTestFailIcon.visibleProperty().bind((ObservableValue)this.mRadioReference.availableProperty().not());
        }
        return this.mTestFailIcon;
    }

    private IconNode getTestExpiredIcon() {
        if (this.mTestExpiredIcon == null) {
            this.mTestExpiredIcon = new IconNode((IconCode)FontAwesome.EXCLAMATION_TRIANGLE);
            this.mTestExpiredIcon.setFill((Paint)Color.ORANGERED);
            this.mTestExpiredIcon.visibleProperty().bind((ObservableValue)Bindings.and((ObservableBooleanValue)this.mRadioReference.availableProperty(), (ObservableBooleanValue)this.mRadioReference.premiumAccountProperty().not()));
        }
        return this.mTestExpiredIcon;
    }

    private Button getLoginButton() {
        if (this.mLoginButton == null) {
            this.mLoginButton = new Button("Login");
            IconNode configureIcon = new IconNode((IconCode)FontAwesome.COG);
            configureIcon.setFill((Paint)Color.GRAY);
            this.mLoginButton.setGraphic((Node)configureIcon);
            this.mLoginButton.setOnAction(event -> new LoginDialog(this.mUserPreferences).showAndWait().ifPresent(this));
        }
        return this.mLoginButton;
    }

    private void clearEditors(Level level) {
        switch (level) {
            case NATIONAL: {
                this.getNationalAgencyEditor().clear();
                this.getStateAgencyEditor().clear();
                this.getCountyAgencyEditor().clear();
                this.getStateSystemEditor().clear();
                this.getCountySystemEditor().clear();
                break;
            }
            case STATE: {
                this.getStateAgencyEditor().clear();
                this.getCountyAgencyEditor().clear();
                this.getStateSystemEditor().clear();
                this.getCountySystemEditor().clear();
                break;
            }
            case COUNTY: {
                this.getCountyAgencyEditor().clear();
                this.getCountySystemEditor().clear();
            }
        }
    }

    private void setCountry(Country country) {
        this.clearEditors(Level.NATIONAL);
        this.getStateComboBox().getItems().clear();
        this.getCountyComboBox().getItems().clear();
        if (country != null) {
            int preferredStateId = this.mUserPreferences.getRadioReferencePreference().getPreferredStateId();
            ThreadPool.CACHED.execute(() -> {
                try {
                    CountryInfo countryInfo = this.mRadioReference.getService().getCountryInfo(country.getCountryId());
                    Platform.runLater(() -> {
                        this.getNationalAgencyEditor().setAgencies(countryInfo.getAgencies());
                        this.getStateComboBox().getItems().addAll((Collection)countryInfo.getStates());
                        for (State state : this.mStateComboBox.getItems()) {
                            if (state.getStateId() != preferredStateId) continue;
                            this.getStateComboBox().getSelectionModel().select((Object)state);
                            return;
                        }
                    });
                }
                catch (RadioReferenceException rre) {
                    mLog.error("Error retrieving country information from radio reference - " + rre.getMessage());
                    Platform.runLater(() -> new RadioReferenceUnavailableAlert((Node)this.getCountryComboBox()).showAndWait());
                }
            });
        }
    }

    private ComboBox<Country> getCountryComboBox() {
        if (this.mCountryComboBox == null) {
            this.mCountryComboBox = new ComboBox();
            this.mCountryComboBox.setConverter((StringConverter)new CountryStringConverter());
            this.mCountryComboBox.setMaxWidth(Double.MAX_VALUE);
            this.mCountryComboBox.setOnAction(event -> {
                Country selected = (Country)this.mCountryComboBox.getValue();
                this.setCountry(selected);
                if (selected != null) {
                    this.mUserPreferences.getRadioReferencePreference().setPreferredCountryId(selected.getCountryId());
                }
            });
        }
        return this.mCountryComboBox;
    }

    private void setState(State state) {
        this.clearEditors(Level.STATE);
        this.getCountyComboBox().getItems().clear();
        int preferredCountyId = this.mUserPreferences.getRadioReferencePreference().getPreferredCountyId();
        if (state != null) {
            ThreadPool.CACHED.execute(() -> {
                try {
                    StateInfo stateInfo = this.mRadioReference.getService().getStateInfo(state.getStateId());
                    Platform.runLater(() -> {
                        this.getStateAgencyEditor().setAgencies(stateInfo.getAgencies());
                        this.getStateSystemEditor().setSystems(stateInfo.getSystems());
                        this.getCountyComboBox().getItems().addAll((Collection)stateInfo.getCounties());
                        for (County county : this.mCountyComboBox.getItems()) {
                            if (county.getCountyId() != preferredCountyId) continue;
                            this.getCountyComboBox().getSelectionModel().select((Object)county);
                            return;
                        }
                    });
                }
                catch (RadioReferenceException rre) {
                    mLog.error("Error retrieving state information from radio reference - " + rre.getMessage());
                    Platform.runLater(() -> new RadioReferenceUnavailableAlert((Node)this.getStateComboBox()).showAndWait());
                }
            });
        }
    }

    private ComboBox<State> getStateComboBox() {
        if (this.mStateComboBox == null) {
            this.mStateComboBox = new ComboBox();
            this.mStateComboBox.setConverter((StringConverter)new StateStringConverter());
            this.mStateComboBox.setMaxWidth(Double.MAX_VALUE);
            this.mStateComboBox.setOnAction(event -> {
                State selected = (State)this.mStateComboBox.getValue();
                this.setState(selected);
                if (selected != null) {
                    this.mUserPreferences.getRadioReferencePreference().setPreferredStateId(selected.getStateId());
                }
            });
        }
        return this.mStateComboBox;
    }

    private void setCounty(County county) {
        this.clearEditors(Level.COUNTY);
        if (county != null) {
            ThreadPool.CACHED.execute(() -> {
                try {
                    CountyInfo countyInfo = this.mRadioReference.getService().getCountyInfo(county.getCountyId());
                    Platform.runLater(() -> {
                        this.getCountySystemEditor().setSystems(countyInfo.getSystems());
                        ArrayList<Agency> countyAgencies = new ArrayList<Agency>();
                        countyAgencies.add(new CountyAgency(countyInfo));
                        countyAgencies.addAll(countyInfo.getAgencies());
                        this.getCountyAgencyEditor().setAgencies(countyAgencies);
                    });
                }
                catch (RadioReferenceException rre) {
                    mLog.error("Error retrieving county information from radio reference - " + rre.getMessage());
                    Platform.runLater(() -> new RadioReferenceUnavailableAlert((Node)this.getCountyComboBox()).showAndWait());
                }
            });
        }
    }

    private ComboBox<County> getCountyComboBox() {
        if (this.mCountyComboBox == null) {
            this.mCountyComboBox = new ComboBox();
            this.mCountyComboBox.setConverter((StringConverter)new CountyStringConverter());
            this.mCountyComboBox.setMaxWidth(Double.MAX_VALUE);
            this.mCountyComboBox.setOnAction(event -> {
                County selected = (County)this.mCountyComboBox.getValue();
                this.setCounty(selected);
                if (selected != null) {
                    this.mUserPreferences.getRadioReferencePreference().setPreferredCountyId(selected.getCountyId());
                }
            });
        }
        return this.mCountyComboBox;
    }

    @Override
    public void accept(AuthorizationInformation authorizationInformation) {
        if (authorizationInformation != null) {
            this.mRadioReference.setAuthorizationInformation(authorizationInformation);
        }
    }

    public class CountryStringConverter
    extends StringConverter<Country> {
        public String toString(Country country) {
            if (country != null) {
                return country.getName();
            }
            return null;
        }

        public Country fromString(String string) {
            if (string != null && !string.isEmpty()) {
                for (Country country : RadioReferenceEditor.this.mCountryComboBox.getItems()) {
                    if (!country.getName().toLowerCase().contentEquals(string.toLowerCase())) continue;
                    return country;
                }
            }
            return null;
        }
    }

    public class StateStringConverter
    extends StringConverter<State> {
        public String toString(State state) {
            if (state != null) {
                return state.getName();
            }
            return null;
        }

        public State fromString(String string) {
            if (string != null && !string.isEmpty()) {
                for (State state : RadioReferenceEditor.this.mStateComboBox.getItems()) {
                    if (!state.getName().toLowerCase().contentEquals(string.toLowerCase())) continue;
                    return state;
                }
            }
            return null;
        }
    }

    public class CountyStringConverter
    extends StringConverter<County> {
        public String toString(County county) {
            if (county != null) {
                return county.getName();
            }
            return null;
        }

        public County fromString(String string) {
            if (string != null && !string.isEmpty()) {
                for (County county : RadioReferenceEditor.this.mCountyComboBox.getItems()) {
                    if (!county.getName().toLowerCase().contentEquals(string.toLowerCase())) continue;
                    return county;
                }
            }
            return null;
        }
    }
}

