/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.manager;

import com.google.common.eventbus.Subscribe;
import com.google.common.io.Files;
import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelException;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.UserPreferences;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Separator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistManagerEditor
extends HBox {
    private static final Logger mLog = LoggerFactory.getLogger(PlaylistManagerEditor.class);
    private static final FileChooser.ExtensionFilter PLAYLIST_FILE_FILTER = new FileChooser.ExtensionFilter("Playlist Files (*.xml)", new String[]{"*.xml"});
    private static final FileChooser.ExtensionFilter ALL_FILES_FILE_FILTER = new FileChooser.ExtensionFilter("All Files (*.*)", new String[]{"*.*"});
    private PlaylistManager mPlaylistManager;
    private UserPreferences mUserPreferences;
    private TableView<Path> mPlaylistTableView;
    private VBox mButtonBox;
    private Button mSelectButton;
    private Button mAddButton;
    private Button mRemoveButton;
    private Button mCloneButton;
    private Button mNewButton;
    private Button mDeleteButton;

    public PlaylistManagerEditor(PlaylistManager playlistManager, UserPreferences userPreferences) {
        this.mPlaylistManager = playlistManager;
        this.mUserPreferences = userPreferences;
        MyEventBus.getGlobalEventBus().register((Object)this);
        this.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        HBox.setHgrow(this.getPlaylistTableView(), (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.getPlaylistTableView(), this.getButtonBox()});
        this.updateButtons();
    }

    public void dispose() {
        MyEventBus.getGlobalEventBus().unregister((Object)this);
    }

    private boolean isCurrent(Path path) {
        Path current = this.mUserPreferences.getPlaylistPreference().getPlaylist();
        return path != null && current != null && path.equals(current);
    }

    private void savePlaylistsPreference() {
        this.mUserPreferences.getPlaylistPreference().setPlaylistList((List<Path>)this.getPlaylistTableView().getItems());
    }

    private TableView<Path> getPlaylistTableView() {
        if (this.mPlaylistTableView == null) {
            this.mPlaylistTableView = new TableView();
            TableColumn iconColumn = new TableColumn("Selected");
            iconColumn.setPrefWidth(100.0);
            iconColumn.setCellFactory((Callback)new Callback<TableColumn<Path, String>, TableCell<Path, String>>(){

                public TableCell<Path, String> call(TableColumn<Path, String> param) {
                    TableCell<Path, String> tableCell = new TableCell<Path, String>(){

                        protected void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            if (empty || this.getTableRow() == null || this.getTableRow().getItem() == null) {
                                this.setGraphic(null);
                            } else {
                                Path path = (Path)this.getTableRow().getItem();
                                if (PlaylistManagerEditor.this.isCurrent(path)) {
                                    IconNode iconNode = new IconNode((IconCode)FontAwesome.CHECK);
                                    iconNode.setFill((Paint)Color.GREEN);
                                    this.setGraphic((Node)iconNode);
                                } else if (!path.toFile().exists()) {
                                    IconNode iconNode = new IconNode((IconCode)FontAwesome.TIMES);
                                    iconNode.setFill((Paint)Color.RED);
                                    this.setGraphic((Node)iconNode);
                                } else {
                                    this.setGraphic(null);
                                }
                            }
                        }
                    };
                    tableCell.setAlignment(Pos.BASELINE_RIGHT);
                    return tableCell;
                }
            });
            TableColumn pathColumn = new TableColumn("Playlist");
            pathColumn.setCellFactory(param -> new TableCell<Path, String>(this){

                protected void updateItem(String item, boolean empty) {
                    if (empty || this.getTableRow() == null || this.getTableRow().getItem() == null) {
                        this.setText(null);
                    } else {
                        this.setText(((Path)this.getTableRow().getItem()).toString());
                    }
                }
            });
            pathColumn.setPrefWidth(650.0);
            this.mPlaylistTableView.getColumns().addAll((Object[])new TableColumn[]{iconColumn, pathColumn});
            this.mPlaylistTableView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.updateButtons());
            List<Path> playlistPaths = this.mUserPreferences.getPlaylistPreference().getPlaylistList();
            this.mPlaylistTableView.getItems().addAll(playlistPaths);
        }
        return this.mPlaylistTableView;
    }

    private void updateButtons() {
        Path selected = (Path)this.getPlaylistTableView().getSelectionModel().getSelectedItem();
        boolean itemSelected = selected != null;
        boolean isCurrent = this.isCurrent(selected);
        this.getSelectButton().setDisable(!itemSelected || isCurrent);
        this.getRemoveButton().setDisable(!itemSelected || isCurrent);
        this.getCloneButton().setDisable(!itemSelected || selected != null && !selected.toFile().exists());
        this.getDeleteButton().setDisable(!itemSelected || isCurrent || selected != null && !selected.toFile().exists());
    }

    private VBox getButtonBox() {
        if (this.mButtonBox == null) {
            this.mButtonBox = new VBox();
            this.mButtonBox.setSpacing(10.0);
            this.mButtonBox.setPadding(new Insets(5.0, 5.0, 5.0, 10.0));
            this.mButtonBox.setAlignment(Pos.TOP_CENTER);
            this.mButtonBox.getChildren().add((Object)this.getSelectButton());
            this.mButtonBox.getChildren().add((Object)new Separator());
            this.mButtonBox.getChildren().addAll((Object[])new Node[]{this.getNewButton(), this.getAddButton(), this.getRemoveButton(), this.getCloneButton()});
            this.mButtonBox.getChildren().add((Object)new Separator());
            this.mButtonBox.getChildren().add((Object)this.getDeleteButton());
        }
        return this.mButtonBox;
    }

    private Button getSelectButton() {
        if (this.mSelectButton == null) {
            this.mSelectButton = new Button("Select");
            this.mSelectButton.setTooltip(new Tooltip("Sets the selected playlist as the current playlist"));
            this.mSelectButton.setMaxWidth(Double.MAX_VALUE);
            this.mSelectButton.setOnAction(event -> {
                Path current = this.mUserPreferences.getPlaylistPreference().getPlaylist();
                Path selected = (Path)this.getPlaylistTableView().getSelectionModel().getSelectedItem();
                if (selected != null) {
                    try {
                        this.mPlaylistManager.setPlaylist(selected);
                    }
                    catch (IOException ioe) {
                        mLog.error("Error loading playlist [" + (selected != null ? selected.toString() : "null") + "]");
                        new Alert(Alert.AlertType.ERROR, "Unable to load selected playlist.  Reverting to previous playlist", new ButtonType[]{ButtonType.OK}).show();
                        try {
                            this.mPlaylistManager.setPlaylist(current);
                        }
                        catch (IOException ioe2) {
                            mLog.error("Error reverting to previous playlist [" + (current != null ? current.toString() : "null") + "]");
                        }
                    }
                    List<Channel> autoStartChannels = this.mPlaylistManager.getChannelModel().getAutoStartChannels();
                    if (autoStartChannels.size() > 0) {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Would you like to auto-start your channels?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
                        alert.setTitle("Auto-Start Channels");
                        alert.setHeaderText("Discovered [" + autoStartChannels.size() + "] auto-start channel" + (autoStartChannels.size() > 1 ? "s" : ""));
                        alert.showAndWait().ifPresent(buttonType -> {
                            if (buttonType == ButtonType.YES) {
                                boolean error = false;
                                for (Channel channel : autoStartChannels) {
                                    try {
                                        this.mPlaylistManager.getChannelProcessingManager().start(channel);
                                    }
                                    catch (ChannelException ce) {
                                        error = true;
                                    }
                                }
                                if (error) {
                                    Alert errorAlert = new Alert(Alert.AlertType.ERROR, "Unable to start some or all of the auto-start channels", new ButtonType[]{ButtonType.OK});
                                    errorAlert.setTitle("Channel Auto-Start Error(s)");
                                    errorAlert.setHeaderText("Auto-Start Error");
                                    errorAlert.showAndWait();
                                }
                            }
                        });
                    }
                }
            });
        }
        return this.mSelectButton;
    }

    private Button getAddButton() {
        if (this.mAddButton == null) {
            this.mAddButton = new Button("Add");
            this.mAddButton.setTooltip(new Tooltip("Add an existing playlist from the file system"));
            this.mAddButton.setMaxWidth(Double.MAX_VALUE);
            this.mAddButton.setOnAction(event -> {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Add Playlist");
                fileChooser.setInitialDirectory(this.mUserPreferences.getDirectoryPreference().getDirectoryPlaylist().toFile());
                fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{PLAYLIST_FILE_FILTER, ALL_FILES_FILE_FILTER});
                File playlistToAdd = fileChooser.showOpenDialog(null);
                if (playlistToAdd != null) {
                    if (PlaylistManager.isPlaylist(playlistToAdd.toPath())) {
                        if (!this.getPlaylistTableView().getItems().contains((Object)playlistToAdd.toPath())) {
                            this.getPlaylistTableView().getItems().add((Object)playlistToAdd.toPath());
                            this.savePlaylistsPreference();
                        } else {
                            new Alert(Alert.AlertType.INFORMATION, "Playlist already added", new ButtonType[]{ButtonType.OK}).show();
                        }
                    } else {
                        new Alert(Alert.AlertType.ERROR, "This file is not a valid playlist", new ButtonType[]{ButtonType.OK}).show();
                    }
                }
            });
        }
        return this.mAddButton;
    }

    private Button getCloneButton() {
        if (this.mCloneButton == null) {
            this.mCloneButton = new Button("Clone");
            this.mCloneButton.setTooltip(new Tooltip("Create a clone (copy) of the currently selected playlist"));
            this.mCloneButton.setMaxWidth(Double.MAX_VALUE);
            this.mCloneButton.setOnAction(event -> {
                Path selected = (Path)this.getPlaylistTableView().getSelectionModel().getSelectedItem();
                if (selected != null) {
                    FileChooser fileChooser = new FileChooser();
                    fileChooser.setTitle("Copy Playlist");
                    fileChooser.setInitialDirectory(this.mUserPreferences.getDirectoryPreference().getDirectoryPlaylist().toFile());
                    fileChooser.setInitialFileName(selected.getName(selected.getNameCount() - 1).toString());
                    fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{PLAYLIST_FILE_FILTER, ALL_FILES_FILE_FILTER});
                    File copyFile = fileChooser.showSaveDialog(null);
                    if (copyFile != null) {
                        if (!copyFile.toString().endsWith(".xml") && (copyFile = new File(copyFile.toString() + ".xml")).exists()) {
                            new Alert(Alert.AlertType.ERROR, "File already exists.  Please copy to a new file name", new ButtonType[]{ButtonType.OK}).show();
                            return;
                        }
                        try {
                            Files.copy((File)selected.toFile(), (File)copyFile);
                            this.getPlaylistTableView().getItems().add((Object)copyFile.toPath());
                            this.savePlaylistsPreference();
                        }
                        catch (IOException ioe) {
                            mLog.error("Error creating copy of playlist [" + selected.toString() + "] as [" + copyFile.toString() + "]", (Throwable)ioe);
                            Alert alert = new Alert(Alert.AlertType.ERROR, "Unable to create copy of playlist", new ButtonType[]{ButtonType.OK});
                            alert.initOwner(this.getCloneButton().getScene().getWindow());
                            alert.show();
                        }
                    }
                }
            });
        }
        return this.mCloneButton;
    }

    private Button getRemoveButton() {
        if (this.mRemoveButton == null) {
            this.mRemoveButton = new Button("Remove");
            this.mRemoveButton.setTooltip(new Tooltip("Remove the currently selected playlist from the application"));
            this.mRemoveButton.setMaxWidth(Double.MAX_VALUE);
            this.mRemoveButton.setOnAction(event -> {
                Path selected = (Path)this.getPlaylistTableView().getSelectionModel().getSelectedItem();
                if (selected != null) {
                    this.getPlaylistTableView().getItems().remove((Object)selected);
                    this.savePlaylistsPreference();
                }
            });
        }
        return this.mRemoveButton;
    }

    private Button getNewButton() {
        if (this.mNewButton == null) {
            this.mNewButton = new Button("New");
            this.mNewButton.setTooltip(new Tooltip("Create a new playlist"));
            this.mNewButton.setMaxWidth(Double.MAX_VALUE);
            this.mNewButton.setOnAction(event -> {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("New Playlist");
                fileChooser.setInitialDirectory(this.mUserPreferences.getDirectoryPreference().getDirectoryPlaylist().toFile());
                fileChooser.setInitialFileName("*.xml");
                fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{PLAYLIST_FILE_FILTER});
                File newFile = fileChooser.showSaveDialog(null);
                if (newFile != null) {
                    try {
                        Path toCreate = newFile.toPath();
                        if (!toCreate.toString().endsWith(".xml") && (toCreate = Paths.get(newFile.toString() + ".xml", new String[0])).toFile().exists()) {
                            new Alert(Alert.AlertType.ERROR, "File already exists.  Please choose a new file name", new ButtonType[]{ButtonType.OK}).show();
                            return;
                        }
                        this.mPlaylistManager.createEmptyPlaylist(toCreate);
                        this.getPlaylistTableView().getItems().add((Object)toCreate);
                        this.savePlaylistsPreference();
                    }
                    catch (IOException ioe) {
                        mLog.error("Error creating new playlist file [" + newFile.toString() + "]");
                        new Alert(Alert.AlertType.ERROR, "Unable to create new playlist", new ButtonType[]{ButtonType.OK}).show();
                    }
                }
            });
        }
        return this.mNewButton;
    }

    private Button getDeleteButton() {
        if (this.mDeleteButton == null) {
            this.mDeleteButton = new Button("Delete");
            this.mDeleteButton.setTooltip(new Tooltip("Remove the currently selected playlist and delete it from the file system"));
            this.mDeleteButton.setMaxWidth(Double.MAX_VALUE);
            this.mDeleteButton.setOnAction(event -> {
                Path selected = (Path)this.getPlaylistTableView().getSelectionModel().getSelectedItem();
                if (selected != null) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Delete playlist from file system?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
                    alert.setHeaderText("Are you sure?");
                    alert.initOwner(this.getDeleteButton().getScene().getWindow());
                    Button noButton = (Button)alert.getDialogPane().lookupButton(ButtonType.NO);
                    noButton.setDefaultButton(true);
                    Button yesButton = (Button)alert.getDialogPane().lookupButton(ButtonType.YES);
                    yesButton.setDefaultButton(false);
                    Optional optional = alert.showAndWait();
                    if (optional.get() == ButtonType.YES) {
                        this.getPlaylistTableView().getItems().remove((Object)selected);
                        this.savePlaylistsPreference();
                        selected.toFile().delete();
                    }
                }
            });
        }
        return this.mDeleteButton;
    }

    @Subscribe
    public void preferenceUpdated(PreferenceType preferenceType) {
        if (preferenceType == PreferenceType.PLAYLIST) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    PlaylistManagerEditor.this.getPlaylistTableView().refresh();
                }
            });
        }
    }
}

