/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.eventlog;

import io.github.dsheirer.gui.playlist.Editor;
import io.github.dsheirer.module.log.EventLogType;
import io.github.dsheirer.module.log.config.EventLogConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import org.controlsfx.control.ToggleSwitch;

public class EventLogConfigurationEditor
extends Editor<EventLogConfiguration> {
    private List<EventLogControl> mControls = new ArrayList<EventLogControl>();

    public EventLogConfigurationEditor(Collection<EventLogType> types) {
        for (EventLogType type : types) {
            EventLogControl control = new EventLogControl(type);
            this.mControls.add(control);
            this.getChildren().add((Object)control);
        }
    }

    @Override
    public void setItem(EventLogConfiguration item) {
        if (item == null) {
            item = new EventLogConfiguration();
        }
        super.setItem(item);
        for (EventLogControl control : this.mControls) {
            control.getToggleSwitch().setDisable(false);
            control.getToggleSwitch().setSelected(item.getLoggers().contains((Object)control.getEventLogType()));
        }
        this.modifiedProperty().set(false);
    }

    @Override
    public void save() {
        EventLogConfiguration config = (EventLogConfiguration)this.getItem();
        if (config == null) {
            config = new EventLogConfiguration();
        }
        config.clear();
        for (EventLogControl control : this.mControls) {
            if (!control.getToggleSwitch().isSelected()) continue;
            config.addLogger(control.getEventLogType());
        }
        this.setItem(config);
    }

    @Override
    public void dispose() {
    }

    public class EventLogControl
    extends GridPane {
        private EventLogType mEventLogType;
        private ToggleSwitch mToggleSwitch;

        public EventLogControl(EventLogType type) {
            this.mEventLogType = type;
            this.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            this.setHgap(10.0);
            GridPane.setConstraints((Node)this.getToggleSwitch(), (int)0, (int)0);
            this.getChildren().add((Object)this.getToggleSwitch());
            Label label = new Label(this.mEventLogType.getDisplayString());
            GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
            GridPane.setConstraints((Node)label, (int)1, (int)0);
            this.getChildren().add((Object)label);
        }

        private ToggleSwitch getToggleSwitch() {
            if (this.mToggleSwitch == null) {
                this.mToggleSwitch = new ToggleSwitch();
                this.mToggleSwitch.setDisable(true);
                this.mToggleSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> EventLogConfigurationEditor.this.modifiedProperty().set(true));
            }
            return this.mToggleSwitch;
        }

        public EventLogType getEventLogType() {
            return this.mEventLogType;
        }
    }
}

