/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.decoder;

import io.github.dsheirer.gui.playlist.Editor;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.config.AuxDecodeConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import org.controlsfx.control.ToggleSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuxDecoderConfigurationEditor
extends Editor<AuxDecodeConfiguration> {
    private static final Logger mLog = LoggerFactory.getLogger(AuxDecoderConfigurationEditor.class);
    private List<AuxDecoderControl> mControls = new ArrayList<AuxDecoderControl>();

    public AuxDecoderConfigurationEditor(Collection<DecoderType> types) {
        for (DecoderType type : types) {
            AuxDecoderControl control = new AuxDecoderControl(type);
            this.mControls.add(control);
            this.getChildren().add((Object)control);
        }
    }

    @Override
    public void setItem(AuxDecodeConfiguration item) {
        if (item == null) {
            item = new AuxDecodeConfiguration();
        }
        super.setItem(item);
        for (AuxDecoderControl control : this.mControls) {
            control.getToggleSwitch().setDisable(false);
            control.getToggleSwitch().setSelected(item.getAuxDecoders().contains((Object)control.getDecoderType()));
        }
        this.modifiedProperty().set(false);
    }

    @Override
    public void save() {
        AuxDecodeConfiguration config = (AuxDecodeConfiguration)this.getItem();
        if (config == null) {
            config = new AuxDecodeConfiguration();
        }
        config.clearAuxDecoders();
        for (AuxDecoderControl control : this.mControls) {
            if (!control.getToggleSwitch().isSelected()) continue;
            config.addAuxDecoder(control.getDecoderType());
        }
        this.setItem(config);
    }

    @Override
    public void dispose() {
    }

    public class AuxDecoderControl
    extends GridPane {
        private DecoderType mDecoderType;
        private ToggleSwitch mToggleSwitch;

        public AuxDecoderControl(DecoderType type) {
            this.mDecoderType = type;
            this.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            this.setHgap(10.0);
            GridPane.setConstraints((Node)this.getToggleSwitch(), (int)0, (int)0);
            this.getChildren().add((Object)this.getToggleSwitch());
            Label label = new Label(this.mDecoderType.getDisplayString());
            GridPane.setHalignment((Node)label, (HPos)HPos.LEFT);
            GridPane.setConstraints((Node)label, (int)1, (int)0);
            this.getChildren().add((Object)label);
        }

        private ToggleSwitch getToggleSwitch() {
            if (this.mToggleSwitch == null) {
                this.mToggleSwitch = new ToggleSwitch();
                this.mToggleSwitch.setDisable(true);
                this.mToggleSwitch.selectedProperty().addListener((observable, oldValue, newValue) -> AuxDecoderConfigurationEditor.this.modifiedProperty().set(true));
            }
            return this.mToggleSwitch;
        }

        public DecoderType getDecoderType() {
            return this.mDecoderType;
        }
    }
}

