/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.channelMap;

import io.github.dsheirer.controller.channel.map.ChannelMap;
import io.github.dsheirer.controller.channel.map.ChannelMapModel;
import io.github.dsheirer.controller.channel.map.ChannelRange;
import io.github.dsheirer.gui.control.IntegerTextField;
import io.github.dsheirer.gui.playlist.Editor;
import io.github.dsheirer.gui.playlist.channelMap.ViewChannelMapEditorRequest;
import java.util.Collection;
import java.util.Optional;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class ChannelMapEditor
extends SplitPane {
    private static final String COPY_NAME = " (copy)";
    private ChannelMapModel mChannelMapModel;
    private SplitPane mSplitPane;
    private MapEditor mMapEditor;
    private HBox mChannelMapManagerBox;
    private VBox mMapButtonsBox;
    private Button mNewMapButton;
    private Button mCloneMapButton;
    private Button mDeleteMapButton;
    private Button mHelpButton;
    private ListView<ChannelMap> mChannelMapListView;
    private GridPane mChannelRangePane;
    private IntegerTextField mFirstField;
    private IntegerTextField mLastField;
    private IntegerTextField mBaseFrequencyField;
    private IntegerTextField mStepSizeField;

    public ChannelMapEditor(ChannelMapModel channelMapModel) {
        this.mChannelMapModel = channelMapModel;
        this.setOrientation(Orientation.VERTICAL);
        this.getItems().addAll((Object[])new Node[]{this.getChannelMapManagerBox(), this.getMapEditor(), this.getChannelRangePane()});
    }

    private HBox getChannelMapManagerBox() {
        if (this.mChannelMapManagerBox == null) {
            this.mChannelMapManagerBox = new HBox();
            HBox.setHgrow(this.getChannelMapListView(), (Priority)Priority.ALWAYS);
            this.mChannelMapManagerBox.getChildren().addAll((Object[])new Node[]{this.getChannelMapListView(), this.getMapButtonsBox()});
        }
        return this.mChannelMapManagerBox;
    }

    private VBox getMapButtonsBox() {
        if (this.mMapButtonsBox == null) {
            this.mMapButtonsBox = new VBox();
            this.mMapButtonsBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            this.mMapButtonsBox.setSpacing(10.0);
            this.mMapButtonsBox.getChildren().addAll((Object[])new Node[]{this.getNewMapButton(), this.getCloneMapButton(), this.getDeleteMapButton(), this.getHelpButton()});
        }
        return this.mMapButtonsBox;
    }

    private Button getNewMapButton() {
        if (this.mNewMapButton == null) {
            this.mNewMapButton = new Button("New Map");
            this.mNewMapButton.setTooltip(new Tooltip("Create a new channel map"));
            this.mNewMapButton.setMaxWidth(Double.MAX_VALUE);
            this.mNewMapButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    ChannelMap channelMap = new ChannelMap("New Channel Map");
                    ChannelMapEditor.this.mChannelMapModel.addChannelMap(channelMap);
                    ChannelMapEditor.this.getChannelMapListView().getSelectionModel().select((Object)channelMap);
                }
            });
        }
        return this.mNewMapButton;
    }

    private Button getCloneMapButton() {
        if (this.mCloneMapButton == null) {
            this.mCloneMapButton = new Button("Clone Map");
            this.mCloneMapButton.setTooltip(new Tooltip("Create a copy of the selected channel map"));
            this.mCloneMapButton.setDisable(true);
            this.mCloneMapButton.setMaxWidth(Double.MAX_VALUE);
            this.mCloneMapButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    ChannelMap selected = (ChannelMap)ChannelMapEditor.this.getChannelMapListView().getSelectionModel().getSelectedItem();
                    if (selected != null) {
                        ChannelMap copy = selected.copyOf();
                        Object name = selected.getName();
                        if (name == null) {
                            name = ChannelMapEditor.COPY_NAME;
                        } else if (!((String)name).toLowerCase().endsWith(ChannelMapEditor.COPY_NAME)) {
                            name = (String)name + ChannelMapEditor.COPY_NAME;
                        }
                        copy.setName((String)name);
                        ChannelMapEditor.this.mChannelMapModel.addChannelMap(copy);
                        ChannelMapEditor.this.getChannelMapListView().getSelectionModel().select((Object)copy);
                    }
                }
            });
        }
        return this.mCloneMapButton;
    }

    private void updateChannelMapButtons() {
        boolean selected = this.getChannelMapListView().getSelectionModel().getSelectedItem() != null;
        this.getCloneMapButton().setDisable(!selected);
        this.getDeleteMapButton().setDisable(!selected);
    }

    private Button getDeleteMapButton() {
        if (this.mDeleteMapButton == null) {
            this.mDeleteMapButton = new Button("Delete Map");
            this.mDeleteMapButton.setTooltip(new Tooltip("Delete the selected channel map"));
            this.mDeleteMapButton.setDisable(true);
            this.mDeleteMapButton.setMaxWidth(Double.MAX_VALUE);
            this.mDeleteMapButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    ChannelMap selected;
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to delete the selected channel map?", new ButtonType[]{ButtonType.NO, ButtonType.YES});
                    alert.setTitle("Delete Channel Map");
                    alert.setHeaderText("Are you sure?");
                    alert.initOwner(ChannelMapEditor.this.getDeleteMapButton().getScene().getWindow());
                    Optional result = alert.showAndWait();
                    if (result.get() == ButtonType.YES && (selected = (ChannelMap)ChannelMapEditor.this.getChannelMapListView().getSelectionModel().getSelectedItem()) != null) {
                        ChannelMapEditor.this.mChannelMapModel.removeChannelMap(selected);
                        ChannelMapEditor.this.updateChannelMapButtons();
                    }
                }
            });
        }
        return this.mDeleteMapButton;
    }

    private Button getHelpButton() {
        if (this.mHelpButton == null) {
            this.mHelpButton = new Button("Help");
            this.mHelpButton.setMaxWidth(Double.MAX_VALUE);
            this.mHelpButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION);
                    Text text1 = new Text("Channel maps are used by trunking systems to define the transmit frequency used for each channel number.  A channel map is required so that the frequency for each call channel can be calculated correctly");
                    text1.setWrappingWidth(300.0);
                    Text text2 = new Text("A channel map contains one or more channel ranges.  Each range has a first and last channel number and the channel numbers for each range do NOT overlap.  Each range also has a base frequency and a step or channel size");
                    text2.setWrappingWidth(300.0);
                    Text text3 = new Text("The frequency for each channel number is calculated as: base frequency + (last - first * stepSize)");
                    text3.setWrappingWidth(300.0);
                    VBox vbox = new VBox();
                    vbox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
                    vbox.setSpacing(10.0);
                    vbox.getChildren().addAll((Object[])new Node[]{text1, text2, text3});
                    alert.getDialogPane().setContent((Node)vbox);
                    alert.setTitle("Channel Map Help");
                    alert.setHeaderText("Channel Map Help");
                    alert.initOwner(ChannelMapEditor.this.getHelpButton().getScene().getWindow());
                    alert.setResizable(true);
                    alert.onShownProperty().addListener(e -> Platform.runLater(() -> alert.setResizable(false)));
                    alert.showAndWait();
                }
            });
        }
        return this.mHelpButton;
    }

    private ListView<ChannelMap> getChannelMapListView() {
        if (this.mChannelMapListView == null) {
            this.mChannelMapListView = new ListView();
            this.mChannelMapListView.setItems(this.mChannelMapModel.getChannelMaps());
            this.mChannelMapListView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
                this.getMapEditor().setItem((ChannelMap)newValue);
                this.updateChannelMapButtons();
            });
        }
        return this.mChannelMapListView;
    }

    private MapEditor getMapEditor() {
        if (this.mMapEditor == null) {
            this.mMapEditor = new MapEditor();
        }
        return this.mMapEditor;
    }

    private ChannelRange getSelectedChannelRange() {
        return (ChannelRange)this.getMapEditor().getChannelRangeTableView().getSelectionModel().getSelectedItem();
    }

    private IntegerTextField getFirstField() {
        if (this.mFirstField == null) {
            this.mFirstField = new IntegerTextField();
            this.mFirstField.setDisable(true);
            this.mFirstField.textProperty().addListener((observable, oldValue, newValue) -> {
                if (this.getSelectedChannelRange() != null) {
                    Integer value = this.getFirstField().get();
                    this.getSelectedChannelRange().setFirstChannelNumber(value != null ? value : 0);
                    this.getMapEditor().modifiedProperty().set(true);
                }
            });
        }
        return this.mFirstField;
    }

    private IntegerTextField getLastField() {
        if (this.mLastField == null) {
            this.mLastField = new IntegerTextField();
            this.mLastField.setDisable(true);
            this.mLastField.textProperty().addListener((observable, oldValue, newValue) -> {
                if (this.getSelectedChannelRange() != null) {
                    Integer value = this.getLastField().get();
                    this.getSelectedChannelRange().setLastChannelNumber(value != null ? value : 0);
                    this.getMapEditor().modifiedProperty().set(true);
                }
            });
        }
        return this.mLastField;
    }

    private IntegerTextField getBaseFrequencyField() {
        if (this.mBaseFrequencyField == null) {
            this.mBaseFrequencyField = new IntegerTextField();
            this.mBaseFrequencyField.setDisable(true);
            this.mBaseFrequencyField.textProperty().addListener((observable, oldValue, newValue) -> {
                if (this.getSelectedChannelRange() != null) {
                    Integer value = this.getBaseFrequencyField().get();
                    this.getSelectedChannelRange().setBaseFrequency(value != null ? value : 0);
                    this.getMapEditor().modifiedProperty().set(true);
                }
            });
        }
        return this.mBaseFrequencyField;
    }

    private IntegerTextField getStepSizeField() {
        if (this.mStepSizeField == null) {
            this.mStepSizeField = new IntegerTextField();
            this.mStepSizeField.setDisable(true);
            this.mStepSizeField.textProperty().addListener((observable, oldValue, newValue) -> {
                if (this.getSelectedChannelRange() != null) {
                    Integer value = this.getStepSizeField().get();
                    this.getSelectedChannelRange().setStepSize(value != null ? value : 0);
                    this.getMapEditor().modifiedProperty().set(true);
                }
            });
        }
        return this.mStepSizeField;
    }

    private GridPane getChannelRangePane() {
        if (this.mChannelRangePane == null) {
            this.mChannelRangePane = new GridPane();
            this.mChannelRangePane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            this.mChannelRangePane.setVgap(10.0);
            this.mChannelRangePane.setHgap(5.0);
            Label firstLabel = new Label("First Channel");
            GridPane.setHalignment((Node)firstLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)firstLabel, (int)0, (int)0);
            this.mChannelRangePane.getChildren().add((Object)firstLabel);
            GridPane.setConstraints((Node)this.getFirstField(), (int)1, (int)0);
            GridPane.setHgrow((Node)this.getFirstField(), (Priority)Priority.ALWAYS);
            this.mChannelRangePane.getChildren().add((Object)this.getFirstField());
            Label lastLabel = new Label("Last Channel");
            GridPane.setHalignment((Node)lastLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)lastLabel, (int)0, (int)1);
            this.mChannelRangePane.getChildren().add((Object)lastLabel);
            GridPane.setConstraints((Node)this.getLastField(), (int)1, (int)1);
            GridPane.setHgrow((Node)this.getLastField(), (Priority)Priority.ALWAYS);
            this.mChannelRangePane.getChildren().add((Object)this.getLastField());
            Label baseLabel = new Label("Base Frequency (Hz)");
            GridPane.setHalignment((Node)baseLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)baseLabel, (int)0, (int)2);
            this.mChannelRangePane.getChildren().add((Object)baseLabel);
            GridPane.setConstraints((Node)this.getBaseFrequencyField(), (int)1, (int)2);
            GridPane.setHgrow((Node)this.getBaseFrequencyField(), (Priority)Priority.ALWAYS);
            this.mChannelRangePane.getChildren().add((Object)this.getBaseFrequencyField());
            Label stepSizeLabel = new Label("Step Size (Hz)");
            GridPane.setHalignment((Node)stepSizeLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)stepSizeLabel, (int)0, (int)3);
            this.mChannelRangePane.getChildren().add((Object)stepSizeLabel);
            GridPane.setConstraints((Node)this.getStepSizeField(), (int)1, (int)3);
            GridPane.setHgrow((Node)this.getStepSizeField(), (Priority)Priority.ALWAYS);
            this.mChannelRangePane.getChildren().add((Object)this.getStepSizeField());
        }
        return this.mChannelRangePane;
    }

    public void process(ViewChannelMapEditorRequest request) {
        String channelMapName = request.getChannelMapName();
        if (channelMapName != null) {
            for (ChannelMap channelMap : this.getChannelMapListView().getItems()) {
                if (!channelMapName.contentEquals(channelMap.getName())) continue;
                this.getChannelMapListView().getSelectionModel().select((Object)channelMap);
                break;
            }
        }
    }

    public class MapEditor
    extends Editor<ChannelMap> {
        private Button mSaveButton;
        private Button mResetButton;
        private Button mNewRangeButton;
        private Button mDeleteRangeButton;
        private TableView<ChannelRange> mChannelRangeTableView;
        private TextField mNameField;

        public MapEditor() {
            HBox nameBox = new HBox();
            nameBox.setPadding(new Insets(10.0, 0.0, 10.0, 10.0));
            nameBox.setSpacing(10.0);
            nameBox.setAlignment(Pos.CENTER);
            HBox.setHgrow((Node)this.getNameField(), (Priority)Priority.ALWAYS);
            nameBox.getChildren().addAll((Object[])new Node[]{new Label("Name"), this.getNameField()});
            VBox contentsBox = new VBox();
            VBox.setVgrow((Node)nameBox, (Priority)Priority.NEVER);
            VBox.setVgrow(this.getChannelRangeTableView(), (Priority)Priority.ALWAYS);
            contentsBox.getChildren().addAll((Object[])new Node[]{nameBox, this.getChannelRangeTableView()});
            VBox buttonsBox = new VBox();
            buttonsBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            buttonsBox.setSpacing(10.0);
            buttonsBox.getChildren().addAll((Object[])new Node[]{this.getSaveButton(), this.getResetButton(), new Separator(), this.getNewRangeButton(), this.getDeleteRangeButton()});
            HBox hbox = new HBox();
            HBox.setHgrow((Node)contentsBox, (Priority)Priority.ALWAYS);
            hbox.getChildren().addAll((Object[])new Node[]{contentsBox, buttonsBox});
            this.getChildren().add((Object)hbox);
            this.modifiedProperty().addListener((observable, oldValue, modified) -> {
                this.getSaveButton().setDisable(modified == false);
                this.getResetButton().setDisable(modified == false);
            });
        }

        private void updateChannelRangeButtons() {
            this.getNewRangeButton().setDisable(this.getItem() == null);
            this.getDeleteRangeButton().setDisable(this.getChannelRangeTableView().getSelectionModel().getSelectedItem() == null);
        }

        @Override
        public void save() {
            ChannelRange selectedChannelRange = (ChannelRange)this.getChannelRangeTableView().getSelectionModel().getSelectedItem();
            if (this.getItem() != null) {
                ((ChannelMap)this.getItem()).nameProperty().set((Object)this.getNameField().getText());
                ((ChannelMap)this.getItem()).getItems().clear();
                ((ChannelMap)this.getItem()).getItems().addAll((Collection)this.getChannelRangeTableView().getItems());
            }
            this.modifiedProperty().set(false);
            this.setItem((ChannelMap)this.getItem());
            if (this.getItem() != null && !((ChannelMap)this.getItem()).isValid()) {
                Alert alert = new Alert(Alert.AlertType.WARNING);
                Text text1 = new Text("Channel range(s) have errors that must be fixed:");
                text1.setWrappingWidth(300.0);
                Text text2 = new Text("- Verify that the first channel number is less than the last channel number");
                text2.setWrappingWidth(300.0);
                Text text3 = new Text("- Verify that channel numbers in each range do not overlap with other channel ranges.");
                text3.setWrappingWidth(300.0);
                VBox vbox = new VBox();
                vbox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
                vbox.setSpacing(10.0);
                vbox.getChildren().addAll((Object[])new Node[]{text1, text2, text3});
                alert.getDialogPane().setContent((Node)vbox);
                alert.setTitle("Channel Map Error");
                alert.setHeaderText("Channel Map has errors");
                alert.initOwner(this.getSaveButton().getScene().getWindow());
                alert.setResizable(true);
                alert.onShownProperty().addListener(e -> Platform.runLater(() -> alert.setResizable(false)));
                alert.showAndWait();
                for (ChannelRange channelRange : ((ChannelMap)this.getItem()).getRanges()) {
                    if (!channelRange.isOverlapping() && channelRange.isValid()) continue;
                    this.getChannelRangeTableView().getSelectionModel().select((Object)channelRange);
                    break;
                }
            }
            this.getChannelRangeTableView().getSelectionModel().select((Object)selectedChannelRange);
        }

        @Override
        public void dispose() {
        }

        @Override
        public void setItem(ChannelMap item) {
            if (this.modifiedProperty().get()) {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.getButtonTypes().clear();
                alert.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.NO, ButtonType.YES});
                alert.setTitle("Save Changes");
                alert.setHeaderText("Channel Map has been modified");
                alert.setContentText("Do you want to save these changes?");
                alert.initOwner(this.getSaveButton().getScene().getWindow());
                Optional result = alert.showAndWait();
                if (result.get() == ButtonType.YES) {
                    this.save();
                }
            }
            super.setItem(item);
            this.getNameField().setDisable(item == null);
            this.getChannelRangeTableView().getItems().clear();
            this.getChannelRangeTableView().setDisable(item == null);
            if (item != null) {
                this.getNameField().setText(item.getName());
                this.getChannelRangeTableView().getItems().addAll(item.getRanges());
            }
            this.updateChannelRangeButtons();
            this.modifiedProperty().set(false);
        }

        private TextField getNameField() {
            if (this.mNameField == null) {
                this.mNameField = new TextField();
                this.mNameField.setMaxWidth(Double.MAX_VALUE);
                this.mNameField.setDisable(true);
                this.mNameField.textProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
            }
            return this.mNameField;
        }

        private TableView<ChannelRange> getChannelRangeTableView() {
            if (this.mChannelRangeTableView == null) {
                this.mChannelRangeTableView = new TableView();
                TableColumn firstColumn = new TableColumn("First");
                firstColumn.setCellValueFactory((Callback)new PropertyValueFactory("firstChannel"));
                firstColumn.setCellFactory(param -> new ColorTableCell(ChannelMapEditor.this));
                TableColumn lastColumn = new TableColumn("Last");
                lastColumn.setCellValueFactory((Callback)new PropertyValueFactory("lastChannel"));
                lastColumn.setCellFactory(param -> new ColorTableCell(ChannelMapEditor.this));
                TableColumn baseColumn = new TableColumn("Base");
                baseColumn.setCellValueFactory((Callback)new PropertyValueFactory("baseFrequency"));
                baseColumn.setPrefWidth(95.0);
                TableColumn stepColumn = new TableColumn("Step");
                stepColumn.setCellValueFactory((Callback)new PropertyValueFactory("stepSize"));
                this.mChannelRangeTableView.getColumns().addAll((Object[])new TableColumn[]{firstColumn, lastColumn, baseColumn, stepColumn});
                this.mChannelRangeTableView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, selected) -> {
                    ChannelMapEditor.this.getFirstField().setDisable(selected == null);
                    ChannelMapEditor.this.getLastField().setDisable(selected == null);
                    ChannelMapEditor.this.getBaseFrequencyField().setDisable(selected == null);
                    ChannelMapEditor.this.getStepSizeField().setDisable(selected == null);
                    boolean modified = this.modifiedProperty().get();
                    if (selected != null) {
                        ChannelMapEditor.this.getFirstField().set(selected.getFirstChannelNumber());
                        ChannelMapEditor.this.getLastField().set(selected.getLastChannelNumber());
                        ChannelMapEditor.this.getBaseFrequencyField().set(selected.getBaseFrequency());
                        ChannelMapEditor.this.getStepSizeField().set(selected.getStepSize());
                    } else {
                        ChannelMapEditor.this.getFirstField().setText("");
                        ChannelMapEditor.this.getLastField().setText("");
                        ChannelMapEditor.this.getBaseFrequencyField().setText("");
                        ChannelMapEditor.this.getStepSizeField().setText("");
                    }
                    this.updateChannelRangeButtons();
                    this.modifiedProperty().set(modified);
                });
            }
            return this.mChannelRangeTableView;
        }

        private Button getSaveButton() {
            if (this.mSaveButton == null) {
                this.mSaveButton = new Button("Save");
                this.mSaveButton.setTooltip(new Tooltip("Save changes to the Channel Map"));
                this.mSaveButton.setMaxWidth(Double.MAX_VALUE);
                this.mSaveButton.setDisable(true);
                this.mSaveButton.setOnAction(event -> this.save());
            }
            return this.mSaveButton;
        }

        private Button getResetButton() {
            if (this.mResetButton == null) {
                this.mResetButton = new Button("Reset");
                this.mResetButton.setTooltip(new Tooltip("Undo any changes made to the channel map"));
                this.mResetButton.setMaxWidth(Double.MAX_VALUE);
                this.mResetButton.setDisable(true);
                this.mResetButton.setOnAction(event -> {
                    this.modifiedProperty().set(false);
                    this.setItem((ChannelMap)this.getItem());
                });
            }
            return this.mResetButton;
        }

        private Button getNewRangeButton() {
            if (this.mNewRangeButton == null) {
                this.mNewRangeButton = new Button("New Range");
                ChannelMapEditor.this.mNewMapButton.setTooltip(new Tooltip("Add a new channel range to the channel map"));
                this.mNewRangeButton.setMaxWidth(Double.MAX_VALUE);
                this.mNewRangeButton.setDisable(true);
                this.mNewRangeButton.setOnAction(event -> {
                    if (this.getItem() != null) {
                        ChannelRange channelRange = new ChannelRange();
                        this.getChannelRangeTableView().getItems().add((Object)channelRange);
                        this.getChannelRangeTableView().getSelectionModel().select((Object)channelRange);
                        this.modifiedProperty().set(true);
                    }
                });
            }
            return this.mNewRangeButton;
        }

        private Button getDeleteRangeButton() {
            if (this.mDeleteRangeButton == null) {
                this.mDeleteRangeButton = new Button("Delete Range");
                this.mDeleteRangeButton.setTooltip(new Tooltip("Delete the currently selected channel range"));
                this.mDeleteRangeButton.setMaxWidth(Double.MAX_VALUE);
                this.mDeleteRangeButton.setDisable(true);
                this.mDeleteRangeButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        ChannelRange selected;
                        if (MapEditor.this.getItem() != null && (selected = (ChannelRange)MapEditor.this.getChannelRangeTableView().getSelectionModel().getSelectedItem()) != null) {
                            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to delete the selected channel range?", new ButtonType[]{ButtonType.NO, ButtonType.YES});
                            alert.setTitle("Delete Channel Range");
                            alert.setHeaderText("Are you sure?");
                            alert.initOwner(MapEditor.this.getDeleteRangeButton().getScene().getWindow());
                            Optional result = alert.showAndWait();
                            if (result.get() == ButtonType.YES) {
                                MapEditor.this.getChannelRangeTableView().getItems().remove((Object)selected);
                                MapEditor.this.updateChannelRangeButtons();
                                MapEditor.this.modifiedProperty().set(true);
                            }
                        }
                    }
                });
            }
            return this.mDeleteRangeButton;
        }
    }

    public class ColorTableCell
    extends TableCell<ChannelRange, Integer> {
        private static final String BACKGROUND_COLOR_RED = "-fx-background-color: red;";
        private static final String BACKGROND_COLOR_NONE = "-fx-background-color: null;";

        public ColorTableCell(ChannelMapEditor this$0) {
        }

        protected void updateItem(Integer item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item == null || empty) {
                this.setText(null);
            } else {
                this.setText(item.toString());
            }
            boolean invalidRange = this.getTableRow().getItem() != null && (!((ChannelRange)this.getTableRow().getItem()).isValid() || ((ChannelRange)this.getTableRow().getItem()).isOverlapping() || item == null || empty);
            this.setStyle(invalidRange ? BACKGROUND_COLOR_RED : BACKGROND_COLOR_NONE);
        }

        protected boolean isItemChanged(Integer oldItem, Integer newItem) {
            return super.isItemChanged((Object)oldItem, (Object)newItem);
        }
    }

    public class ChannelNumberCell
    implements Callback<TableColumn<ChannelRange, Integer>, TableCell<ChannelRange, Integer>> {
        public TableCell<ChannelRange, Integer> call(TableColumn<ChannelRange, Integer> param) {
            return new ColorTableCell(ChannelMapEditor.this);
        }
    }
}

