/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.channel;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.gui.control.IntegerTextField;
import io.github.dsheirer.gui.playlist.channel.ChannelConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.IFilterProcessor;
import io.github.dsheirer.gui.playlist.eventlog.EventLogConfigurationEditor;
import io.github.dsheirer.gui.playlist.record.RecordConfigurationEditor;
import io.github.dsheirer.gui.playlist.source.FrequencyEditor;
import io.github.dsheirer.gui.playlist.source.SourceConfigurationEditor;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.config.AuxDecodeConfiguration;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.p25.phase2.DecodeConfigP25Phase2;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.ScrambleParameters;
import io.github.dsheirer.module.log.EventLogType;
import io.github.dsheirer.module.log.config.EventLogConfiguration;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.record.RecorderType;
import io.github.dsheirer.record.config.RecordConfiguration;
import io.github.dsheirer.source.config.SourceConfiguration;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import java.util.ArrayList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P2ConfigurationEditor
extends ChannelConfigurationEditor {
    private static final Logger mLog = LoggerFactory.getLogger(P25P2ConfigurationEditor.class);
    private TitledPane mDecoderPane;
    private TitledPane mEventLogPane;
    private TitledPane mRecordPane;
    private TitledPane mSourcePane;
    private SourceConfigurationEditor mSourceConfigurationEditor;
    private EventLogConfigurationEditor mEventLogConfigurationEditor;
    private RecordConfigurationEditor mRecordConfigurationEditor;
    private IntegerTextField mWacnTextField;
    private IntegerTextField mSystemTextField;
    private IntegerTextField mNacTextField;

    public P25P2ConfigurationEditor(PlaylistManager playlistManager, TunerManager tunerManager, UserPreferences userPreferences, IFilterProcessor filterProcessor) {
        super(playlistManager, tunerManager, userPreferences, filterProcessor);
        this.getTitledPanesBox().getChildren().add((Object)this.getSourcePane());
        this.getTitledPanesBox().getChildren().add((Object)this.getDecoderPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getEventLogPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getRecordPane());
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.P25_PHASE2;
    }

    private TitledPane getSourcePane() {
        if (this.mSourcePane == null) {
            this.mSourcePane = new TitledPane("Source", (Node)this.getSourceConfigurationEditor());
            this.mSourcePane.setExpanded(true);
        }
        return this.mSourcePane;
    }

    private TitledPane getDecoderPane() {
        if (this.mDecoderPane == null) {
            this.mDecoderPane = new TitledPane();
            this.mDecoderPane.setText("Decoder: P25 Phase 2");
            this.mDecoderPane.setExpanded(true);
            GridPane gridPane = new GridPane();
            gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            gridPane.setHgap(10.0);
            gridPane.setVgap(10.0);
            int row = 0;
            Label wacnLabel = new Label("WACN");
            GridPane.setHalignment((Node)wacnLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)wacnLabel, (int)0, (int)(++row));
            gridPane.getChildren().add((Object)wacnLabel);
            GridPane.setConstraints((Node)this.getWacnTextField(), (int)1, (int)row);
            gridPane.getChildren().add((Object)this.getWacnTextField());
            Label systemLabel = new Label("System");
            GridPane.setHalignment((Node)systemLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)systemLabel, (int)0, (int)(++row));
            gridPane.getChildren().add((Object)systemLabel);
            GridPane.setConstraints((Node)this.getSystemTextField(), (int)1, (int)row);
            gridPane.getChildren().add((Object)this.getSystemTextField());
            Label nacLabel = new Label("NAC");
            GridPane.setHalignment((Node)nacLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)nacLabel, (int)0, (int)(++row));
            gridPane.getChildren().add((Object)nacLabel);
            GridPane.setConstraints((Node)this.getNacTextField(), (int)1, (int)row);
            gridPane.getChildren().add((Object)this.getNacTextField());
            this.mDecoderPane.setContent((Node)gridPane);
        }
        return this.mDecoderPane;
    }

    private TitledPane getEventLogPane() {
        if (this.mEventLogPane == null) {
            this.mEventLogPane = new TitledPane("Logging", (Node)this.getEventLogConfigurationEditor());
            this.mEventLogPane.setExpanded(false);
        }
        return this.mEventLogPane;
    }

    private TitledPane getRecordPane() {
        if (this.mRecordPane == null) {
            this.mRecordPane = new TitledPane();
            this.mRecordPane.setText("Recording");
            this.mRecordPane.setExpanded(false);
            Label notice = new Label("Note: use aliases to control call audio recording");
            notice.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
            VBox vBox = new VBox();
            vBox.getChildren().addAll((Object[])new Node[]{this.getRecordConfigurationEditor(), notice});
            this.mRecordPane.setContent((Node)vBox);
        }
        return this.mRecordPane;
    }

    private SourceConfigurationEditor getSourceConfigurationEditor() {
        if (this.mSourceConfigurationEditor == null) {
            this.mSourceConfigurationEditor = new FrequencyEditor(this.mTunerManager);
            this.mSourceConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mSourceConfigurationEditor;
    }

    private EventLogConfigurationEditor getEventLogConfigurationEditor() {
        if (this.mEventLogConfigurationEditor == null) {
            ArrayList<EventLogType> types = new ArrayList<EventLogType>();
            types.add(EventLogType.CALL_EVENT);
            types.add(EventLogType.DECODED_MESSAGE);
            this.mEventLogConfigurationEditor = new EventLogConfigurationEditor(types);
            this.mEventLogConfigurationEditor.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            this.mEventLogConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mEventLogConfigurationEditor;
    }

    private IntegerTextField getWacnTextField() {
        if (this.mWacnTextField == null) {
            this.mWacnTextField = new IntegerTextField();
            this.mWacnTextField.setDisable(true);
            this.mWacnTextField.textProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mWacnTextField;
    }

    private IntegerTextField getSystemTextField() {
        if (this.mSystemTextField == null) {
            this.mSystemTextField = new IntegerTextField();
            this.mSystemTextField.setDisable(true);
            this.mSystemTextField.textProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mSystemTextField;
    }

    private IntegerTextField getNacTextField() {
        if (this.mNacTextField == null) {
            this.mNacTextField = new IntegerTextField();
            this.mNacTextField.setDisable(true);
            this.mNacTextField.textProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mNacTextField;
    }

    private RecordConfigurationEditor getRecordConfigurationEditor() {
        if (this.mRecordConfigurationEditor == null) {
            ArrayList<RecorderType> types = new ArrayList<RecorderType>();
            types.add(RecorderType.BASEBAND);
            types.add(RecorderType.DEMODULATED_BIT_STREAM);
            types.add(RecorderType.MBE_CALL_SEQUENCE);
            this.mRecordConfigurationEditor = new RecordConfigurationEditor(types);
            this.mRecordConfigurationEditor.setDisable(true);
            this.mRecordConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mRecordConfigurationEditor;
    }

    @Override
    protected void setDecoderConfiguration(DecodeConfiguration config) {
        if (config instanceof DecodeConfigP25Phase2) {
            DecodeConfigP25Phase2 decodeConfig = (DecodeConfigP25Phase2)config;
            this.getWacnTextField().setDisable(false);
            this.getSystemTextField().setDisable(false);
            this.getNacTextField().setDisable(false);
            ScrambleParameters scrambleParameters = decodeConfig.getScrambleParameters();
            if (scrambleParameters != null) {
                this.getWacnTextField().set(scrambleParameters.getWACN());
                this.getSystemTextField().set(scrambleParameters.getSystem());
                this.getNacTextField().set(scrambleParameters.getNAC());
            } else {
                this.getWacnTextField().set(0);
                this.getSystemTextField().set(0);
                this.getNacTextField().set(0);
            }
        } else {
            this.getWacnTextField().set(0);
            this.getSystemTextField().set(0);
            this.getNacTextField().set(0);
            this.getWacnTextField().setDisable(true);
            this.getSystemTextField().setDisable(true);
            this.getNacTextField().setDisable(true);
        }
    }

    @Override
    protected void saveDecoderConfiguration() {
        DecodeConfigP25Phase2 config;
        if (((Channel)this.getItem()).getDecodeConfiguration() instanceof DecodeConfigP25Phase2) {
            config = (DecodeConfigP25Phase2)((Channel)this.getItem()).getDecodeConfiguration();
            config.setAutoDetectScrambleParameters(false);
            int wacn = this.getWacnTextField().get();
            int system = this.getSystemTextField().get();
            int nac = this.getNacTextField().get();
            config.setScrambleParameters(new ScrambleParameters(wacn, system, nac));
        } else {
            config = new DecodeConfigP25Phase2();
        }
        ((Channel)this.getItem()).setDecodeConfiguration(config);
    }

    @Override
    protected void setEventLogConfiguration(EventLogConfiguration config) {
        this.getEventLogConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveEventLogConfiguration() {
        this.getEventLogConfigurationEditor().save();
        if (((EventLogConfiguration)this.getEventLogConfigurationEditor().getItem()).getLoggers().isEmpty()) {
            ((Channel)this.getItem()).setEventLogConfiguration(null);
        } else {
            ((Channel)this.getItem()).setEventLogConfiguration((EventLogConfiguration)this.getEventLogConfigurationEditor().getItem());
        }
    }

    @Override
    protected void setAuxDecoderConfiguration(AuxDecodeConfiguration config) {
    }

    @Override
    protected void saveAuxDecoderConfiguration() {
    }

    @Override
    protected void setRecordConfiguration(RecordConfiguration config) {
        this.getRecordConfigurationEditor().setDisable(config == null);
        this.getRecordConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveRecordConfiguration() {
        this.getRecordConfigurationEditor().save();
        RecordConfiguration config = (RecordConfiguration)this.getRecordConfigurationEditor().getItem();
        ((Channel)this.getItem()).setRecordConfiguration(config);
    }

    @Override
    protected void setSourceConfiguration(SourceConfiguration config) {
        this.getSourceConfigurationEditor().setSourceConfiguration(config);
    }

    @Override
    protected void saveSourceConfiguration() {
        this.getSourceConfigurationEditor().save();
        Object sourceConfiguration = this.getSourceConfigurationEditor().getSourceConfiguration();
        ((Channel)this.getItem()).setSourceConfiguration((SourceConfiguration)sourceConfiguration);
    }
}

