/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.channel;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.gui.playlist.channel.ChannelConfigurationEditor;
import io.github.dsheirer.gui.playlist.channel.IFilterProcessor;
import io.github.dsheirer.gui.playlist.eventlog.EventLogConfigurationEditor;
import io.github.dsheirer.gui.playlist.record.RecordConfigurationEditor;
import io.github.dsheirer.gui.playlist.source.FrequencyEditor;
import io.github.dsheirer.gui.playlist.source.SourceConfigurationEditor;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.config.AuxDecodeConfiguration;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.p25.phase1.DecodeConfigP25Phase1;
import io.github.dsheirer.module.decode.p25.phase1.P25P1Decoder;
import io.github.dsheirer.module.log.EventLogType;
import io.github.dsheirer.module.log.config.EventLogConfiguration;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.record.RecorderType;
import io.github.dsheirer.record.config.RecordConfiguration;
import io.github.dsheirer.source.config.SourceConfiguration;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import java.util.ArrayList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import org.controlsfx.control.SegmentedButton;
import org.controlsfx.control.ToggleSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P1ConfigurationEditor
extends ChannelConfigurationEditor {
    private static final Logger mLog = LoggerFactory.getLogger(P25P1ConfigurationEditor.class);
    private TitledPane mDecoderPane;
    private TitledPane mEventLogPane;
    private TitledPane mRecordPane;
    private TitledPane mSourcePane;
    private SourceConfigurationEditor mSourceConfigurationEditor;
    private EventLogConfigurationEditor mEventLogConfigurationEditor;
    private RecordConfigurationEditor mRecordConfigurationEditor;
    private ToggleSwitch mIgnoreDataCallsButton;
    private Spinner<Integer> mTrafficChannelPoolSizeSpinner;
    private SegmentedButton mModulationSegmentedButton;
    private ToggleButton mC4FMToggleButton;
    private ToggleButton mLSMToggleButton;

    public P25P1ConfigurationEditor(PlaylistManager playlistManager, TunerManager tunerManager, UserPreferences userPreferences, IFilterProcessor filterProcessor) {
        super(playlistManager, tunerManager, userPreferences, filterProcessor);
        this.getTitledPanesBox().getChildren().add((Object)this.getSourcePane());
        this.getTitledPanesBox().getChildren().add((Object)this.getDecoderPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getEventLogPane());
        this.getTitledPanesBox().getChildren().add((Object)this.getRecordPane());
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.P25_PHASE1;
    }

    private TitledPane getSourcePane() {
        if (this.mSourcePane == null) {
            this.mSourcePane = new TitledPane("Source", (Node)this.getSourceConfigurationEditor());
            this.mSourcePane.setExpanded(true);
        }
        return this.mSourcePane;
    }

    private TitledPane getDecoderPane() {
        if (this.mDecoderPane == null) {
            this.mDecoderPane = new TitledPane();
            this.mDecoderPane.setText("Decoder: P25 Phase 1 (or P25 Phase 2 Control Channel)");
            this.mDecoderPane.setExpanded(true);
            GridPane gridPane = new GridPane();
            gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            gridPane.setHgap(10.0);
            gridPane.setVgap(10.0);
            Label modulationLabel = new Label("Modulation");
            GridPane.setHalignment((Node)modulationLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)modulationLabel, (int)0, (int)0);
            gridPane.getChildren().add((Object)modulationLabel);
            GridPane.setConstraints((Node)this.getModulationSegmentedButton(), (int)1, (int)0);
            gridPane.getChildren().addAll((Object[])new Node[]{this.getModulationSegmentedButton()});
            Label poolSizeLabel = new Label("Max Traffic Channels");
            GridPane.setHalignment((Node)poolSizeLabel, (HPos)HPos.RIGHT);
            GridPane.setConstraints((Node)poolSizeLabel, (int)2, (int)0);
            gridPane.getChildren().add((Object)poolSizeLabel);
            GridPane.setConstraints(this.getTrafficChannelPoolSizeSpinner(), (int)3, (int)0);
            gridPane.getChildren().add(this.getTrafficChannelPoolSizeSpinner());
            GridPane.setConstraints((Node)this.getIgnoreDataCallsButton(), (int)4, (int)0);
            gridPane.getChildren().add((Object)this.getIgnoreDataCallsButton());
            Label directionLabel = new Label("Ignore Data Calls");
            GridPane.setHalignment((Node)directionLabel, (HPos)HPos.LEFT);
            GridPane.setConstraints((Node)directionLabel, (int)5, (int)0);
            gridPane.getChildren().add((Object)directionLabel);
            Label modulationHelpLabel = new Label("C4FM: repeaters and non-simulcast trunked systems.  LSM: simulcast trunked systems.");
            GridPane.setConstraints((Node)modulationHelpLabel, (int)0, (int)1, (int)6, (int)1);
            gridPane.getChildren().add((Object)modulationHelpLabel);
            this.mDecoderPane.setContent((Node)gridPane);
        }
        return this.mDecoderPane;
    }

    private TitledPane getEventLogPane() {
        if (this.mEventLogPane == null) {
            this.mEventLogPane = new TitledPane("Logging", (Node)this.getEventLogConfigurationEditor());
            this.mEventLogPane.setExpanded(false);
        }
        return this.mEventLogPane;
    }

    private TitledPane getRecordPane() {
        if (this.mRecordPane == null) {
            this.mRecordPane = new TitledPane();
            this.mRecordPane.setText("Recording");
            this.mRecordPane.setExpanded(false);
            Label notice = new Label("Note: use aliases to control call audio recording");
            notice.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
            VBox vBox = new VBox();
            vBox.getChildren().addAll((Object[])new Node[]{this.getRecordConfigurationEditor(), notice});
            this.mRecordPane.setContent((Node)vBox);
        }
        return this.mRecordPane;
    }

    private SourceConfigurationEditor getSourceConfigurationEditor() {
        if (this.mSourceConfigurationEditor == null) {
            this.mSourceConfigurationEditor = new FrequencyEditor(this.mTunerManager, 400, 2000, 500);
            this.mSourceConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mSourceConfigurationEditor;
    }

    private EventLogConfigurationEditor getEventLogConfigurationEditor() {
        if (this.mEventLogConfigurationEditor == null) {
            ArrayList<EventLogType> types = new ArrayList<EventLogType>();
            types.add(EventLogType.CALL_EVENT);
            types.add(EventLogType.DECODED_MESSAGE);
            types.add(EventLogType.TRAFFIC_CALL_EVENT);
            types.add(EventLogType.TRAFFIC_DECODED_MESSAGE);
            this.mEventLogConfigurationEditor = new EventLogConfigurationEditor(types);
            this.mEventLogConfigurationEditor.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            this.mEventLogConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mEventLogConfigurationEditor;
    }

    private SegmentedButton getModulationSegmentedButton() {
        if (this.mModulationSegmentedButton == null) {
            this.mModulationSegmentedButton = new SegmentedButton();
            this.mModulationSegmentedButton.getStyleClass().add((Object)"dark");
            this.mModulationSegmentedButton.getButtons().addAll((Object[])new ToggleButton[]{this.getC4FMToggleButton(), this.getLSMToggleButton()});
            this.mModulationSegmentedButton.getToggleGroup().selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                    if (newValue == null) {
                        oldValue.setSelected(true);
                    } else if (oldValue != null && newValue != null) {
                        P25P1ConfigurationEditor.this.modifiedProperty().set(true);
                    }
                }
            });
        }
        return this.mModulationSegmentedButton;
    }

    private ToggleButton getC4FMToggleButton() {
        if (this.mC4FMToggleButton == null) {
            this.mC4FMToggleButton = new ToggleButton("C4FM");
        }
        return this.mC4FMToggleButton;
    }

    private ToggleButton getLSMToggleButton() {
        if (this.mLSMToggleButton == null) {
            this.mLSMToggleButton = new ToggleButton("LSM");
        }
        return this.mLSMToggleButton;
    }

    private ToggleSwitch getIgnoreDataCallsButton() {
        if (this.mIgnoreDataCallsButton == null) {
            this.mIgnoreDataCallsButton = new ToggleSwitch();
            this.mIgnoreDataCallsButton.setDisable(true);
            this.mIgnoreDataCallsButton.selectedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mIgnoreDataCallsButton;
    }

    private Spinner<Integer> getTrafficChannelPoolSizeSpinner() {
        if (this.mTrafficChannelPoolSizeSpinner == null) {
            this.mTrafficChannelPoolSizeSpinner = new Spinner();
            this.mTrafficChannelPoolSizeSpinner.setDisable(true);
            this.mTrafficChannelPoolSizeSpinner.setTooltip(new Tooltip("Maximum number of traffic channels that can be created by the decoder"));
            this.mTrafficChannelPoolSizeSpinner.getStyleClass().add((Object)"split-arrows-horizontal");
            SpinnerValueFactory.IntegerSpinnerValueFactory svf = new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 50);
            this.mTrafficChannelPoolSizeSpinner.setValueFactory((SpinnerValueFactory)svf);
            this.mTrafficChannelPoolSizeSpinner.getValueFactory().valueProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mTrafficChannelPoolSizeSpinner;
    }

    private RecordConfigurationEditor getRecordConfigurationEditor() {
        if (this.mRecordConfigurationEditor == null) {
            ArrayList<RecorderType> types = new ArrayList<RecorderType>();
            types.add(RecorderType.BASEBAND);
            types.add(RecorderType.DEMODULATED_BIT_STREAM);
            types.add(RecorderType.MBE_CALL_SEQUENCE);
            types.add(RecorderType.TRAFFIC_BASEBAND);
            types.add(RecorderType.TRAFFIC_DEMODULATED_BIT_STREAM);
            types.add(RecorderType.TRAFFIC_MBE_CALL_SEQUENCE);
            this.mRecordConfigurationEditor = new RecordConfigurationEditor(types);
            this.mRecordConfigurationEditor.setDisable(true);
            this.mRecordConfigurationEditor.modifiedProperty().addListener((observable, oldValue, newValue) -> this.modifiedProperty().set(true));
        }
        return this.mRecordConfigurationEditor;
    }

    @Override
    protected void setDecoderConfiguration(DecodeConfiguration config) {
        this.getIgnoreDataCallsButton().setDisable(config == null);
        this.getTrafficChannelPoolSizeSpinner().setDisable(config == null);
        if (config instanceof DecodeConfigP25Phase1) {
            DecodeConfigP25Phase1 decodeConfig = (DecodeConfigP25Phase1)config;
            this.getIgnoreDataCallsButton().setSelected(decodeConfig.getIgnoreDataCalls());
            this.getTrafficChannelPoolSizeSpinner().getValueFactory().setValue((Object)decodeConfig.getTrafficChannelPoolSize());
            if (decodeConfig.getModulation() == P25P1Decoder.Modulation.C4FM) {
                this.getC4FMToggleButton().setSelected(true);
                this.getLSMToggleButton().setSelected(false);
            } else {
                this.getC4FMToggleButton().setSelected(false);
                this.getLSMToggleButton().setSelected(true);
            }
        } else {
            this.getIgnoreDataCallsButton().setSelected(false);
            this.getTrafficChannelPoolSizeSpinner().getValueFactory().setValue((Object)0);
        }
    }

    @Override
    protected void saveDecoderConfiguration() {
        DecodeConfigP25Phase1 config = ((Channel)this.getItem()).getDecodeConfiguration() instanceof DecodeConfigP25Phase1 ? (DecodeConfigP25Phase1)((Channel)this.getItem()).getDecodeConfiguration() : new DecodeConfigP25Phase1();
        config.setIgnoreDataCalls(this.getIgnoreDataCallsButton().isSelected());
        config.setTrafficChannelPoolSize((Integer)this.getTrafficChannelPoolSizeSpinner().getValue());
        config.setModulation(this.getC4FMToggleButton().isSelected() ? P25P1Decoder.Modulation.C4FM : P25P1Decoder.Modulation.CQPSK);
        ((Channel)this.getItem()).setDecodeConfiguration(config);
    }

    @Override
    protected void setEventLogConfiguration(EventLogConfiguration config) {
        this.getEventLogConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveEventLogConfiguration() {
        this.getEventLogConfigurationEditor().save();
        if (((EventLogConfiguration)this.getEventLogConfigurationEditor().getItem()).getLoggers().isEmpty()) {
            ((Channel)this.getItem()).setEventLogConfiguration(null);
        } else {
            ((Channel)this.getItem()).setEventLogConfiguration((EventLogConfiguration)this.getEventLogConfigurationEditor().getItem());
        }
    }

    @Override
    protected void setAuxDecoderConfiguration(AuxDecodeConfiguration config) {
    }

    @Override
    protected void saveAuxDecoderConfiguration() {
    }

    @Override
    protected void setRecordConfiguration(RecordConfiguration config) {
        this.getRecordConfigurationEditor().setDisable(config == null);
        this.getRecordConfigurationEditor().setItem(config);
    }

    @Override
    protected void saveRecordConfiguration() {
        this.getRecordConfigurationEditor().save();
        RecordConfiguration config = (RecordConfiguration)this.getRecordConfigurationEditor().getItem();
        ((Channel)this.getItem()).setRecordConfiguration(config);
    }

    @Override
    protected void setSourceConfiguration(SourceConfiguration config) {
        this.getSourceConfigurationEditor().setSourceConfiguration(config);
    }

    @Override
    protected void saveSourceConfiguration() {
        this.getSourceConfigurationEditor().save();
        Object sourceConfiguration = this.getSourceConfigurationEditor().getSourceConfiguration();
        ((Channel)this.getItem()).setSourceConfiguration((SourceConfiguration)sourceConfiguration);
    }
}

