/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias.identifier;

import io.github.dsheirer.alias.id.talkgroup.TalkgroupRange;
import io.github.dsheirer.gui.control.HexFormatter;
import io.github.dsheirer.gui.control.IntegerFormatter;
import io.github.dsheirer.gui.control.LtrFormatter;
import io.github.dsheirer.gui.control.PrefixIdentFormatter;
import io.github.dsheirer.gui.playlist.alias.identifier.IdentifierEditor;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TalkgroupRangeEditor
extends IdentifierEditor<TalkgroupRange> {
    private static final Logger mLog = LoggerFactory.getLogger(TalkgroupRangeEditor.class);
    private UserPreferences mUserPreferences;
    private Label mProtocolLabel;
    private Label mFormatLabel;
    private TextField mMinTalkgroupField;
    private TextField mMaxTalkgroupField;
    private TextFormatter<Integer> mMinIntegerTextFormatter;
    private TextFormatter<Integer> mMaxIntegerTextFormatter;
    private List<TalkgroupDetail> mTalkgroupDetails;
    private MinTalkgroupValueChangeListener mMinTalkgroupValueChangeListener = new MinTalkgroupValueChangeListener();
    private MaxTalkgroupValueChangeListener mMaxTalkgroupValueChangeListener = new MaxTalkgroupValueChangeListener();

    public TalkgroupRangeEditor(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        this.mTalkgroupDetails = this.createTalkgroupDetails();
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(3.0);
        GridPane.setConstraints((Node)this.getProtocolLabel(), (int)0, (int)0);
        gridPane.getChildren().add((Object)this.getProtocolLabel());
        Label valueLabel = new Label("Talkgroup Range");
        GridPane.setHalignment((Node)valueLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)valueLabel, (int)1, (int)0);
        gridPane.getChildren().add((Object)valueLabel);
        GridPane.setConstraints((Node)this.getMinTalkgroupField(), (int)2, (int)0);
        gridPane.getChildren().add((Object)this.getMinTalkgroupField());
        Label dashLabel = new Label("-");
        GridPane.setConstraints((Node)dashLabel, (int)3, (int)0);
        gridPane.getChildren().add((Object)dashLabel);
        GridPane.setConstraints((Node)this.getMaxTalkgroupField(), (int)4, (int)0);
        gridPane.getChildren().add((Object)this.getMaxTalkgroupField());
        GridPane.setConstraints((Node)this.getFormatLabel(), (int)5, (int)0);
        gridPane.getChildren().add((Object)this.getFormatLabel());
        this.getChildren().add((Object)gridPane);
    }

    @Override
    public void setItem(TalkgroupRange item) {
        super.setItem(item);
        TalkgroupRange talkgroupRange = (TalkgroupRange)this.getItem();
        this.getProtocolLabel().setDisable(talkgroupRange == null);
        this.getMinTalkgroupField().setDisable(talkgroupRange == null);
        this.getMaxTalkgroupField().setDisable(talkgroupRange == null);
        if (talkgroupRange != null) {
            this.getProtocolLabel().setText(talkgroupRange.getProtocol().toString());
            this.updateTextFormatter();
        } else {
            this.getProtocolLabel().setText("Unrecognized Protocol");
            this.getMinTalkgroupField().setText(null);
            this.getMaxTalkgroupField().setText(null);
        }
        this.modifiedProperty().set(false);
    }

    private void updateTextFormatter() {
        IntegerFormat format;
        if (this.mMinIntegerTextFormatter != null) {
            this.mMinIntegerTextFormatter.valueProperty().removeListener((ChangeListener)this.mMinTalkgroupValueChangeListener);
        }
        if (this.mMaxIntegerTextFormatter != null) {
            this.mMaxIntegerTextFormatter.valueProperty().removeListener((ChangeListener)this.mMaxTalkgroupValueChangeListener);
        }
        if ((format = this.mUserPreferences.getTalkgroupFormatPreference().getTalkgroupFormat(((TalkgroupRange)this.getItem()).getProtocol())) != null) {
            TalkgroupDetail talkgroupDetail = this.getTalkgroupDetail(((TalkgroupRange)this.getItem()).getProtocol(), format);
            if (talkgroupDetail != null) {
                this.mMinIntegerTextFormatter = talkgroupDetail.getMinTextFormatter();
                Integer minValue = this.getItem() != null ? Integer.valueOf(((TalkgroupRange)this.getItem()).getMinTalkgroup()) : null;
                this.mMinTalkgroupField.setTextFormatter(this.mMinIntegerTextFormatter);
                this.mMinTalkgroupField.setTooltip(new Tooltip(talkgroupDetail.getTooltip()));
                this.mMinIntegerTextFormatter.setValue((Object)minValue);
                this.mMinIntegerTextFormatter.valueProperty().addListener((ChangeListener)this.mMinTalkgroupValueChangeListener);
                this.mMaxIntegerTextFormatter = talkgroupDetail.getMaxTextFormatter();
                Integer maxValue = this.getItem() != null ? Integer.valueOf(((TalkgroupRange)this.getItem()).getMaxTalkgroup()) : null;
                this.mMaxTalkgroupField.setTextFormatter(this.mMaxIntegerTextFormatter);
                this.mMaxTalkgroupField.setTooltip(new Tooltip(talkgroupDetail.getTooltip()));
                this.mMaxIntegerTextFormatter.setValue((Object)maxValue);
                this.mMaxIntegerTextFormatter.valueProperty().addListener((ChangeListener)this.mMaxTalkgroupValueChangeListener);
                this.getFormatLabel().setText(talkgroupDetail.getTooltip());
            } else {
                mLog.warn("Couldn't find talkgroup detail for protocol [" + String.valueOf((Object)((TalkgroupRange)this.getItem()).getProtocol()) + "] and format [" + String.valueOf((Object)format) + "]");
                this.getFormatLabel().setText(" ");
            }
        } else {
            this.getFormatLabel().setText(" ");
            this.mMinIntegerTextFormatter.setValue(null);
            this.mMaxIntegerTextFormatter.setValue(null);
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    private Label getFormatLabel() {
        if (this.mFormatLabel == null) {
            this.mFormatLabel = new Label(" ");
        }
        return this.mFormatLabel;
    }

    private Label getProtocolLabel() {
        if (this.mProtocolLabel == null) {
            this.mProtocolLabel = new Label();
        }
        return this.mProtocolLabel;
    }

    private TextField getMinTalkgroupField() {
        if (this.mMinTalkgroupField == null) {
            this.mMinTalkgroupField = new TextField();
            this.mMinTalkgroupField.setTextFormatter(this.mMinIntegerTextFormatter);
        }
        return this.mMinTalkgroupField;
    }

    private TextField getMaxTalkgroupField() {
        if (this.mMaxTalkgroupField == null) {
            this.mMaxTalkgroupField = new TextField();
            this.mMaxTalkgroupField.setTextFormatter(this.mMinIntegerTextFormatter);
        }
        return this.mMaxTalkgroupField;
    }

    private TalkgroupDetail getTalkgroupDetail(Protocol protocol, IntegerFormat integerFormat) {
        for (TalkgroupDetail detail : this.mTalkgroupDetails) {
            if (detail.getProtocol() != protocol || detail.getIntegerFormat() != integerFormat) continue;
            return detail;
        }
        mLog.warn("Unable to find talkgroup range editor for protocol [" + String.valueOf((Object)protocol) + "] and format [" + String.valueOf((Object)integerFormat) + "] - using default editor");
        for (TalkgroupDetail detail : this.mTalkgroupDetails) {
            if (detail.getProtocol() != Protocol.UNKNOWN || detail.getIntegerFormat() != integerFormat) continue;
            return detail;
        }
        mLog.warn("No Talkgroup Detail is configured for protocol [" + String.valueOf((Object)protocol) + "] and format [" + String.valueOf((Object)integerFormat) + "]");
        return null;
    }

    private List<TalkgroupDetail> createTalkgroupDetails() {
        ArrayList<TalkgroupDetail> details = new ArrayList<TalkgroupDetail>();
        details.add(new TalkgroupDetail(this, Protocol.AM, IntegerFormat.DECIMAL, new IntegerFormatter(0, 65535), new IntegerFormatter(0, 65535), "Format 0 - 65535"));
        details.add(new TalkgroupDetail(this, Protocol.AM, IntegerFormat.HEXADECIMAL, new IntegerFormatter(0, 65535), new IntegerFormatter(0, 65535), "Format 0 - FFFF"));
        details.add(new TalkgroupDetail(this, Protocol.APCO25, IntegerFormat.DECIMAL, new IntegerFormatter(0, 65535), new IntegerFormatter(0, 65535), "Format: 0 - 65535"));
        details.add(new TalkgroupDetail(this, Protocol.APCO25, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 65535), new HexFormatter(0, 65535), "Format: 0 - FFFF"));
        details.add(new TalkgroupDetail(this, Protocol.FLEETSYNC, IntegerFormat.FORMATTED, new PrefixIdentFormatter(0, 1048575), new PrefixIdentFormatter(0, 1048575), "Format: PPP-IIII = Prefix (0-127), Ident (0-8191)"));
        details.add(new TalkgroupDetail(this, Protocol.LTR, IntegerFormat.FORMATTED, new LtrFormatter(0, 16383), new LtrFormatter(0, 16383), "Format: A-HH-TTT = Area (0-1), Home (1-31), Talkgroup (1-255)"));
        details.add(new TalkgroupDetail(this, Protocol.MDC1200, IntegerFormat.DECIMAL, new IntegerFormatter(0, 65535), new IntegerFormatter(0, 65535), "Format: 0 - 65535"));
        details.add(new TalkgroupDetail(this, Protocol.MDC1200, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 65535), new HexFormatter(0, 65535), "Format: 0 - FFFF"));
        details.add(new TalkgroupDetail(this, Protocol.MPT1327, IntegerFormat.FORMATTED, new PrefixIdentFormatter(0, 1048575), new PrefixIdentFormatter(0, 1048575), "Format: PPP-IIII = Prefix (0-127), Ident (1-8191)"));
        details.add(new TalkgroupDetail(this, Protocol.NBFM, IntegerFormat.DECIMAL, new IntegerFormatter(0, 65535), new IntegerFormatter(0, 65535), "Format 0 - 65535"));
        details.add(new TalkgroupDetail(this, Protocol.NBFM, IntegerFormat.HEXADECIMAL, new IntegerFormatter(0, 65535), new IntegerFormatter(0, 65535), "Format 0 - FFFF"));
        details.add(new TalkgroupDetail(this, Protocol.PASSPORT, IntegerFormat.DECIMAL, new IntegerFormatter(0, 65535), new IntegerFormatter(0, 65535), "Format: 0 - 65535"));
        details.add(new TalkgroupDetail(this, Protocol.PASSPORT, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 65535), new HexFormatter(0, 65535), "Format: 0 - FFFF"));
        details.add(new TalkgroupDetail(this, Protocol.UNKNOWN, IntegerFormat.DECIMAL, new IntegerFormatter(0, 0xFFFFFF), new IntegerFormatter(0, 0xFFFFFF), "Format: 0 - 16777215"));
        details.add(new TalkgroupDetail(this, Protocol.UNKNOWN, IntegerFormat.FORMATTED, new IntegerFormatter(0, 0xFFFFFF), new IntegerFormatter(0, 0xFFFFFF), "Format: 0 - FFFFFF"));
        details.add(new TalkgroupDetail(this, Protocol.UNKNOWN, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 0xFFFFFF), new HexFormatter(0, 0xFFFFFF), "Format: 0 - FFFFFF"));
        details.add(new TalkgroupDetail(this, Protocol.DMR, IntegerFormat.DECIMAL, new IntegerFormatter(1, 0xFFFFFF), new IntegerFormatter(1, 0xFFFFFF), "Format: 1 - 16777215"));
        details.add(new TalkgroupDetail(this, Protocol.DMR, IntegerFormat.HEXADECIMAL, new HexFormatter(1, 0xFFFFFF), new HexFormatter(1, 0xFFFFFF), "Format: 0 - FFFFFF"));
        return details;
    }

    public class MinTalkgroupValueChangeListener
    implements ChangeListener<Integer> {
        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            if (TalkgroupRangeEditor.this.getItem() != null) {
                ((TalkgroupRange)TalkgroupRangeEditor.this.getItem()).setMinTalkgroup(newValue != null ? newValue : 0);
                TalkgroupRangeEditor.this.modifiedProperty().set(true);
            }
        }
    }

    public class MaxTalkgroupValueChangeListener
    implements ChangeListener<Integer> {
        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            if (TalkgroupRangeEditor.this.getItem() != null) {
                ((TalkgroupRange)TalkgroupRangeEditor.this.getItem()).setMaxTalkgroup(newValue != null ? newValue : 0);
                TalkgroupRangeEditor.this.modifiedProperty().set(true);
            }
        }
    }

    public class TalkgroupDetail {
        private Protocol mProtocol;
        private IntegerFormat mIntegerFormat;
        private TextFormatter<Integer> mMinTextFormatter;
        private TextFormatter<Integer> mMaxTextFormatter;
        private String mTooltip;

        public TalkgroupDetail(TalkgroupRangeEditor this$0, Protocol protocol, IntegerFormat integerFormat, TextFormatter<Integer> minTextFormatter, TextFormatter<Integer> maxTextFormatter, String tooltip) {
            this.mProtocol = protocol;
            this.mIntegerFormat = integerFormat;
            this.mMinTextFormatter = minTextFormatter;
            this.mMaxTextFormatter = maxTextFormatter;
            this.mTooltip = tooltip;
        }

        public Protocol getProtocol() {
            return this.mProtocol;
        }

        public IntegerFormat getIntegerFormat() {
            return this.mIntegerFormat;
        }

        public TextFormatter<Integer> getMinTextFormatter() {
            return this.mMinTextFormatter;
        }

        public TextFormatter<Integer> getMaxTextFormatter() {
            return this.mMaxTextFormatter;
        }

        public String getTooltip() {
            return this.mTooltip;
        }
    }
}

