/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias.identifier;

import io.github.dsheirer.alias.id.radio.RadioRange;
import io.github.dsheirer.gui.control.HexFormatter;
import io.github.dsheirer.gui.control.IntegerFormatter;
import io.github.dsheirer.gui.playlist.alias.identifier.IdentifierEditor;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioIdRangeEditor
extends IdentifierEditor<RadioRange> {
    private static final Logger mLog = LoggerFactory.getLogger(RadioIdRangeEditor.class);
    private UserPreferences mUserPreferences;
    private Label mProtocolLabel;
    private Label mFormatLabel;
    private TextField mMinRadioIdField;
    private TextField mMaxRadioIdField;
    private TextFormatter<Integer> mMinIntegerTextFormatter;
    private TextFormatter<Integer> mMaxIntegerTextFormatter;
    private List<RadioIdDetail> mRadioDetails;
    private MinRadioValueChangeListener mMinRadioValueChangeListener = new MinRadioValueChangeListener();
    private MaxRadioValueChangeListener mMaxRadioValueChangeListener = new MaxRadioValueChangeListener();

    public RadioIdRangeEditor(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        this.mRadioDetails = this.createRadioDetails();
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(3.0);
        GridPane.setConstraints((Node)this.getProtocolLabel(), (int)0, (int)0);
        gridPane.getChildren().add((Object)this.getProtocolLabel());
        Label valueLabel = new Label("Radio ID Range");
        GridPane.setHalignment((Node)valueLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)valueLabel, (int)1, (int)0);
        gridPane.getChildren().add((Object)valueLabel);
        GridPane.setConstraints((Node)this.getMinRadioIdField(), (int)2, (int)0);
        gridPane.getChildren().add((Object)this.getMinRadioIdField());
        Label dashLabel = new Label("-");
        GridPane.setConstraints((Node)dashLabel, (int)3, (int)0);
        gridPane.getChildren().add((Object)dashLabel);
        GridPane.setConstraints((Node)this.getMaxRadioIdField(), (int)4, (int)0);
        gridPane.getChildren().add((Object)this.getMaxRadioIdField());
        GridPane.setConstraints((Node)this.getFormatLabel(), (int)5, (int)0);
        gridPane.getChildren().add((Object)this.getFormatLabel());
        this.getChildren().add((Object)gridPane);
    }

    @Override
    public void setItem(RadioRange item) {
        super.setItem(item);
        RadioRange radioRange = (RadioRange)this.getItem();
        this.getProtocolLabel().setDisable(radioRange == null);
        this.getMinRadioIdField().setDisable(radioRange == null);
        this.getMaxRadioIdField().setDisable(radioRange == null);
        if (radioRange != null) {
            this.getProtocolLabel().setText(radioRange.getProtocol().toString());
            this.updateTextFormatter();
        } else {
            this.getProtocolLabel().setText("Unrecognized Protocol");
            this.getMinRadioIdField().setText(null);
            this.getMaxRadioIdField().setText(null);
        }
        this.modifiedProperty().set(false);
    }

    private void updateTextFormatter() {
        IntegerFormat format;
        if (this.mMinIntegerTextFormatter != null) {
            this.mMinIntegerTextFormatter.valueProperty().removeListener((ChangeListener)this.mMinRadioValueChangeListener);
        }
        if (this.mMaxIntegerTextFormatter != null) {
            this.mMaxIntegerTextFormatter.valueProperty().removeListener((ChangeListener)this.mMaxRadioValueChangeListener);
        }
        if ((format = this.mUserPreferences.getTalkgroupFormatPreference().getTalkgroupFormat(((RadioRange)this.getItem()).getProtocol())) != null) {
            RadioIdDetail radioIdDetail = this.getRadioDetail(((RadioRange)this.getItem()).getProtocol(), format);
            if (radioIdDetail != null) {
                this.mMinIntegerTextFormatter = radioIdDetail.getMinTextFormatter();
                Integer minValue = this.getItem() != null ? Integer.valueOf(((RadioRange)this.getItem()).getMinRadio()) : null;
                this.mMinRadioIdField.setTextFormatter(this.mMinIntegerTextFormatter);
                this.mMinRadioIdField.setTooltip(new Tooltip(radioIdDetail.getTooltip()));
                this.mMinIntegerTextFormatter.setValue((Object)minValue);
                this.mMinIntegerTextFormatter.valueProperty().addListener((ChangeListener)this.mMinRadioValueChangeListener);
                this.mMaxIntegerTextFormatter = radioIdDetail.getMaxTextFormatter();
                Integer maxValue = this.getItem() != null ? Integer.valueOf(((RadioRange)this.getItem()).getMaxRadio()) : null;
                this.mMaxRadioIdField.setTextFormatter(this.mMaxIntegerTextFormatter);
                this.mMaxRadioIdField.setTooltip(new Tooltip(radioIdDetail.getTooltip()));
                this.mMaxIntegerTextFormatter.setValue((Object)maxValue);
                this.mMaxIntegerTextFormatter.valueProperty().addListener((ChangeListener)this.mMaxRadioValueChangeListener);
                this.getFormatLabel().setText(radioIdDetail.getTooltip());
            } else {
                mLog.warn("Couldn't find radio ID detail for protocol [" + String.valueOf((Object)((RadioRange)this.getItem()).getProtocol()) + "] and format [" + String.valueOf((Object)format) + "]");
                this.getFormatLabel().setText(" ");
            }
        } else {
            this.getFormatLabel().setText(" ");
            this.mMinIntegerTextFormatter.setValue(null);
            this.mMaxIntegerTextFormatter.setValue(null);
        }
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    private Label getFormatLabel() {
        if (this.mFormatLabel == null) {
            this.mFormatLabel = new Label(" ");
        }
        return this.mFormatLabel;
    }

    private Label getProtocolLabel() {
        if (this.mProtocolLabel == null) {
            this.mProtocolLabel = new Label();
        }
        return this.mProtocolLabel;
    }

    private TextField getMinRadioIdField() {
        if (this.mMinRadioIdField == null) {
            this.mMinRadioIdField = new TextField();
            this.mMinRadioIdField.setTextFormatter(this.mMinIntegerTextFormatter);
        }
        return this.mMinRadioIdField;
    }

    private TextField getMaxRadioIdField() {
        if (this.mMaxRadioIdField == null) {
            this.mMaxRadioIdField = new TextField();
            this.mMaxRadioIdField.setTextFormatter(this.mMinIntegerTextFormatter);
        }
        return this.mMaxRadioIdField;
    }

    private RadioIdDetail getRadioDetail(Protocol protocol, IntegerFormat integerFormat) {
        for (RadioIdDetail detail : this.mRadioDetails) {
            if (detail.getProtocol() != protocol || detail.getIntegerFormat() != integerFormat) continue;
            return detail;
        }
        mLog.warn("Unable to find radio id range editor for protocol [" + String.valueOf((Object)protocol) + "] and format [" + String.valueOf((Object)integerFormat) + "] - using default editor");
        for (RadioIdDetail detail : this.mRadioDetails) {
            if (detail.getProtocol() != Protocol.UNKNOWN || detail.getIntegerFormat() != integerFormat) continue;
            return detail;
        }
        mLog.warn("No Radio ID Detail is configured for protocol [" + String.valueOf((Object)protocol) + "] and format [" + String.valueOf((Object)integerFormat) + "]");
        return null;
    }

    private List<RadioIdDetail> createRadioDetails() {
        ArrayList<RadioIdDetail> details = new ArrayList<RadioIdDetail>();
        details.add(new RadioIdDetail(this, Protocol.APCO25, IntegerFormat.DECIMAL, new IntegerFormatter(0, 0xFFFFFF), new IntegerFormatter(0, 0xFFFFFF), "Format: 0 - 16777215"));
        details.add(new RadioIdDetail(this, Protocol.APCO25, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 0xFFFFFF), new HexFormatter(0, 0xFFFFFF), "Format: 0 - FFFFFF"));
        details.add(new RadioIdDetail(this, Protocol.PASSPORT, IntegerFormat.DECIMAL, new IntegerFormatter(0, 0x7FFFFF), new IntegerFormatter(0, 0x7FFFFF), "Format: 0 - 8388607"));
        details.add(new RadioIdDetail(this, Protocol.PASSPORT, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 0x7FFFFF), new HexFormatter(0, 0x7FFFFF), "Format: 0 - 7FFFFF"));
        details.add(new RadioIdDetail(this, Protocol.UNKNOWN, IntegerFormat.DECIMAL, new IntegerFormatter(0, 0xFFFFFF), new IntegerFormatter(0, 0xFFFFFF), "Format: 0 - FFFFFF"));
        details.add(new RadioIdDetail(this, Protocol.UNKNOWN, IntegerFormat.FORMATTED, new IntegerFormatter(0, 0xFFFFFF), new IntegerFormatter(0, 0xFFFFFF), "Format: 0 - FFFFFF"));
        details.add(new RadioIdDetail(this, Protocol.UNKNOWN, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 0xFFFFFF), new HexFormatter(0, 0xFFFFFF), "Format: 0 - FFFFFF"));
        details.add(new RadioIdDetail(this, Protocol.DMR, IntegerFormat.DECIMAL, new IntegerFormatter(0, 0xFFFFFF), new IntegerFormatter(0, 0xFFFFFF), "Format: 0 - 16777215"));
        details.add(new RadioIdDetail(this, Protocol.DMR, IntegerFormat.HEXADECIMAL, new HexFormatter(0, 0xFFFFFF), new HexFormatter(0, 0xFFFFFF), "Format: 0 - FFFFFF"));
        return details;
    }

    public class MinRadioValueChangeListener
    implements ChangeListener<Integer> {
        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            if (RadioIdRangeEditor.this.getItem() != null) {
                ((RadioRange)RadioIdRangeEditor.this.getItem()).setMinRadio(newValue != null ? newValue : 0);
                RadioIdRangeEditor.this.modifiedProperty().set(true);
            }
        }
    }

    public class MaxRadioValueChangeListener
    implements ChangeListener<Integer> {
        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            if (RadioIdRangeEditor.this.getItem() != null) {
                ((RadioRange)RadioIdRangeEditor.this.getItem()).setMaxRadio(newValue != null ? newValue : 0);
                RadioIdRangeEditor.this.modifiedProperty().set(true);
            }
        }
    }

    public class RadioIdDetail {
        private Protocol mProtocol;
        private IntegerFormat mIntegerFormat;
        private TextFormatter<Integer> mMinTextFormatter;
        private TextFormatter<Integer> mMaxTextFormatter;
        private String mTooltip;

        public RadioIdDetail(RadioIdRangeEditor this$0, Protocol protocol, IntegerFormat integerFormat, TextFormatter<Integer> minTextFormatter, TextFormatter<Integer> maxTextFormatter, String tooltip) {
            this.mProtocol = protocol;
            this.mIntegerFormat = integerFormat;
            this.mMinTextFormatter = minTextFormatter;
            this.mMaxTextFormatter = maxTextFormatter;
            this.mTooltip = tooltip;
        }

        public Protocol getProtocol() {
            return this.mProtocol;
        }

        public IntegerFormat getIntegerFormat() {
            return this.mIntegerFormat;
        }

        public TextFormatter<Integer> getMinTextFormatter() {
            return this.mMinTextFormatter;
        }

        public TextFormatter<Integer> getMaxTextFormatter() {
            return this.mMaxTextFormatter;
        }

        public String getTooltip() {
            return this.mTooltip;
        }
    }
}

