/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias.identifier;

import io.github.dsheirer.alias.id.radio.P25FullyQualifiedRadio;
import io.github.dsheirer.gui.control.HexFormatter;
import io.github.dsheirer.gui.control.IntegerFormatter;
import io.github.dsheirer.gui.playlist.alias.identifier.IdentifierEditor;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25FullyQualifiedRadioIdEditor
extends IdentifierEditor<P25FullyQualifiedRadio> {
    private static final Logger mLog = LoggerFactory.getLogger(P25FullyQualifiedRadioIdEditor.class);
    private UserPreferences mUserPreferences;
    private Label mProtocolLabel;
    private TextField mWacnField;
    private TextField mSystemField;
    private TextField mRadioField;
    private TextFormatter<Integer> mWacnTextFormatter;
    private TextFormatter<Integer> mSystemTextFormatter;
    private TextFormatter<Integer> mRadioTextFormatter;
    private WacnValueChangeListener mWacnValueChangeListener = new WacnValueChangeListener();
    private SystemValueChangeListener mSystemValueChangeListener = new SystemValueChangeListener();
    private RadioValueChangeListener mRadioValueChangeListener = new RadioValueChangeListener();

    public P25FullyQualifiedRadioIdEditor(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(3.0);
        GridPane.setConstraints((Node)this.getProtocolLabel(), (int)0, (int)0);
        gridPane.getChildren().add((Object)this.getProtocolLabel());
        Label valueLabel = new Label("WACN");
        GridPane.setHalignment((Node)valueLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)valueLabel, (int)1, (int)0);
        gridPane.getChildren().add((Object)valueLabel);
        GridPane.setConstraints((Node)this.getWacnField(), (int)2, (int)0);
        gridPane.getChildren().add((Object)this.getWacnField());
        Label systemLabel = new Label("System");
        GridPane.setHalignment((Node)systemLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)systemLabel, (int)3, (int)0);
        gridPane.getChildren().add((Object)systemLabel);
        GridPane.setConstraints((Node)this.getSystemField(), (int)4, (int)0);
        gridPane.getChildren().add((Object)this.getSystemField());
        Label radioLabel = new Label("Radio ID");
        GridPane.setHalignment((Node)radioLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)radioLabel, (int)5, (int)0);
        gridPane.getChildren().add((Object)radioLabel);
        GridPane.setConstraints((Node)this.getRadioField(), (int)6, (int)0);
        gridPane.getChildren().add((Object)this.getRadioField());
        this.getChildren().add((Object)gridPane);
    }

    @Override
    public void setItem(P25FullyQualifiedRadio item) {
        super.setItem(item);
        P25FullyQualifiedRadio fqr = (P25FullyQualifiedRadio)this.getItem();
        this.getProtocolLabel().setDisable(fqr == null);
        this.getWacnField().setDisable(fqr == null);
        this.getSystemField().setDisable(fqr == null);
        this.getRadioField().setDisable(fqr == null);
        if (fqr != null) {
            this.getProtocolLabel().setText(fqr.getProtocol().toString());
            this.updateTextFormatter();
        } else {
            this.getWacnField().setText(null);
            this.getSystemField().setText(null);
            this.getRadioField().setText(null);
        }
        this.modifiedProperty().set(false);
    }

    private void updateTextFormatter() {
        IntegerFormat format;
        if (this.mWacnTextFormatter != null) {
            this.mWacnTextFormatter.valueProperty().removeListener((ChangeListener)this.mWacnValueChangeListener);
        }
        if (this.mSystemTextFormatter != null) {
            this.mSystemTextFormatter.valueProperty().removeListener((ChangeListener)this.mSystemValueChangeListener);
        }
        if (this.mRadioTextFormatter != null) {
            this.mRadioTextFormatter.valueProperty().removeListener((ChangeListener)this.mRadioValueChangeListener);
        }
        if (!((format = this.mUserPreferences.getTalkgroupFormatPreference().getTalkgroupFormat(((P25FullyQualifiedRadio)this.getItem()).getProtocol())) != IntegerFormat.DECIMAL || this.mRadioTextFormatter != null && this.mRadioTextFormatter instanceof IntegerFormatter)) {
            this.mWacnTextFormatter = new IntegerFormatter(0, 1048575);
            this.mSystemTextFormatter = new IntegerFormatter(0, 4095);
            this.mRadioTextFormatter = new IntegerFormatter(0, 0xFFFFFF);
            this.mWacnField.setTooltip(new Tooltip("Format: 0 - 1048575"));
            this.mSystemField.setTooltip(new Tooltip("Format: 0 - 4095"));
            this.mRadioField.setTooltip(new Tooltip("Format: 0 - 16777215"));
        } else if (!(format != IntegerFormat.HEXADECIMAL || this.mRadioTextFormatter != null && this.mRadioTextFormatter instanceof HexFormatter)) {
            this.mWacnTextFormatter = new HexFormatter(0, 1048575);
            this.mSystemTextFormatter = new HexFormatter(0, 4095);
            this.mRadioTextFormatter = new HexFormatter(0, 0xFFFFFF);
            this.mWacnField.setTooltip(new Tooltip("Format: 0 - FFFFF"));
            this.mSystemField.setTooltip(new Tooltip("Format: 0 - FFF"));
            this.mRadioField.setTooltip(new Tooltip("Format: 0 - FFFFFF"));
        }
        this.mWacnField.setTextFormatter(this.mWacnTextFormatter);
        this.mSystemField.setTextFormatter(this.mSystemTextFormatter);
        this.mRadioField.setTextFormatter(this.mRadioTextFormatter);
        this.mWacnTextFormatter.setValue(this.getItem() != null ? Integer.valueOf(((P25FullyQualifiedRadio)this.getItem()).getWacn()) : null);
        this.mSystemTextFormatter.setValue(this.getItem() != null ? Integer.valueOf(((P25FullyQualifiedRadio)this.getItem()).getSystem()) : null);
        this.mRadioTextFormatter.setValue(this.getItem() != null ? Integer.valueOf(((P25FullyQualifiedRadio)this.getItem()).getValue()) : null);
        this.mWacnTextFormatter.valueProperty().addListener((ChangeListener)this.mWacnValueChangeListener);
        this.mSystemTextFormatter.valueProperty().addListener((ChangeListener)this.mSystemValueChangeListener);
        this.mRadioTextFormatter.valueProperty().addListener((ChangeListener)this.mRadioValueChangeListener);
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    private Label getProtocolLabel() {
        if (this.mProtocolLabel == null) {
            this.mProtocolLabel = new Label();
        }
        return this.mProtocolLabel;
    }

    private TextField getWacnField() {
        if (this.mWacnField == null) {
            this.mWacnField = new TextField();
            this.mWacnField.setTextFormatter(this.mWacnTextFormatter);
        }
        return this.mWacnField;
    }

    private TextField getSystemField() {
        if (this.mSystemField == null) {
            this.mSystemField = new TextField();
            this.mSystemField.setTextFormatter(this.mSystemTextFormatter);
        }
        return this.mSystemField;
    }

    private TextField getRadioField() {
        if (this.mRadioField == null) {
            this.mRadioField = new TextField();
            this.mRadioField.setTextFormatter(this.mRadioTextFormatter);
        }
        return this.mRadioField;
    }

    public class WacnValueChangeListener
    implements ChangeListener<Integer> {
        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            if (P25FullyQualifiedRadioIdEditor.this.getItem() != null) {
                ((P25FullyQualifiedRadio)P25FullyQualifiedRadioIdEditor.this.getItem()).setWacn(newValue != null ? newValue : 0);
                P25FullyQualifiedRadioIdEditor.this.modifiedProperty().set(true);
            }
        }
    }

    public class SystemValueChangeListener
    implements ChangeListener<Integer> {
        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            if (P25FullyQualifiedRadioIdEditor.this.getItem() != null) {
                ((P25FullyQualifiedRadio)P25FullyQualifiedRadioIdEditor.this.getItem()).setSystem(newValue != null ? newValue : 0);
                P25FullyQualifiedRadioIdEditor.this.modifiedProperty().set(true);
            }
        }
    }

    public class RadioValueChangeListener
    implements ChangeListener<Integer> {
        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            if (P25FullyQualifiedRadioIdEditor.this.getItem() != null) {
                ((P25FullyQualifiedRadio)P25FullyQualifiedRadioIdEditor.this.getItem()).setValue(newValue != null ? newValue : 0);
                P25FullyQualifiedRadioIdEditor.this.modifiedProperty().set(true);
            }
        }
    }
}

