/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias.identifier;

import io.github.dsheirer.alias.id.AliasIDType;
import io.github.dsheirer.gui.playlist.alias.identifier.DcsEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.EsnEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.IdentifierEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.LojackEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.P25FullyQualifiedRadioIdEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.P25FullyQualifiedTalkgroupEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.RadioIdEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.RadioIdRangeEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.TalkgroupEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.TalkgroupRangeEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.TonesEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.UnitStatusEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.UnrecognizedIdentifierEditor;
import io.github.dsheirer.gui.playlist.alias.identifier.UserStatusEditor;
import io.github.dsheirer.preference.UserPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifierEditorFactory {
    private static final Logger mLog = LoggerFactory.getLogger(IdentifierEditorFactory.class);

    public static IdentifierEditor getEditor(AliasIDType type, UserPreferences userPreferences) {
        switch (type) {
            case DCS: {
                return new DcsEditor();
            }
            case ESN: {
                return new EsnEditor();
            }
            case LOJACK: {
                return new LojackEditor();
            }
            case P25_FULLY_QUALIFIED_RADIO_ID: {
                return new P25FullyQualifiedRadioIdEditor(userPreferences);
            }
            case P25_FULLY_QUALIFIED_TALKGROUP: {
                return new P25FullyQualifiedTalkgroupEditor(userPreferences);
            }
            case RADIO_ID: {
                return new RadioIdEditor(userPreferences);
            }
            case RADIO_ID_RANGE: {
                return new RadioIdRangeEditor(userPreferences);
            }
            case TALKGROUP: {
                return new TalkgroupEditor(userPreferences);
            }
            case TALKGROUP_RANGE: {
                return new TalkgroupRangeEditor(userPreferences);
            }
            case STATUS: {
                return new UserStatusEditor();
            }
            case TONES: {
                return new TonesEditor();
            }
            case UNIT_STATUS: {
                return new UnitStatusEditor();
            }
        }
        return new UnrecognizedIdentifierEditor();
    }
}

