/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias.action;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasFactory;
import io.github.dsheirer.alias.action.AliasAction;
import io.github.dsheirer.alias.action.RecurringAction;
import io.github.dsheirer.alias.action.clip.ClipAction;
import io.github.dsheirer.gui.control.IntegerFormatter;
import io.github.dsheirer.gui.playlist.alias.action.ActionEditor;
import io.github.dsheirer.gui.playlist.alias.action.TestMessage;
import io.github.dsheirer.util.ThreadPool;
import java.io.File;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.FileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClipEditor
extends ActionEditor<ClipAction> {
    private static final Logger mLog = LoggerFactory.getLogger(ClipEditor.class);
    private static final String UNTIL_DISMISSED_LABEL = "second intervals (1-60)";
    private static final String DELAY_LABEL = "second delay (1-60)";
    private static final String PLEASE_SELECT_A_FILE = "(please select a file)";
    private ComboBoxChangeListener mComboBoxChangeListener = new ComboBoxChangeListener();
    private PeriodChangeListener mPeriodChangeListener = new PeriodChangeListener();
    private ComboBox<RecurringAction.Interval> mIntervalComboBox;
    private TextField mPeriodTextField;
    private IntegerFormatter mPeriodFormatter;
    private Label mSecondsLabel;
    private Button mFileChooser;
    private Button mTestButton;
    private TextField mFilePath;

    public ClipEditor() {
        GridPane gridPane = new GridPane();
        gridPane.setMaxWidth(Double.MAX_VALUE);
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        int row = 0;
        Label fileLabel = new Label("Audio File");
        GridPane.setHalignment((Node)fileLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)fileLabel, (int)0, (int)row);
        gridPane.getChildren().add((Object)fileLabel);
        GridPane.setConstraints((Node)this.getFilePath(), (int)1, (int)row, (int)3, (int)1);
        GridPane.setHgrow((Node)this.getFilePath(), (Priority)Priority.ALWAYS);
        gridPane.getChildren().add((Object)this.getFilePath());
        GridPane.setConstraints((Node)this.getFileChooser(), (int)4, (int)row);
        gridPane.getChildren().add((Object)this.getFileChooser());
        Label intervalLabel = new Label("Play Audio Clip");
        GridPane.setHalignment((Node)intervalLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)intervalLabel, (int)0, (int)(++row));
        gridPane.getChildren().add((Object)intervalLabel);
        GridPane.setConstraints(this.getIntervalComboBox(), (int)1, (int)row);
        gridPane.getChildren().add(this.getIntervalComboBox());
        GridPane.setConstraints((Node)this.getPeriodTextField(), (int)2, (int)row);
        gridPane.getChildren().add((Object)this.getPeriodTextField());
        GridPane.setHalignment((Node)this.getSecondsLabel(), (HPos)HPos.LEFT);
        GridPane.setConstraints((Node)this.getSecondsLabel(), (int)3, (int)row);
        GridPane.setHgrow((Node)this.getSecondsLabel(), (Priority)Priority.ALWAYS);
        gridPane.getChildren().add((Object)this.getSecondsLabel());
        GridPane.setConstraints((Node)this.getTestButton(), (int)4, (int)row);
        gridPane.getChildren().add((Object)this.getTestButton());
        this.getChildren().add((Object)gridPane);
    }

    @Override
    public void setItem(ClipAction clipAction) {
        super.setItem(clipAction);
        this.mComboBoxChangeListener.disable();
        this.mPeriodChangeListener.disable();
        this.getIntervalComboBox().setDisable(clipAction == null);
        this.getFileChooser().setDisable(clipAction == null);
        if (clipAction != null) {
            RecurringAction.Interval interval = clipAction.getInterval();
            this.getIntervalComboBox().getSelectionModel().select((Object)interval);
            this.getPeriodFormatter().setValue(clipAction.getPeriod());
            if (clipAction.getPath() != null) {
                this.getFilePath().setText(clipAction.getPath());
            } else {
                this.getFilePath().setText(PLEASE_SELECT_A_FILE);
            }
        } else {
            this.getIntervalComboBox().getSelectionModel().select(null);
            this.getPeriodFormatter().setValue(null);
            this.getFilePath().setText(PLEASE_SELECT_A_FILE);
        }
        this.updatePeriodAndLabel();
        this.mComboBoxChangeListener.enable();
        this.mPeriodChangeListener.enable();
    }

    @Override
    public void save() {
    }

    @Override
    public void dispose() {
    }

    private void updatePeriodAndLabel() {
        RecurringAction.Interval selected = (RecurringAction.Interval)((Object)this.getIntervalComboBox().getSelectionModel().getSelectedItem());
        if (selected != null) {
            switch (selected) {
                case ONCE: {
                    this.getPeriodTextField().setVisible(false);
                    this.getSecondsLabel().setVisible(false);
                    break;
                }
                case DELAYED_RESET: {
                    this.getPeriodTextField().setVisible(true);
                    this.getSecondsLabel().setVisible(true);
                    this.getSecondsLabel().setText(DELAY_LABEL);
                    break;
                }
                case UNTIL_DISMISSED: {
                    this.getPeriodTextField().setVisible(true);
                    this.getSecondsLabel().setVisible(true);
                    this.getSecondsLabel().setText(UNTIL_DISMISSED_LABEL);
                }
            }
        } else {
            this.getPeriodTextField().setVisible(false);
            this.getSecondsLabel().setVisible(false);
        }
    }

    private void test() {
        if (this.getItem() != null) {
            final AliasAction clipAction = AliasFactory.copyOf((AliasAction)this.getItem());
            final TestMessage testMessage = new TestMessage();
            final Alias testAlias = new Alias("Test Alias");
            ThreadPool.CACHED.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        clipAction.execute(testAlias, testMessage);
                    }
                    catch (Exception e) {
                        mLog.error("Error testing clip action", (Throwable)e);
                    }
                }
            });
        }
    }

    private Button getTestButton() {
        if (this.mTestButton == null) {
            this.mTestButton = new Button("Test");
            this.mTestButton.setMaxWidth(Double.MAX_VALUE);
            this.mTestButton.setDisable(true);
            this.mTestButton.setOnAction(event -> this.test());
        }
        return this.mTestButton;
    }

    private Button getFileChooser() {
        if (this.mFileChooser == null) {
            this.mFileChooser = new Button("Select ...");
            this.mFileChooser.setMaxWidth(Double.MAX_VALUE);
            this.mFileChooser.setDisable(true);
            this.mFileChooser.setOnAction(event -> {
                File audioFile;
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Select Audio File");
                String selected = this.mFilePath.getText();
                if (selected != null && !selected.isEmpty() && !selected.contentEquals(PLEASE_SELECT_A_FILE)) {
                    try {
                        File testFile = new File(selected);
                        if (testFile.exists()) {
                            fileChooser.setInitialDirectory(testFile.getParentFile());
                            fileChooser.setInitialFileName(testFile.getName());
                        }
                    }
                    catch (Exception e) {
                        mLog.error("Error trying to set default directory for file chooser", (Throwable)e);
                    }
                }
                if ((audioFile = fileChooser.showOpenDialog(null)) != null) {
                    this.getFilePath().setText(audioFile.getAbsolutePath());
                }
            });
        }
        return this.mFileChooser;
    }

    private TextField getFilePath() {
        if (this.mFilePath == null) {
            this.mFilePath = new TextField(PLEASE_SELECT_A_FILE);
            this.mFilePath.setDisable(true);
            this.mFilePath.setMaxWidth(Double.MAX_VALUE);
            this.mFilePath.textProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue != null && !newValue.isEmpty() && !newValue.contentEquals(PLEASE_SELECT_A_FILE)) {
                    ((ClipAction)this.getItem()).setPath((String)newValue);
                    this.getTestButton().setDisable(false);
                } else {
                    ((ClipAction)this.getItem()).setPath(null);
                    this.getTestButton().setDisable(true);
                }
                this.modifiedProperty().set(true);
            });
        }
        return this.mFilePath;
    }

    private Label getSecondsLabel() {
        if (this.mSecondsLabel == null) {
            this.mSecondsLabel = new Label("second delay (1 - 60)");
            this.mSecondsLabel.setMaxWidth(Double.MAX_VALUE);
            this.mSecondsLabel.setVisible(false);
            this.mSecondsLabel.setAlignment(Pos.CENTER_LEFT);
        }
        return this.mSecondsLabel;
    }

    private ComboBox<RecurringAction.Interval> getIntervalComboBox() {
        if (this.mIntervalComboBox == null) {
            this.mIntervalComboBox = new ComboBox();
            this.mIntervalComboBox.setDisable(true);
            this.mIntervalComboBox.getItems().setAll((Object[])RecurringAction.Interval.values());
            this.mIntervalComboBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)this.mComboBoxChangeListener);
        }
        return this.mIntervalComboBox;
    }

    private TextField getPeriodTextField() {
        if (this.mPeriodTextField == null) {
            this.mPeriodTextField = new TextField();
            this.mPeriodTextField.setPrefWidth(40.0);
            this.mPeriodTextField.setVisible(false);
            this.mPeriodTextField.setTextFormatter((TextFormatter)this.getPeriodFormatter());
        }
        return this.mPeriodTextField;
    }

    private IntegerFormatter getPeriodFormatter() {
        if (this.mPeriodFormatter == null) {
            this.mPeriodFormatter = new IntegerFormatter(1, 60);
            this.mPeriodFormatter.valueProperty().addListener((ChangeListener)this.mPeriodChangeListener);
        }
        return this.mPeriodFormatter;
    }

    private class ComboBoxChangeListener
    implements ChangeListener<RecurringAction.Interval> {
        private boolean mEnabled = false;

        private ComboBoxChangeListener() {
        }

        public void changed(ObservableValue<? extends RecurringAction.Interval> observable, RecurringAction.Interval oldValue, RecurringAction.Interval newValue) {
            if (this.mEnabled) {
                RecurringAction.Interval selected = (RecurringAction.Interval)((Object)ClipEditor.this.getIntervalComboBox().getSelectionModel().getSelectedItem());
                if (selected != null && ClipEditor.this.getItem() != null) {
                    ((ClipAction)ClipEditor.this.getItem()).setInterval(selected);
                    ClipEditor.this.modifiedProperty().set(true);
                }
                ClipEditor.this.updatePeriodAndLabel();
            }
        }

        public void enable() {
            this.mEnabled = true;
        }

        public void disable() {
            this.mEnabled = false;
        }
    }

    private class PeriodChangeListener
    implements ChangeListener<Integer> {
        private boolean mEnabled = false;

        private PeriodChangeListener() {
        }

        public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
            if (this.mEnabled) {
                if (newValue != null) {
                    ((ClipAction)ClipEditor.this.getItem()).setPeriod(newValue);
                } else {
                    ((ClipAction)ClipEditor.this.getItem()).setPeriod(1);
                }
                ClipEditor.this.modifiedProperty().set(true);
            }
        }

        public void enable() {
            this.mEnabled = true;
        }

        public void disable() {
            this.mEnabled = false;
        }
    }
}

