/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.playlist.PlaylistManager;
import java.util.ArrayList;
import java.util.function.Predicate;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import org.controlsfx.control.textfield.TextFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasViewByRecordingEditor
extends VBox {
    private static final Logger mLog = LoggerFactory.getLogger(AliasViewByRecordingEditor.class);
    private PlaylistManager mPlaylistManager;
    private ComboBox<String> mAliasListNameComboBox;
    private HBox mTopBox;
    private TextField mSearchField;
    private TableView<Alias> mNoRecordAliasTableView;
    private TableView<Alias> mRecordAliasTableView;
    private Button mAddButton;
    private Button mAddAllButton;
    private Button mRemoveButton;
    private Button mRemoveAllButton;
    private FilteredList<Alias> mNoRecordFilteredList;
    private FilteredList<Alias> mRecordFilteredList;
    private AvailablePredicate mNoRecordPredicate;
    private SelectedPredicate mRecordPredicate;

    public AliasViewByRecordingEditor(PlaylistManager playlistManager) {
        this.mPlaylistManager = playlistManager;
        VBox buttonBox = new VBox();
        buttonBox.setMaxHeight(Double.MAX_VALUE);
        buttonBox.setAlignment(Pos.CENTER);
        buttonBox.setSpacing(5.0);
        buttonBox.getChildren().addAll((Object[])new Node[]{this.getAddAllButton(), this.getAddButton(), this.getRemoveButton(), this.getRemoveAllButton()});
        VBox availableBox = new VBox();
        availableBox.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow(this.getNoRecordAliasTableView(), (Priority)Priority.ALWAYS);
        availableBox.getChildren().addAll((Object[])new Node[]{new Label("Don't Record Audio"), this.getNoRecordAliasTableView()});
        VBox selectedBox = new VBox();
        selectedBox.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow(this.getRecordAliasTableView(), (Priority)Priority.ALWAYS);
        selectedBox.getChildren().addAll((Object[])new Node[]{new Label("Record Audio"), this.getRecordAliasTableView()});
        HBox listsBox = new HBox();
        listsBox.setMaxHeight(Double.MAX_VALUE);
        listsBox.setPadding(new Insets(0.0, 10.0, 10.0, 10.0));
        listsBox.setSpacing(10.0);
        HBox.setHgrow((Node)availableBox, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)selectedBox, (Priority)Priority.ALWAYS);
        listsBox.getChildren().addAll((Object[])new Node[]{availableBox, buttonBox, selectedBox});
        VBox.setVgrow((Node)listsBox, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.getTopBox(), listsBox});
    }

    private ComboBox<String> getAliasListNameComboBox() {
        if (this.mAliasListNameComboBox == null) {
            Predicate<String> filterPredicate = s -> !s.contentEquals("(No Alias List)");
            FilteredList filteredChannelList = new FilteredList(this.mPlaylistManager.getAliasModel().aliasListNames(), filterPredicate);
            this.mAliasListNameComboBox = new ComboBox((ObservableList)filteredChannelList);
            this.mAliasListNameComboBox.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
            this.mAliasListNameComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.updateListFilters());
            if (this.mAliasListNameComboBox.getItems().size() > 0) {
                this.mAliasListNameComboBox.getSelectionModel().select(0);
            }
        }
        return this.mAliasListNameComboBox;
    }

    private FilteredList<Alias> getNoRecordFilteredList() {
        if (this.mNoRecordFilteredList == null) {
            this.mNoRecordFilteredList = new FilteredList(this.mPlaylistManager.getAliasModel().aliasList(), (Predicate)this.getNoRecordPredicate());
        }
        return this.mNoRecordFilteredList;
    }

    private FilteredList<Alias> getRecordFilteredList() {
        if (this.mRecordFilteredList == null) {
            this.mRecordFilteredList = new FilteredList(this.mPlaylistManager.getAliasModel().aliasList(), (Predicate)this.getRecordPredicate());
        }
        return this.mRecordFilteredList;
    }

    private HBox getTopBox() {
        if (this.mTopBox == null) {
            this.mTopBox = new HBox();
            this.mTopBox.setAlignment(Pos.CENTER_LEFT);
            this.mTopBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            this.mTopBox.setSpacing(15.0);
            HBox aliasListBox = new HBox();
            aliasListBox.setAlignment(Pos.CENTER);
            aliasListBox.setSpacing(5.0);
            Label aliasListLabel = new Label("Alias List");
            aliasListBox.getChildren().addAll((Object[])new Node[]{aliasListLabel, this.getAliasListNameComboBox()});
            HBox searchBox = new HBox();
            searchBox.setAlignment(Pos.CENTER);
            searchBox.setSpacing(5.0);
            Label searchLabel = new Label("Search");
            searchBox.getChildren().addAll((Object[])new Node[]{searchLabel, this.getSearchField()});
            this.mTopBox.getChildren().addAll((Object[])new Node[]{aliasListBox, searchBox});
        }
        return this.mTopBox;
    }

    private TextField getSearchField() {
        if (this.mSearchField == null) {
            this.mSearchField = TextFields.createClearableTextField();
            this.mSearchField.textProperty().addListener((observable, oldValue, newValue) -> this.updateListFilters());
        }
        return this.mSearchField;
    }

    private void updateListFilters() {
        String aliasList = (String)this.getAliasListNameComboBox().getSelectionModel().getSelectedItem();
        String filterText = this.getSearchField().getText();
        this.mNoRecordPredicate.setAliasListName(aliasList);
        this.mNoRecordPredicate.setFilterText(filterText);
        this.getNoRecordFilteredList().setPredicate(null);
        this.getNoRecordFilteredList().setPredicate((Predicate)this.mNoRecordPredicate);
        this.mRecordPredicate.setAliasListName(aliasList);
        this.mRecordPredicate.setFilterText(filterText);
        this.getRecordFilteredList().setPredicate(null);
        this.getRecordFilteredList().setPredicate((Predicate)this.mRecordPredicate);
    }

    private AvailablePredicate getNoRecordPredicate() {
        if (this.mNoRecordPredicate == null) {
            this.mNoRecordPredicate = new AvailablePredicate();
        }
        return this.mNoRecordPredicate;
    }

    private SelectedPredicate getRecordPredicate() {
        if (this.mRecordPredicate == null) {
            this.mRecordPredicate = new SelectedPredicate();
        }
        return this.mRecordPredicate;
    }

    private TableView<Alias> getNoRecordAliasTableView() {
        if (this.mNoRecordAliasTableView == null) {
            this.mNoRecordAliasTableView = new TableView();
            this.mNoRecordAliasTableView.setMaxHeight(Double.MAX_VALUE);
            this.mNoRecordAliasTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            TableColumn nameColumn = new TableColumn();
            nameColumn.setText("Alias");
            nameColumn.setPrefWidth(200.0);
            nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
            TableColumn groupColumn = new TableColumn();
            groupColumn.setText("Group");
            groupColumn.setPrefWidth(200.0);
            groupColumn.setCellValueFactory((Callback)new PropertyValueFactory("group"));
            this.mNoRecordAliasTableView.getColumns().addAll((Object[])new TableColumn[]{nameColumn, groupColumn});
            this.mNoRecordAliasTableView.setPlaceholder((Node)new Label("No non-recordable aliases available"));
            this.mNoRecordAliasTableView.getSelectionModel().getSelectedItems().addListener(c -> {
                int selectedCount = this.mNoRecordAliasTableView.getSelectionModel().getSelectedItems().size();
                this.getAddButton().setDisable(selectedCount != 1);
                this.getAddAllButton().setDisable(selectedCount < 2);
                if (selectedCount > 0) {
                    this.getRecordAliasTableView().getSelectionModel().clearSelection();
                }
            });
            SortedList sortedList = new SortedList(this.getNoRecordFilteredList());
            sortedList.comparatorProperty().bind((ObservableValue)this.mNoRecordAliasTableView.comparatorProperty());
            this.mNoRecordAliasTableView.setItems((ObservableList)sortedList);
        }
        return this.mNoRecordAliasTableView;
    }

    private TableView<Alias> getRecordAliasTableView() {
        if (this.mRecordAliasTableView == null) {
            this.mRecordAliasTableView = new TableView();
            this.mRecordAliasTableView.setMaxHeight(Double.MAX_VALUE);
            this.mRecordAliasTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            TableColumn nameColumn = new TableColumn();
            nameColumn.setText("Alias");
            nameColumn.setPrefWidth(200.0);
            nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
            TableColumn groupColumn = new TableColumn();
            groupColumn.setText("Group");
            groupColumn.setPrefWidth(200.0);
            groupColumn.setCellValueFactory((Callback)new PropertyValueFactory("group"));
            this.mRecordAliasTableView.getColumns().addAll((Object[])new TableColumn[]{nameColumn, groupColumn});
            this.mRecordAliasTableView.setPlaceholder((Node)new Label("No recordable aliases available"));
            this.mRecordAliasTableView.getSelectionModel().getSelectedItems().addListener(c -> {
                int selectedCount = this.mRecordAliasTableView.getSelectionModel().getSelectedItems().size();
                this.getRemoveButton().setDisable(selectedCount != 1);
                this.getRemoveAllButton().setDisable(selectedCount < 2);
                if (selectedCount > 0) {
                    this.getNoRecordAliasTableView().getSelectionModel().clearSelection();
                }
            });
            SortedList sortedList = new SortedList(this.getRecordFilteredList());
            sortedList.comparatorProperty().bind((ObservableValue)this.mRecordAliasTableView.comparatorProperty());
            this.mRecordAliasTableView.setItems((ObservableList)sortedList);
        }
        return this.mRecordAliasTableView;
    }

    private Button getAddButton() {
        if (this.mAddButton == null) {
            this.mAddButton = new Button();
            this.mAddButton.setDisable(true);
            this.mAddButton.setMaxWidth(Double.MAX_VALUE);
            this.mAddButton.setGraphic((Node)new IconNode((IconCode)FontAwesome.ANGLE_RIGHT));
            this.mAddButton.setAlignment(Pos.CENTER);
            this.mAddButton.setOnAction(event -> {
                Alias selectedAlias = (Alias)this.getNoRecordAliasTableView().getSelectionModel().getSelectedItem();
                if (selectedAlias != null) {
                    selectedAlias.setRecordable(true);
                    this.updateListFilters();
                }
            });
        }
        return this.mAddButton;
    }

    private Button getAddAllButton() {
        if (this.mAddAllButton == null) {
            this.mAddAllButton = new Button();
            this.mAddAllButton.setDisable(true);
            this.mAddAllButton.setMaxWidth(Double.MAX_VALUE);
            this.mAddAllButton.setGraphic((Node)new IconNode((IconCode)FontAwesome.ANGLE_DOUBLE_RIGHT));
            this.mAddAllButton.setAlignment(Pos.CENTER);
            this.mAddAllButton.setOnAction(event -> {
                ArrayList selectedAliases = new ArrayList(this.getNoRecordAliasTableView().getSelectionModel().getSelectedItems());
                if (!selectedAliases.isEmpty()) {
                    for (Alias selectedAlias : selectedAliases) {
                        selectedAlias.setRecordable(true);
                    }
                    this.updateListFilters();
                }
            });
        }
        return this.mAddAllButton;
    }

    private Button getRemoveButton() {
        if (this.mRemoveButton == null) {
            this.mRemoveButton = new Button();
            this.mRemoveButton.setDisable(true);
            this.mRemoveButton.setMaxWidth(Double.MAX_VALUE);
            this.mRemoveButton.setGraphic((Node)new IconNode((IconCode)FontAwesome.ANGLE_LEFT));
            this.mRemoveButton.setAlignment(Pos.CENTER);
            this.mRemoveButton.setOnAction(event -> {
                Alias selectedAlias = (Alias)this.getRecordAliasTableView().getSelectionModel().getSelectedItem();
                if (selectedAlias != null) {
                    selectedAlias.setRecordable(false);
                    this.updateListFilters();
                }
            });
        }
        return this.mRemoveButton;
    }

    private Button getRemoveAllButton() {
        if (this.mRemoveAllButton == null) {
            this.mRemoveAllButton = new Button();
            this.mRemoveAllButton.setDisable(true);
            this.mRemoveAllButton.setMaxWidth(Double.MAX_VALUE);
            this.mRemoveAllButton.setGraphic((Node)new IconNode((IconCode)FontAwesome.ANGLE_DOUBLE_LEFT));
            this.mRemoveAllButton.setAlignment(Pos.CENTER);
            this.mRemoveAllButton.setOnAction(event -> {
                ArrayList selectedAliases = new ArrayList(this.getRecordAliasTableView().getSelectionModel().getSelectedItems());
                if (!selectedAliases.isEmpty()) {
                    for (Alias selectedAlias : selectedAliases) {
                        selectedAlias.setRecordable(false);
                    }
                    this.updateListFilters();
                }
            });
        }
        return this.mRemoveAllButton;
    }

    public static class AvailablePredicate
    implements Predicate<Alias> {
        private String mAliasListName;
        private String mFilterText;

        public void setAliasListName(String aliasListName) {
            this.mAliasListName = aliasListName;
        }

        public void setFilterText(String filterText) {
            this.mFilterText = filterText == null || filterText.isEmpty() ? null : filterText.toLowerCase();
        }

        @Override
        public boolean test(Alias alias) {
            if (this.mAliasListName == null || alias.isRecordable() || alias.getAliasListName() == null) {
                return false;
            }
            if (this.mAliasListName.contentEquals(alias.getAliasListName())) {
                if (this.mFilterText == null) {
                    return true;
                }
                if (alias.getGroup() != null && alias.getGroup().toLowerCase().contains(this.mFilterText)) {
                    return true;
                }
                if (alias.getName() != null && alias.getName().toLowerCase().contains(this.mFilterText)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class SelectedPredicate
    implements Predicate<Alias> {
        private String mAliasListName;
        private String mFilterText;

        public void setAliasListName(String aliasListName) {
            this.mAliasListName = aliasListName;
        }

        public void setFilterText(String filterText) {
            this.mFilterText = filterText == null || filterText.isEmpty() ? null : filterText.toLowerCase();
        }

        @Override
        public boolean test(Alias alias) {
            if (this.mAliasListName == null || !alias.isRecordable() || alias.getAliasListName() == null) {
                return false;
            }
            if (this.mAliasListName.contentEquals(alias.getAliasListName())) {
                if (this.mFilterText == null) {
                    return true;
                }
                if (alias.getGroup() != null && alias.getGroup().toLowerCase().contains(this.mFilterText)) {
                    return true;
                }
                if (alias.getName() != null && alias.getName().toLowerCase().contains(this.mFilterText)) {
                    return true;
                }
            }
            return false;
        }
    }
}

