/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.id.AliasID;
import io.github.dsheirer.alias.id.AliasIDType;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.playlist.alias.ViewAliasRequest;
import io.github.dsheirer.playlist.PlaylistManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasViewByIdentifierEditor
extends VBox {
    private static final Logger mLog = LoggerFactory.getLogger(AliasViewByIdentifierEditor.class);
    private PlaylistManager mPlaylistManager;
    private ComboBox<String> mAliasListNameComboBox;
    private ComboBox<AliasIDType> mAliasIDTypeComboBox;
    private TableView<AliasAndIdentifier> mAliasAndIdentifierTableView;
    private TableColumn<AliasAndIdentifier, String> mIdentifierColumn;
    private Button mViewAliasButton;
    private boolean aliasListInvalidated = false;

    public AliasViewByIdentifierEditor(PlaylistManager playlistManager, ReadOnlyBooleanProperty tabSelectedProperty) {
        this.mPlaylistManager = playlistManager;
        this.mPlaylistManager.getAliasModel().aliasList().addListener(observable -> {
            this.aliasListInvalidated = true;
        });
        tabSelectedProperty.addListener(observable -> {
            if (this.aliasListInvalidated) {
                this.updateList();
            }
        });
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        gridPane.setVgap(10.0);
        gridPane.setHgap(10.0);
        Label aliasListLabel = new Label("Alias List");
        GridPane.setHalignment((Node)aliasListLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)aliasListLabel, (int)0, (int)0);
        gridPane.getChildren().add((Object)aliasListLabel);
        GridPane.setConstraints(this.getAliasListNameComboBox(), (int)1, (int)0);
        GridPane.setHgrow(this.getAliasListNameComboBox(), (Priority)Priority.ALWAYS);
        gridPane.getChildren().add(this.getAliasListNameComboBox());
        Label identifierLabel = new Label("Identifier Type");
        GridPane.setHalignment((Node)identifierLabel, (HPos)HPos.RIGHT);
        GridPane.setConstraints((Node)identifierLabel, (int)0, (int)1);
        gridPane.getChildren().add((Object)identifierLabel);
        GridPane.setConstraints(this.getAliasIDTypeComboBox(), (int)1, (int)1);
        GridPane.setHgrow(this.getAliasIDTypeComboBox(), (Priority)Priority.ALWAYS);
        gridPane.getChildren().add(this.getAliasIDTypeComboBox());
        HBox tableAndButtonBox = new HBox();
        tableAndButtonBox.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        tableAndButtonBox.setSpacing(10.0);
        HBox.setHgrow(this.getAliasAndIdentifierTableView(), (Priority)Priority.ALWAYS);
        tableAndButtonBox.getChildren().addAll((Object[])new Node[]{this.getAliasAndIdentifierTableView(), this.getViewAliasButton()});
        VBox.setVgrow((Node)tableAndButtonBox, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{gridPane, tableAndButtonBox});
        this.updateList();
    }

    private void updateList() {
        this.getAliasAndIdentifierTableView().getItems().clear();
        String aliasList = (String)this.getAliasListNameComboBox().getSelectionModel().getSelectedItem();
        AliasIDType type = (AliasIDType)((Object)this.getAliasIDTypeComboBox().getSelectionModel().getSelectedItem());
        List<Alias> aliases = this.mPlaylistManager.getAliasModel().getAliases(aliasList, type);
        for (Alias alias : aliases) {
            for (AliasID aliasID : alias.getAliasIdentifiers()) {
                if (aliasID.getType() != type) continue;
                this.getAliasAndIdentifierTableView().getItems().add((Object)new AliasAndIdentifier(alias, aliasID));
            }
        }
        this.getAliasAndIdentifierTableView().getSortOrder().setAll((Object[])new TableColumn[]{this.mIdentifierColumn});
        this.aliasListInvalidated = false;
    }

    public void show(AliasID aliasID) {
        if (aliasID != null) {
            AliasIDType type = aliasID.getType();
            if (this.getAliasIDTypeComboBox().getItems().contains((Object)type)) {
                this.getAliasIDTypeComboBox().getSelectionModel().select((Object)type);
                for (AliasAndIdentifier aliasAndIdentifier : this.getAliasAndIdentifierTableView().getItems()) {
                    if (!aliasAndIdentifier.getAliasIdentifier().matches(aliasID)) continue;
                    this.getAliasAndIdentifierTableView().getSelectionModel().select((Object)aliasAndIdentifier);
                    this.getAliasAndIdentifierTableView().scrollTo((Object)aliasAndIdentifier);
                    return;
                }
            }
            Alert alert = new Alert(Alert.AlertType.INFORMATION, "Can't find matching identifier in list", new ButtonType[]{ButtonType.OK});
            alert.setTitle("No Match Found");
            alert.setContentText("No Match Found");
            alert.initOwner(this.getAliasAndIdentifierTableView().getScene().getWindow());
            alert.showAndWait();
        }
    }

    private Button getViewAliasButton() {
        if (this.mViewAliasButton == null) {
            this.mViewAliasButton = new Button("View Alias");
            this.mViewAliasButton.setDisable(true);
            this.mViewAliasButton.setOnAction(event -> {
                AliasAndIdentifier selected = (AliasAndIdentifier)this.getAliasAndIdentifierTableView().getSelectionModel().getSelectedItem();
                if (selected != null) {
                    MyEventBus.getGlobalEventBus().post((Object)new ViewAliasRequest(selected.getAlias()));
                }
            });
        }
        return this.mViewAliasButton;
    }

    private TableView<AliasAndIdentifier> getAliasAndIdentifierTableView() {
        if (this.mAliasAndIdentifierTableView == null) {
            this.mAliasAndIdentifierTableView = new TableView(FXCollections.observableArrayList(AliasAndIdentifier.extractor()));
            this.mAliasAndIdentifierTableView.setPlaceholder((Node)new Label("No aliases or identifiers available"));
            this.mIdentifierColumn = new TableColumn("Identifier");
            this.mIdentifierColumn.setCellValueFactory((Callback)new PropertyValueFactory("identifier"));
            this.mIdentifierColumn.setPrefWidth(350.0);
            TableColumn aliasColumn = new TableColumn();
            aliasColumn.setText("Alias");
            aliasColumn.setCellValueFactory((Callback)new PropertyValueFactory("alias"));
            aliasColumn.setPrefWidth(200.0);
            TableColumn groupColumn = new TableColumn();
            groupColumn.setText("Group");
            groupColumn.setCellValueFactory((Callback)new PropertyValueFactory("group"));
            groupColumn.setPrefWidth(200.0);
            this.mAliasAndIdentifierTableView.getColumns().addAll((Object[])new TableColumn[]{this.mIdentifierColumn, aliasColumn, groupColumn});
            this.mAliasAndIdentifierTableView.setMaxHeight(Double.MAX_VALUE);
            this.mAliasAndIdentifierTableView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.getViewAliasButton().setDisable(newValue == null));
        }
        return this.mAliasAndIdentifierTableView;
    }

    private ComboBox<String> getAliasListNameComboBox() {
        if (this.mAliasListNameComboBox == null) {
            Predicate<String> filterPredicate = s -> !s.contentEquals("(No Alias List)");
            FilteredList filteredChannelList = new FilteredList(this.mPlaylistManager.getAliasModel().aliasListNames(), filterPredicate);
            this.mAliasListNameComboBox = new ComboBox((ObservableList)filteredChannelList);
            this.mAliasListNameComboBox.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
            if (this.mAliasListNameComboBox.getItems().size() > 0) {
                this.mAliasListNameComboBox.getSelectionModel().select(0);
            }
            this.mAliasListNameComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.updateList());
        }
        return this.mAliasListNameComboBox;
    }

    private ComboBox<AliasIDType> getAliasIDTypeComboBox() {
        if (this.mAliasIDTypeComboBox == null) {
            this.mAliasIDTypeComboBox = new ComboBox();
            ArrayList<AliasIDType> values = new ArrayList<AliasIDType>(AliasIDType.VIEW_BY_VALUES);
            Collections.sort(values, (o1, o2) -> o1.toString().compareTo(o2.toString()));
            this.mAliasIDTypeComboBox.getItems().addAll(values);
            if (this.mAliasIDTypeComboBox.getItems().size() > 0) {
                this.mAliasIDTypeComboBox.getSelectionModel().select((Object)AliasIDType.TALKGROUP);
            }
            this.mAliasIDTypeComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> this.updateList());
        }
        return this.mAliasIDTypeComboBox;
    }

    public static class AliasAndIdentifier {
        private Alias mAlias;
        private AliasID mAliasIdentifier;
        private StringProperty mName = new SimpleStringProperty();
        private StringProperty mGroup = new SimpleStringProperty();
        private StringProperty mIdentifier = new SimpleStringProperty();

        public AliasAndIdentifier(Alias alias, AliasID aliasID) {
            this.mAlias = alias;
            this.mAliasIdentifier = aliasID;
            this.mName.bind((ObservableValue)this.mAlias.nameProperty());
            this.mGroup.bind((ObservableValue)this.mAlias.groupProperty());
            this.mIdentifier.bind((ObservableValue)this.mAliasIdentifier.valueProperty());
        }

        public StringProperty nameProperty() {
            return this.mName;
        }

        public StringProperty groupProperty() {
            return this.mGroup;
        }

        public StringProperty identifierProperty() {
            return this.mIdentifier;
        }

        public Alias getAlias() {
            return this.mAlias;
        }

        public AliasID getAliasIdentifier() {
            return this.mAliasIdentifier;
        }

        /*
         * Exception decompiling
         */
        public static Callback<AliasAndIdentifier, Observable[]> extractor() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

