/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist.alias;

import io.github.dsheirer.alias.Alias;
import io.github.dsheirer.alias.AliasFactory;
import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.gui.control.MaxLengthUnaryOperator;
import io.github.dsheirer.gui.playlist.Editor;
import io.github.dsheirer.gui.playlist.alias.AliasBulkEditor;
import io.github.dsheirer.gui.playlist.alias.AliasItemEditor;
import io.github.dsheirer.gui.playlist.alias.ColorUtil;
import io.github.dsheirer.icon.Icon;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import jiconfont.IconCode;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.javafx.IconNode;
import org.controlsfx.control.textfield.TextFields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasConfigurationEditor
extends SplitPane {
    private static final Logger mLog = LoggerFactory.getLogger(AliasConfigurationEditor.class);
    private PlaylistManager mPlaylistManager;
    private UserPreferences mUserPreferences;
    private AliasItemEditor mAliasItemEditor;
    private AliasBulkEditor mAliasBulkEditor;
    private Editor mCurrentEditor;
    private TableView<Alias> mAliasTableView;
    private Label mPlaceholderLabel;
    private Button mNewAliasButton;
    private Button mDeleteAliasButton;
    private Button mCloneAliasButton;
    private MenuButton mMoveToAliasButton;
    private VBox mButtonBox;
    private HBox mSearchAndListSelectionBox;
    private TextField mSearchField;
    private ComboBox<String> mAliasListNameComboBox;
    private Button mNewAliasListButton;
    private FilteredList<Alias> mAliasFilteredList;
    private SortedList<Alias> mAliasSortedList;
    private AliasPredicate mAliasPredicate;

    public AliasConfigurationEditor(PlaylistManager playlistManager, UserPreferences userPreferences) {
        this.mPlaylistManager = playlistManager;
        this.mUserPreferences = userPreferences;
        VBox leftBox = new VBox();
        VBox.setVgrow(this.getAliasTableView(), (Priority)Priority.ALWAYS);
        leftBox.getChildren().addAll((Object[])new Node[]{this.getSearchAndListSelectionBox(), this.getAliasTableView()});
        HBox topBox = new HBox();
        HBox.setHgrow((Node)leftBox, (Priority)Priority.ALWAYS);
        topBox.getChildren().addAll((Object[])new Node[]{leftBox, this.getButtonBox()});
        this.setOrientation(Orientation.VERTICAL);
        this.mCurrentEditor = this.getAliasItemEditor();
        this.getItems().addAll((Object[])new Node[]{topBox, this.getAliasItemEditor()});
    }

    public void show(Alias alias) {
        if (alias != null) {
            String aliasList = alias.getAliasListName();
            if (aliasList == null || aliasList.isEmpty()) {
                aliasList = "(No Alias List)";
            }
            this.getAliasListNameComboBox().getSelectionModel().select((Object)aliasList);
            this.getAliasTableView().getSelectionModel().clearSelection();
            this.getAliasTableView().getSelectionModel().select((Object)alias);
            this.getAliasTableView().scrollTo((Object)alias);
        }
    }

    private void setEditor(Editor editor) {
        if (editor != this.mCurrentEditor) {
            this.getItems().remove((Object)this.mCurrentEditor);
            this.mCurrentEditor = editor;
            this.getItems().add((Object)this.mCurrentEditor);
        }
    }

    private void setAliases(List<Alias> aliases) {
        if (this.getAliasItemEditor().modifiedProperty().get()) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.getButtonTypes().clear();
            alert.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.NO, ButtonType.YES});
            alert.setTitle("Save Changes");
            alert.setHeaderText("Alias configuration has been modified");
            alert.setContentText("Do you want to save these changes?");
            alert.initOwner(this.getButtonBox().getScene().getWindow());
            alert.setResizable(true);
            alert.onShownProperty().addListener(e -> Platform.runLater(() -> alert.setResizable(false)));
            Optional result = alert.showAndWait();
            if (result.get() == ButtonType.YES) {
                this.getAliasItemEditor().save();
            }
        }
        if (aliases.size() <= 1) {
            this.setEditor(this.getAliasItemEditor());
            if (aliases.size() == 1) {
                this.getAliasItemEditor().setItem(aliases.get(0));
            } else {
                this.getAliasItemEditor().setItem(null);
            }
        } else {
            this.setEditor(this.getAliasBulkEditor());
            this.getAliasBulkEditor().setItem(aliases);
        }
        this.getCloneAliasButton().setDisable(aliases.isEmpty() || aliases.size() > 1);
        this.getDeleteAliasButton().setDisable(aliases.isEmpty());
        this.getMoveToAliasButton().setDisable(aliases.isEmpty());
    }

    private AliasItemEditor getAliasItemEditor() {
        if (this.mAliasItemEditor == null) {
            this.mAliasItemEditor = new AliasItemEditor(this.mPlaylistManager, this.mUserPreferences);
        }
        return this.mAliasItemEditor;
    }

    private AliasBulkEditor getAliasBulkEditor() {
        if (this.mAliasBulkEditor == null) {
            this.mAliasBulkEditor = new AliasBulkEditor(this.mPlaylistManager);
        }
        return this.mAliasBulkEditor;
    }

    private HBox getSearchAndListSelectionBox() {
        if (this.mSearchAndListSelectionBox == null) {
            this.mSearchAndListSelectionBox = new HBox();
            this.mSearchAndListSelectionBox.setAlignment(Pos.CENTER_LEFT);
            this.mSearchAndListSelectionBox.setPadding(new Insets(10.0, 0.0, 10.0, 10.0));
            this.mSearchAndListSelectionBox.setSpacing(5.0);
            Label listLabel = new Label("Alias List");
            Label searchLabel = new Label("Search");
            searchLabel.setAlignment(Pos.CENTER_RIGHT);
            HBox searchBox = new HBox();
            searchBox.setSpacing(5.0);
            searchBox.getChildren().addAll((Object[])new Node[]{searchLabel, this.getSearchField()});
            HBox.setHgrow((Node)searchBox, (Priority)Priority.ALWAYS);
            searchBox.setAlignment(Pos.BASELINE_RIGHT);
            this.mSearchAndListSelectionBox.getChildren().addAll((Object[])new Node[]{listLabel, this.getAliasListNameComboBox(), this.getNewAliasListButton(), searchBox});
        }
        return this.mSearchAndListSelectionBox;
    }

    private TextField getSearchField() {
        if (this.mSearchField == null) {
            this.mSearchField = TextFields.createClearableTextField();
            this.mSearchField.textProperty().addListener((observable, oldValue, newValue) -> this.update());
        }
        return this.mSearchField;
    }

    private void update() {
        this.getAliasFilteredList().setPredicate(null);
        this.getAliasPredicate().setAliasListName((String)this.getAliasListNameComboBox().getSelectionModel().getSelectedItem());
        this.getAliasPredicate().setSearchText(this.getSearchField().getText());
        this.getAliasFilteredList().setPredicate((Predicate)this.getAliasPredicate());
    }

    private AliasPredicate getAliasPredicate() {
        if (this.mAliasPredicate == null) {
            this.mAliasPredicate = new AliasPredicate(this);
            this.mAliasPredicate.setAliasListName((String)this.getAliasListNameComboBox().getSelectionModel().getSelectedItem());
        }
        return this.mAliasPredicate;
    }

    private ComboBox<String> getAliasListNameComboBox() {
        if (this.mAliasListNameComboBox == null) {
            this.mAliasListNameComboBox = new ComboBox(this.mPlaylistManager.getAliasModel().aliasListNames());
            this.mAliasListNameComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
                this.getNewAliasButton().setDisable(newValue == null || newValue.contentEquals("(No Alias List)"));
                this.update();
            });
            if (this.mAliasListNameComboBox.getItems().size() > 1) {
                if (!((String)this.mAliasListNameComboBox.getItems().get(0)).contentEquals("(No Alias List)")) {
                    this.mAliasListNameComboBox.getSelectionModel().select(0);
                } else {
                    this.mAliasListNameComboBox.getSelectionModel().select(1);
                }
            } else if (this.mAliasListNameComboBox.getItems().size() == 1) {
                this.mAliasListNameComboBox.getSelectionModel().select(0);
            }
        }
        return this.mAliasListNameComboBox;
    }

    private Button getNewAliasListButton() {
        if (this.mNewAliasListButton == null) {
            this.mNewAliasListButton = new Button("New Alias List");
            this.mNewAliasListButton.setOnAction(event -> {
                TextInputDialog dialog = new TextInputDialog();
                dialog.setTitle("Create New Alias List");
                dialog.setHeaderText("Please enter an alias list name (max 25 chars).");
                dialog.setContentText("Name:");
                dialog.getEditor().setTextFormatter(new TextFormatter((UnaryOperator)new MaxLengthUnaryOperator(25)));
                Optional result = dialog.showAndWait();
                result.ifPresent(s -> {
                    String name = (String)result.get();
                    if (name != null && !name.isEmpty()) {
                        name = name.trim();
                        this.mPlaylistManager.getAliasModel().addAliasList(name);
                        this.getAliasListNameComboBox().getSelectionModel().select((Object)name);
                    }
                });
            });
        }
        return this.mNewAliasListButton;
    }

    private TableView<Alias> getAliasTableView() {
        if (this.mAliasTableView == null) {
            this.mAliasTableView = new TableView();
            TableColumn nameColumn = new TableColumn();
            nameColumn.setText("Alias");
            nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
            nameColumn.setPrefWidth(140.0);
            TableColumn groupColumn = new TableColumn();
            groupColumn.setText("Group");
            groupColumn.setCellValueFactory((Callback)new PropertyValueFactory("group"));
            groupColumn.setPrefWidth(140.0);
            TableColumn colorColumn = new TableColumn("Color");
            colorColumn.setCellValueFactory((Callback)new PropertyValueFactory("color"));
            colorColumn.setCellFactory((Callback)new ColorizedCell(this));
            TableColumn iconColumn = new TableColumn("Icon");
            iconColumn.setCellValueFactory((Callback)new PropertyValueFactory("iconName"));
            iconColumn.setCellFactory((Callback)new IconTableCellFactory());
            TableColumn priorityColumn = new TableColumn("Listen");
            priorityColumn.setCellFactory((Callback)new PriorityCellFactory(this));
            priorityColumn.setCellValueFactory((Callback)new PropertyValueFactory("priority"));
            TableColumn recordColumn = new TableColumn("Record");
            recordColumn.setCellValueFactory((Callback)new PropertyValueFactory("recordable"));
            recordColumn.setCellFactory((Callback)new IconCell(this, (IconCode)FontAwesome.SQUARE, Color.RED));
            TableColumn streamColumn = new TableColumn("Stream");
            streamColumn.setCellValueFactory((Callback)new PropertyValueFactory("streamable"));
            streamColumn.setCellFactory((Callback)new IconCell(this, (IconCode)FontAwesome.VOLUME_UP, Color.DARKBLUE));
            TableColumn idsColumn = new TableColumn("IDs");
            idsColumn.setCellValueFactory((Callback)new IdentifierCountCell(this));
            TableColumn errorsColumn = new TableColumn("Error");
            errorsColumn.setPrefWidth(120.0);
            errorsColumn.setCellValueFactory((Callback)new PropertyValueFactory("overlap"));
            errorsColumn.setCellFactory(param -> {
                TableCell<Alias, Boolean> tableCell = new TableCell<Alias, Boolean>(this){

                    protected void updateItem(Boolean item, boolean empty) {
                        this.setAlignment(Pos.CENTER);
                        this.setText(null);
                        if (empty || item == null || !item.booleanValue()) {
                            this.setGraphic(null);
                        } else {
                            IconNode iconNode = new IconNode((IconCode)FontAwesome.EXCLAMATION_CIRCLE);
                            iconNode.setFill((Paint)Color.RED);
                            this.setGraphic((Node)iconNode);
                            this.setText("Identifier Overlap");
                        }
                    }
                };
                return tableCell;
            });
            this.mAliasTableView.getColumns().addAll((Object[])new TableColumn[]{nameColumn, groupColumn, colorColumn, iconColumn, priorityColumn, recordColumn, streamColumn, idsColumn, errorsColumn});
            this.mAliasTableView.setPlaceholder((Node)this.getPlaceholderLabel());
            this.mAliasTableView.setItems(this.getAliasSortedList());
            this.mAliasTableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            this.mAliasTableView.getSelectionModel().getSelectedItems().addListener(c -> Platform.runLater(() -> this.setAliases((List<Alias>)this.mAliasTableView.getSelectionModel().getSelectedItems())));
        }
        return this.mAliasTableView;
    }

    private FilteredList<Alias> getAliasFilteredList() {
        if (this.mAliasFilteredList == null) {
            this.mAliasFilteredList = new FilteredList(this.mPlaylistManager.getAliasModel().aliasList(), (Predicate)this.getAliasPredicate());
        }
        return this.mAliasFilteredList;
    }

    private SortedList<Alias> getAliasSortedList() {
        if (this.mAliasSortedList == null) {
            this.mAliasSortedList = new SortedList(this.getAliasFilteredList());
            this.mAliasSortedList.comparatorProperty().bind((ObservableValue)this.getAliasTableView().comparatorProperty());
            this.getAliasBulkEditor().changeInProgressProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.mAliasSortedList.comparatorProperty().unbind();
                    this.mAliasSortedList.setComparator(null);
                } else {
                    this.mAliasSortedList.comparatorProperty().bind((ObservableValue)this.getAliasTableView().comparatorProperty());
                }
            });
        }
        return this.mAliasSortedList;
    }

    private Label getPlaceholderLabel() {
        if (this.mPlaceholderLabel == null) {
            this.mPlaceholderLabel = new Label("Select an Alias List and click the New button to create new aliases");
        }
        return this.mPlaceholderLabel;
    }

    private VBox getButtonBox() {
        if (this.mButtonBox == null) {
            this.mButtonBox = new VBox();
            this.mButtonBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            this.mButtonBox.setSpacing(10.0);
            Button fillerButton = new Button();
            fillerButton.setVisible(false);
            this.mButtonBox.getChildren().addAll((Object[])new Node[]{fillerButton, this.getNewAliasButton(), this.getCloneAliasButton(), this.getMoveToAliasButton(), this.getDeleteAliasButton()});
        }
        return this.mButtonBox;
    }

    private Button getNewAliasButton() {
        if (this.mNewAliasButton == null) {
            this.mNewAliasButton = new Button("New");
            this.mNewAliasButton.setDisable(true);
            this.mNewAliasButton.setAlignment(Pos.CENTER);
            this.mNewAliasButton.setMaxWidth(Double.MAX_VALUE);
            this.mNewAliasButton.setOnAction(event -> {
                Alias alias = new Alias("New Alias");
                alias.setAliasListName((String)this.getAliasListNameComboBox().getSelectionModel().getSelectedItem());
                this.mPlaylistManager.getAliasModel().addAlias(alias);
                Platform.runLater(() -> {
                    this.getAliasTableView().getSelectionModel().clearSelection();
                    this.getAliasTableView().getSelectionModel().select((Object)alias);
                    this.getAliasTableView().scrollTo((Object)alias);
                });
            });
        }
        return this.mNewAliasButton;
    }

    private Button getDeleteAliasButton() {
        if (this.mDeleteAliasButton == null) {
            this.mDeleteAliasButton = new Button("Delete");
            this.mDeleteAliasButton.setDisable(true);
            this.mDeleteAliasButton.setMaxWidth(Double.MAX_VALUE);
            this.mDeleteAliasButton.setOnAction(event -> {
                int count;
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Do you want to delete [" + count + "] selected alias" + ((count = this.getAliasTableView().getSelectionModel().getSelectedItems().size()) > 1 ? "es?" : "?"), new ButtonType[]{ButtonType.NO, ButtonType.YES});
                alert.setTitle("Delete Alias");
                alert.setHeaderText("Are you sure?");
                alert.initOwner(this.getDeleteAliasButton().getScene().getWindow());
                Optional result = alert.showAndWait();
                if (result.get() == ButtonType.YES) {
                    ArrayList<Alias> selectedAliases = new ArrayList<Alias>((Collection<Alias>)this.getAliasTableView().getSelectionModel().getSelectedItems());
                    this.mPlaylistManager.getAliasModel().removeAliases(selectedAliases);
                }
            });
        }
        return this.mDeleteAliasButton;
    }

    private Button getCloneAliasButton() {
        if (this.mCloneAliasButton == null) {
            this.mCloneAliasButton = new Button("Clone");
            this.mCloneAliasButton.setDisable(true);
            this.mCloneAliasButton.setMaxWidth(Double.MAX_VALUE);
            this.mCloneAliasButton.setOnAction(event -> {
                Alias original = (Alias)this.getAliasTableView().getSelectionModel().getSelectedItem();
                Alias copy = AliasFactory.shallowCopyOf(original);
                this.mPlaylistManager.getAliasModel().addAlias(copy);
                this.getAliasTableView().getSelectionModel().clearSelection();
                this.getAliasTableView().getSelectionModel().select((Object)copy);
                this.getAliasTableView().scrollTo((Object)copy);
            });
        }
        return this.mCloneAliasButton;
    }

    private MenuButton getMoveToAliasButton() {
        if (this.mMoveToAliasButton == null) {
            this.mMoveToAliasButton = new MenuButton("Move To");
            this.mMoveToAliasButton.setDisable(true);
            this.mMoveToAliasButton.setOnShowing(event -> {
                this.mMoveToAliasButton.getItems().clear();
                MenuItem emptyItem = new MenuItem("Alias Lists");
                emptyItem.setDisable(true);
                this.mMoveToAliasButton.getItems().addAll((Object[])new MenuItem[]{emptyItem, new SeparatorMenuItem()});
                List<String> aliasLists = this.mPlaylistManager.getAliasModel().getListNames();
                for (String aliasList : aliasLists) {
                    if (aliasList.contentEquals("(No Alias List)") || aliasList.contentEquals((CharSequence)this.getAliasListNameComboBox().getSelectionModel().getSelectedItem())) continue;
                    this.mMoveToAliasButton.getItems().add((Object)new MoveToAliasListItem(aliasList));
                }
            });
        }
        return this.mMoveToAliasButton;
    }

    public class AliasPredicate
    implements Predicate<Alias> {
        private String mAliasListName;
        private String mSearchText;

        public AliasPredicate(AliasConfigurationEditor this$0) {
        }

        @Override
        public boolean test(Alias alias) {
            if (this.mAliasListName == null) {
                return false;
            }
            if (this.mAliasListName.equals(alias.getAliasListName())) {
                if (alias.getName() == null) {
                    return true;
                }
                if (alias.getName().toLowerCase().contains(this.mSearchText)) {
                    return true;
                }
                if (alias.getGroup() != null && alias.getGroup().toLowerCase().contains(this.mSearchText)) {
                    return true;
                }
            }
            return false;
        }

        public void setAliasListName(String aliasListName) {
            if (aliasListName != null) {
                this.mAliasListName = aliasListName;
            }
        }

        public void setSearchText(String searchText) {
            this.mSearchText = searchText != null ? searchText.toLowerCase() : null;
        }
    }

    public class ColorizedCell
    implements Callback<TableColumn<Alias, Integer>, TableCell<Alias, Integer>> {
        public ColorizedCell(AliasConfigurationEditor this$0) {
        }

        public TableCell<Alias, Integer> call(TableColumn<Alias, Integer> param) {
            final Rectangle rectangle = new Rectangle(20.0, 20.0);
            rectangle.setArcHeight(10.0);
            rectangle.setArcWidth(10.0);
            TableCell<Alias, Integer> tableCell = new TableCell<Alias, Integer>(this){

                protected void updateItem(Integer item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (!empty && this.getTableRow() != null) {
                        Alias alias = (Alias)this.getTableRow().getItem();
                        if (alias != null) {
                            rectangle.setVisible(true);
                            rectangle.setFill((Paint)ColorUtil.fromInteger(alias.getColor()));
                        } else {
                            rectangle.setVisible(false);
                        }
                    } else {
                        rectangle.setVisible(false);
                    }
                }
            };
            tableCell.setAlignment(Pos.CENTER);
            tableCell.setGraphic((Node)rectangle);
            return tableCell;
        }
    }

    public class IconTableCellFactory
    implements Callback<TableColumn<Alias, String>, TableCell<Alias, String>> {
        public TableCell<Alias, String> call(TableColumn<Alias, String> param) {
            TableCell<Alias, String> tableCell = new TableCell<Alias, String>(){

                protected void updateItem(String item, boolean empty) {
                    Alias alias;
                    super.updateItem((Object)item, empty);
                    this.setAlignment(Pos.CENTER);
                    if (empty) {
                        this.setGraphic(null);
                    } else if (this.getTableRow() != null && (alias = (Alias)this.getTableRow().getItem()) != null) {
                        Icon icon = AliasConfigurationEditor.this.mPlaylistManager.getIconModel().getIcon(alias.getIconName());
                        if (icon != null && icon.getFxImage() != null) {
                            this.setGraphic((Node)new ImageView(icon.getFxImage()));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                }
            };
            return tableCell;
        }
    }

    public class PriorityCellFactory
    implements Callback<TableColumn<Alias, Integer>, TableCell<Alias, Integer>> {
        public PriorityCellFactory(AliasConfigurationEditor this$0) {
        }

        public TableCell<Alias, Integer> call(TableColumn<Alias, Integer> param) {
            TableCell<Alias, Integer> tableCell = new TableCell<Alias, Integer>(this){

                protected void updateItem(Integer item, boolean empty) {
                    if (empty) {
                        this.setText(null);
                        this.setGraphic(null);
                    } else if (item == -1) {
                        this.setText("Mute");
                        IconNode iconNode = new IconNode((IconCode)FontAwesome.VOLUME_OFF);
                        iconNode.setIconSize((Number)20);
                        iconNode.setFill((Paint)Color.RED);
                        this.setGraphic((Node)iconNode);
                    } else if (item == 100) {
                        this.setText("Default");
                        IconNode iconNode = new IconNode((IconCode)FontAwesome.VOLUME_UP);
                        iconNode.setIconSize((Number)20);
                        iconNode.setFill((Paint)Color.GREEN);
                        this.setGraphic((Node)iconNode);
                    } else {
                        this.setText(item.toString());
                        IconNode iconNode = new IconNode((IconCode)FontAwesome.VOLUME_UP);
                        iconNode.setIconSize((Number)20);
                        iconNode.setFill((Paint)Color.GREEN);
                        this.setGraphic((Node)iconNode);
                    }
                }
            };
            return tableCell;
        }
    }

    public class IconCell
    implements Callback<TableColumn<Alias, Boolean>, TableCell<Alias, Boolean>> {
        private IconCode mIconCode;
        private Color mColor;

        public IconCell(AliasConfigurationEditor this$0, IconCode iconCode, Color color) {
            this.mIconCode = iconCode;
            this.mColor = color;
        }

        public TableCell<Alias, Boolean> call(TableColumn<Alias, Boolean> param) {
            final IconNode iconNode = new IconNode(this.mIconCode);
            iconNode.setIconSize((Number)20);
            iconNode.setFill((Paint)this.mColor);
            TableCell<Alias, Boolean> tableCell = new TableCell<Alias, Boolean>(this){

                protected void updateItem(Boolean item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (!empty && this.getTableRow() != null) {
                        iconNode.setVisible(item.booleanValue());
                    } else {
                        iconNode.setVisible(false);
                    }
                }
            };
            tableCell.setAlignment(Pos.CENTER);
            tableCell.setGraphic((Node)iconNode);
            return tableCell;
        }
    }

    public class IdentifierCountCell
    implements Callback<TableColumn.CellDataFeatures<Alias, Integer>, ObservableValue<Integer>> {
        public IdentifierCountCell(AliasConfigurationEditor this$0) {
        }

        public ObservableValue<Integer> call(TableColumn.CellDataFeatures<Alias, Integer> param) {
            if (param.getValue() != null) {
                return ((Alias)param.getValue()).nonAudioIdentifierCountProperty().asObject();
            }
            return null;
        }
    }

    public class MoveToAliasListItem
    extends MenuItem {
        public MoveToAliasListItem(String aliasList) {
            super(aliasList);
            this.setOnAction(event -> {
                ArrayList selectedAliases = new ArrayList(AliasConfigurationEditor.this.getAliasTableView().getSelectionModel().getSelectedItems());
                for (Alias selected : selectedAliases) {
                    AliasList existing = AliasConfigurationEditor.this.mPlaylistManager.getAliasModel().getAliasList(selected.getAliasListName());
                    existing.removeAlias(selected);
                    selected.setAliasListName(this.getText());
                    AliasList moveToList = AliasConfigurationEditor.this.mPlaylistManager.getAliasModel().getAliasList(selected.getAliasListName());
                    moveToList.addAlias(selected);
                }
            });
        }
    }

    public class CenteredCountCell
    extends TableCell<Alias, Integer> {
        public CenteredCountCell(AliasConfigurationEditor this$0) {
            this.setAlignment(Pos.CENTER);
        }
    }

    public class CenteredCountCellFactory
    implements Callback<TableColumn<Alias, Integer>, TableCell<Alias, Integer>> {
        public TableCell<Alias, Integer> call(TableColumn<Alias, Integer> param) {
            return new CenteredCountCell(AliasConfigurationEditor.this);
        }
    }

    public class ActionCountCell
    implements Callback<TableColumn.CellDataFeatures<Alias, Integer>, ObservableValue<Integer>> {
        public ActionCountCell(AliasConfigurationEditor this$0) {
        }

        public ObservableValue<Integer> call(TableColumn.CellDataFeatures<Alias, Integer> param) {
            Integer count = null;
            if (param.getValue() != null && ((Alias)param.getValue()).getAliasActions().size() > 0) {
                count = ((Alias)param.getValue()).getAliasActions().size();
            }
            return new ReadOnlyObjectWrapper(count);
        }
    }
}

