/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.playlist;

import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.gui.JavaFxWindowManager;
import io.github.dsheirer.gui.playlist.PlaylistEditor;
import io.github.dsheirer.icon.IconModel;
import io.github.dsheirer.module.log.EventLogManager;
import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class PlaylistEditorApplication
extends Application {
    private Stage mStage;
    private Parent mPlaylistEditor;
    private TunerManager mTunerManager;
    private UserPreferences mUserPreferences = new UserPreferences();
    private PlaylistManager mPlaylistManager;
    private JavaFxWindowManager mJavaFxWindowManager;

    public PlaylistEditorApplication() {
        AliasModel aliasModel = new AliasModel();
        EventLogManager eventLogManager = new EventLogManager(aliasModel, this.mUserPreferences);
        this.mTunerManager = new TunerManager(this.mUserPreferences);
        this.mTunerManager.start();
        this.mPlaylistManager = new PlaylistManager(this.mUserPreferences, this.mTunerManager, aliasModel, eventLogManager, new IconModel());
        this.mPlaylistManager.init();
        this.mJavaFxWindowManager = new JavaFxWindowManager(this.mUserPreferences, this.mTunerManager, this.mPlaylistManager);
    }

    public void start(Stage primaryStage) throws Exception {
        this.mStage = primaryStage;
        this.mStage.setTitle("Playlist Editor");
        Scene scene = new Scene(this.getPlaylistEditor(), 1000.0, 750.0);
        this.mStage.setScene(scene);
        this.mStage.show();
    }

    private Parent getPlaylistEditor() {
        if (this.mPlaylistEditor == null) {
            this.mPlaylistEditor = new PlaylistEditor(this.mPlaylistManager, this.mTunerManager, this.mUserPreferences);
        }
        return this.mPlaylistEditor;
    }

    public static void main(String[] args) {
        PlaylistEditorApplication.launch((String[])args);
    }
}

