/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.decoder;

import io.github.dsheirer.gui.instrument.chart.ComplexSampleLineChart;
import io.github.dsheirer.gui.instrument.chart.DoubleLineChart;
import io.github.dsheirer.gui.instrument.chart.EyeDiagramChart;
import io.github.dsheirer.gui.instrument.chart.PhaseLineChart;
import io.github.dsheirer.gui.instrument.chart.SampleXYChart;
import io.github.dsheirer.gui.instrument.chart.SymbolChart;
import io.github.dsheirer.gui.instrument.decoder.ComplexDecoderPane;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.p25.phase2.DecodeConfigP25Phase2;
import io.github.dsheirer.module.decode.p25.phase2.P25P2DecoderHDQPSKInstrumented;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import java.util.Iterator;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25Phase2HDQPSKPane
extends ComplexDecoderPane {
    private static final Logger mLog = LoggerFactory.getLogger(P25Phase2HDQPSKPane.class);
    private HBox mSampleChartBox;
    private HBox mDecoderChartBox;
    private ComplexSampleLineChart mSampleLineChartRaw;
    private ComplexSampleLineChart mSampleLineChartPllCorrected;
    private EyeDiagramChart mEyeDiagramChart;
    private DoubleLineChart mSamplesPerSymbolLineChart;
    private SymbolChart mSymbolChart;
    private PhaseLineChart mPLLPhaseErrorLineChart;
    private DoubleLineChart mPLLFrequencyLineChart;
    private SampleXYChart mSampleXYChart;
    private Broadcaster<ComplexSamples> mFilteredBufferBroadcaster = new Broadcaster();
    private P25P2DecoderHDQPSKInstrumented mDecoder = new P25P2DecoderHDQPSKInstrumented(new DecodeConfigP25Phase2());

    public P25Phase2HDQPSKPane() {
        super(DecoderType.P25_PHASE2);
        this.init();
    }

    private void init() {
        this.addListener(nativeBuffer -> {
            Iterator<ComplexSamples> iterator = nativeBuffer.iterator();
            while (iterator.hasNext()) {
                this.getDecoder().receive(iterator.next());
            }
        });
        this.getDecoder().getDemodulator().setFilteredGainAppliedComplexBufferListener(this.getSampleXYChart());
        this.getDecoder().setFilteredBufferListener(this.mFilteredBufferBroadcaster);
        this.getDecoder().setComplexSymbolListener(this.getSymbolChart());
        this.getDecoder().setPLLPhaseErrorListener(this.getPLLPhaseErrorLineChart());
        this.getDecoder().setPLLFrequencyListener(this.getPLLFrequencyLineChart());
        this.getDecoder().setSymbolDecisionDataListener(this.getEyeDiagramChart());
        this.getDecoder().setSamplesPerSymbolListener(this.getSamplesPerSymbolLineChart());
        this.mFilteredBufferBroadcaster.addListener(this.getSampleLineChartRaw());
        this.getDecoder().getSampleBuffer().setSampleListener(this.getSampleLineChartPllCorrected());
        HBox.setHgrow((Node)this.getSampleChartBox(), (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.getDecoderChartBox(), (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.getSampleChartBox(), this.getDecoderChartBox()});
        this.mDecoder.setMessageListener(new Listener<IMessage>(this){

            @Override
            public void receive(IMessage message) {
                mLog.debug(message.toString());
            }
        });
    }

    @Override
    public void setSampleRate(double sampleRate) {
        mLog.debug("Configuring for sample rate: " + sampleRate);
        this.mDecoder.setSampleRate(sampleRate);
        double samplesPerSymbol = sampleRate / 4800.0;
        this.getSampleLineChartRaw().setSamplesPerSymbol((int)samplesPerSymbol);
        this.getDecoder().getSampleBuffer().setSampleListener(this.getSampleLineChartPllCorrected());
        this.getDecoder().getDemodulator().setFilteredGainAppliedComplexBufferListener(this.getSampleXYChart());
    }

    private P25P2DecoderHDQPSKInstrumented getDecoder() {
        return this.mDecoder;
    }

    private SymbolChart getSymbolChart() {
        if (this.mSymbolChart == null) {
            this.mSymbolChart = new SymbolChart(10);
        }
        return this.mSymbolChart;
    }

    private HBox getDecoderChartBox() {
        if (this.mDecoderChartBox == null) {
            this.mDecoderChartBox = new HBox();
            this.mDecoderChartBox.setMaxHeight(Double.MAX_VALUE);
            this.getSymbolChart().setMaxWidth(Double.MAX_VALUE);
            this.getPLLPhaseErrorLineChart().setMaxWidth(Double.MAX_VALUE);
            this.getPLLFrequencyLineChart().setMaxWidth(Double.MAX_VALUE);
            this.getSampleXYChart().setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)this.getSymbolChart(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getPLLPhaseErrorLineChart(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getPLLFrequencyLineChart(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getSampleXYChart(), (Priority)Priority.ALWAYS);
            this.mDecoderChartBox.getChildren().addAll((Object[])new Node[]{this.getPLLPhaseErrorLineChart(), this.getPLLFrequencyLineChart(), this.getSymbolChart(), this.getSampleXYChart()});
        }
        return this.mDecoderChartBox;
    }

    private HBox getSampleChartBox() {
        if (this.mSampleChartBox == null) {
            this.mSampleChartBox = new HBox();
            this.mSampleChartBox.setMaxHeight(Double.MAX_VALUE);
            this.getSampleLineChartRaw().setMaxWidth(Double.MAX_VALUE);
            this.getSampleLineChartPllCorrected().setMaxWidth(Double.MAX_VALUE);
            this.getEyeDiagramChart().setMaxWidth(Double.MAX_VALUE);
            this.getSamplesPerSymbolLineChart().setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)this.getSampleLineChartRaw(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getSampleLineChartPllCorrected(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getEyeDiagramChart(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getSamplesPerSymbolLineChart(), (Priority)Priority.ALWAYS);
            this.mSampleChartBox.getChildren().addAll((Object[])new Node[]{this.getSampleLineChartRaw(), this.getSampleLineChartPllCorrected(), this.getEyeDiagramChart(), this.getSamplesPerSymbolLineChart()});
        }
        return this.mSampleChartBox;
    }

    private ComplexSampleLineChart getSampleLineChartRaw() {
        if (this.mSampleLineChartRaw == null) {
            this.mSampleLineChartRaw = new ComplexSampleLineChart("Raw Samples", 100, 10);
        }
        return this.mSampleLineChartRaw;
    }

    private ComplexSampleLineChart getSampleLineChartPllCorrected() {
        if (this.mSampleLineChartPllCorrected == null) {
            this.mSampleLineChartPllCorrected = new ComplexSampleLineChart("PLL Corrected Samples", 100, 10);
        }
        return this.mSampleLineChartPllCorrected;
    }

    private EyeDiagramChart getEyeDiagramChart() {
        if (this.mEyeDiagramChart == null) {
            this.mEyeDiagramChart = new EyeDiagramChart(10, "Symbol: 3-4");
        }
        return this.mEyeDiagramChart;
    }

    private PhaseLineChart getPLLPhaseErrorLineChart() {
        if (this.mPLLPhaseErrorLineChart == null) {
            this.mPLLPhaseErrorLineChart = new PhaseLineChart(40);
        }
        return this.mPLLPhaseErrorLineChart;
    }

    private DoubleLineChart getPLLFrequencyLineChart() {
        if (this.mPLLFrequencyLineChart == null) {
            this.mPLLFrequencyLineChart = new DoubleLineChart("PLL Frequency", -500.0, 500.0, 50.0, 40);
        }
        return this.mPLLFrequencyLineChart;
    }

    private SampleXYChart getSampleXYChart() {
        if (this.mSampleXYChart == null) {
            this.mSampleXYChart = new SampleXYChart(100, "Samples");
        }
        return this.mSampleXYChart;
    }

    private DoubleLineChart getSamplesPerSymbolLineChart() {
        if (this.mSamplesPerSymbolLineChart == null) {
            this.mSamplesPerSymbolLineChart = new DoubleLineChart("Sample Point", 8.0, 10.0, 0.1, 40);
        }
        return this.mSamplesPerSymbolLineChart;
    }
}

