/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.decoder;

import io.github.dsheirer.gui.instrument.chart.ComplexSampleLineChart;
import io.github.dsheirer.gui.instrument.chart.DoubleLineChart;
import io.github.dsheirer.gui.instrument.chart.EyeDiagramChart;
import io.github.dsheirer.gui.instrument.chart.PhaseLineChart;
import io.github.dsheirer.gui.instrument.chart.SamplesPerSymbolChart;
import io.github.dsheirer.gui.instrument.chart.SymbolChart;
import io.github.dsheirer.gui.instrument.decoder.ComplexDecoderPane;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DecoderLSMInstrumented;
import io.github.dsheirer.sample.Broadcaster;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import java.util.Iterator;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25Phase1LSMPane
extends ComplexDecoderPane {
    private static final Logger mLog = LoggerFactory.getLogger(P25Phase1LSMPane.class);
    private HBox mTopChartBox;
    private ComplexSampleLineChart mDifferentialDemodulatedSamplesChartBox;
    private EyeDiagramChart mEyeDiagramChart;
    private HBox mBottomChartBox;
    private SymbolChart mSymbolConstellationChart;
    private PhaseLineChart mPLLPhaseErrorLineChart;
    private DoubleLineChart mPLLFrequencyLineChart;
    private SamplesPerSymbolChart mSamplesPerSymbolLineChart;
    private Broadcaster<ComplexSamples> mFilteredBufferBroadcaster = new Broadcaster();
    private P25P1DecoderLSMInstrumented mDecoder = new P25P1DecoderLSMInstrumented();

    public P25Phase1LSMPane() {
        super(DecoderType.P25_PHASE1);
        this.init();
    }

    private void init() {
        this.addListener(nativeBuffer -> {
            Iterator<ComplexSamples> iterator = nativeBuffer.iterator();
            while (iterator.hasNext()) {
                this.getDecoder().receive(iterator.next());
            }
        });
        this.getDecoder().setFilteredBufferListener(this.mFilteredBufferBroadcaster);
        this.getDecoder().setComplexSymbolListener(this.getSymbolConstellationChart());
        this.getDecoder().setPLLPhaseErrorListener(this.getPLLPhaseErrorLineChart());
        this.getDecoder().setPLLFrequencyListener(this.getPLLFrequencyLineChart());
        this.getDecoder().setSymbolDecisionDataListener(this.getEyeDiagramChart());
        this.getDecoder().setSamplesPerSymbolListener(this.getSamplesPerSymbolLineChart());
        this.mFilteredBufferBroadcaster.addListener(this.getDifferentialDemodulatedSamplesChartBox());
        HBox.setHgrow((Node)this.getTopChartBox(), (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.getBottomChartBox(), (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.getTopChartBox(), this.getBottomChartBox()});
        this.mDecoder.setMessageListener(new Listener<IMessage>(this){

            @Override
            public void receive(IMessage message) {
                mLog.debug(message.toString());
            }
        });
    }

    @Override
    public void setSampleRate(double sampleRate) {
        mLog.debug("Configuring for sample rate: " + sampleRate);
        this.mDecoder.setSampleRate(sampleRate);
        double samplesPerSymbol = sampleRate / 4800.0;
        this.getDifferentialDemodulatedSamplesChartBox().setSamplesPerSymbol((int)samplesPerSymbol);
        this.getSamplesPerSymbolLineChart().setSamplesPerSymbol(samplesPerSymbol);
    }

    private P25P1DecoderLSMInstrumented getDecoder() {
        return this.mDecoder;
    }

    private SymbolChart getSymbolConstellationChart() {
        if (this.mSymbolConstellationChart == null) {
            this.mSymbolConstellationChart = new SymbolChart(10);
        }
        return this.mSymbolConstellationChart;
    }

    private HBox getBottomChartBox() {
        if (this.mBottomChartBox == null) {
            this.mBottomChartBox = new HBox();
            this.mBottomChartBox.setMaxHeight(Double.MAX_VALUE);
            this.getSymbolConstellationChart().setMaxWidth(Double.MAX_VALUE);
            this.getPLLPhaseErrorLineChart().setMaxWidth(Double.MAX_VALUE);
            this.getPLLFrequencyLineChart().setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)this.getSymbolConstellationChart(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getPLLPhaseErrorLineChart(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getPLLFrequencyLineChart(), (Priority)Priority.ALWAYS);
            this.mBottomChartBox.getChildren().addAll((Object[])new Node[]{this.getSymbolConstellationChart(), this.getPLLPhaseErrorLineChart(), this.getPLLFrequencyLineChart()});
        }
        return this.mBottomChartBox;
    }

    private HBox getTopChartBox() {
        if (this.mTopChartBox == null) {
            this.mTopChartBox = new HBox();
            this.mTopChartBox.setMaxHeight(Double.MAX_VALUE);
            this.getDifferentialDemodulatedSamplesChartBox().setMaxWidth(Double.MAX_VALUE);
            this.getEyeDiagramChart().setMaxWidth(Double.MAX_VALUE);
            this.getSamplesPerSymbolLineChart().setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)this.getDifferentialDemodulatedSamplesChartBox(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getEyeDiagramChart(), (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.getSamplesPerSymbolLineChart(), (Priority)Priority.ALWAYS);
            this.mTopChartBox.getChildren().addAll((Object[])new Node[]{this.getDifferentialDemodulatedSamplesChartBox(), this.getEyeDiagramChart(), this.getSamplesPerSymbolLineChart()});
        }
        return this.mTopChartBox;
    }

    private ComplexSampleLineChart getDifferentialDemodulatedSamplesChartBox() {
        if (this.mDifferentialDemodulatedSamplesChartBox == null) {
            this.mDifferentialDemodulatedSamplesChartBox = new ComplexSampleLineChart("Raw Samples", 100, 10);
        }
        return this.mDifferentialDemodulatedSamplesChartBox;
    }

    private EyeDiagramChart getEyeDiagramChart() {
        if (this.mEyeDiagramChart == null) {
            this.mEyeDiagramChart = new EyeDiagramChart(10, "Symbol/Eye Diagram");
        }
        return this.mEyeDiagramChart;
    }

    private PhaseLineChart getPLLPhaseErrorLineChart() {
        if (this.mPLLPhaseErrorLineChart == null) {
            this.mPLLPhaseErrorLineChart = new PhaseLineChart(40);
        }
        return this.mPLLPhaseErrorLineChart;
    }

    private DoubleLineChart getPLLFrequencyLineChart() {
        if (this.mPLLFrequencyLineChart == null) {
            this.mPLLFrequencyLineChart = new DoubleLineChart("PLL Frequency", -2500.0, 2500.0, 200.0, 40);
        }
        return this.mPLLFrequencyLineChart;
    }

    private SamplesPerSymbolChart getSamplesPerSymbolLineChart() {
        if (this.mSamplesPerSymbolLineChart == null) {
            this.mSamplesPerSymbolLineChart = new SamplesPerSymbolChart(40, 6.25);
        }
        return this.mSamplesPerSymbolLineChart;
    }
}

