/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument.chart;

import io.github.dsheirer.dsp.psk.SymbolDecisionData;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.Complex;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EyeDiagramChart
extends LineChart
implements Listener<SymbolDecisionData> {
    private static final Logger mLog = LoggerFactory.getLogger(EyeDiagramChart.class);
    private ObservableList<XYChart.Series<Double, Float>> mData = FXCollections.observableArrayList();
    private int mSeriesCount;
    private int mSeriesPointer;
    private int mSeriesLength;

    public EyeDiagramChart(int seriesCount, String legend) {
        super((Axis)new NumberAxis("Sample Point = 3", -1.0, 7.0, 1.0), (Axis)new NumberAxis("Radians", -5.0, 5.0, 0.5));
        this.mSeriesCount = seriesCount;
        this.init();
    }

    private void init() {
        for (int x = 0; x < this.mSeriesCount; ++x) {
            ObservableList series = FXCollections.observableArrayList();
            this.mData.add((Object)new XYChart.Series(series));
        }
        this.setData(this.mData);
    }

    private ObservableList<XYChart.Data<Double, Float>> getSeries(int series, int length) {
        ObservableList seriesData = ((XYChart.Series)this.mData.get(series)).getData();
        while (seriesData.size() > length) {
            seriesData.remove(0);
        }
        while (seriesData.size() < length) {
            seriesData.add((Object)new XYChart.Data((Object)0.0, (Object)Float.valueOf(0.0f)));
        }
        return seriesData;
    }

    private void checkChartLength(int length) {
        if (this.mSeriesLength != length) {
            ((NumberAxis)this.getXAxis()).setUpperBound((double)length);
            this.mSeriesLength = length;
        }
    }

    private float[] conditionData(Complex[] samples) {
        int x;
        Object previousAngle = null;
        float[] corrected = new float[samples.length];
        int phaseRolloverIndex = -1;
        for (x = 0; x < samples.length; ++x) {
            corrected[x] = samples[x].angle();
            if (x <= 0 || !((double)FastMath.abs((float)(corrected[x] - corrected[x - 1])) > Math.PI)) continue;
            phaseRolloverIndex = x;
        }
        if (phaseRolloverIndex >= 0) {
            for (x = 0; x < phaseRolloverIndex; ++x) {
                if (corrected[x] > 0.0f) {
                    int n = x;
                    corrected[n] = (float)((double)corrected[n] - Math.PI * 2);
                    continue;
                }
                int n = x;
                corrected[n] = (float)((double)corrected[n] + Math.PI * 2);
            }
        }
        return corrected;
    }

    @Override
    public void receive(SymbolDecisionData symbolDecisionData) {
        Complex[] samples = symbolDecisionData.getSamples();
        int length = samples.length;
        ObservableList<XYChart.Data<Double, Float>> iSeries = this.getSeries(this.mSeriesPointer++, length);
        if (this.mSeriesPointer >= this.mSeriesCount) {
            this.mSeriesPointer = 0;
        }
        float[] angles = this.conditionData(samples);
        for (int x = 0; x < samples.length; ++x) {
            XYChart.Data iDataPoint = (XYChart.Data)iSeries.get(x);
            Complex sample = samples[x];
            iDataPoint.setXValue((Object)((double)x - (double)symbolDecisionData.getSamplingPoint()));
            iDataPoint.setYValue((Object)Float.valueOf(angles[x]));
        }
    }
}

