/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.instrument;

import java.io.File;
import java.util.prefs.Preferences;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;

public class RecentFilesMenu
extends Menu
implements EventHandler<ActionEvent> {
    private static final String PREFERENCE_RECENT_FILE = ".recent.file.";
    private Preferences mPreferences = Preferences.userNodeForPackage(RecentFilesMenu.class);
    private IFileSelectionListener mFileSelectionListener;
    private String mIdentifier;
    private int mSize;

    public RecentFilesMenu(String label, String uniqueIdentifier, int size) {
        super(label);
        this.mIdentifier = uniqueIdentifier;
        this.mSize = size;
        this.load();
    }

    public void setFileSelectionListener(IFileSelectionListener listener) {
        this.mFileSelectionListener = listener;
    }

    public void add(File file) {
        if (file != null) {
            String filePath = file.getAbsolutePath();
            int index = this.mSize - 1;
            for (int x = this.mSize - 1; x >= 0; --x) {
                String existingItem = this.mPreferences.get(this.getKey(x), null);
                if (existingItem == null || !existingItem.equals(filePath)) continue;
                index = x;
                break;
            }
            while (index > 0) {
                String newerItem = this.mPreferences.get(this.getKey(index - 1), null);
                if (newerItem != null) {
                    this.mPreferences.put(this.getKey(index), newerItem);
                }
                --index;
            }
            this.mPreferences.put(this.getKey(0), file.getAbsolutePath());
        }
        this.load();
    }

    private String getKey(int index) {
        return this.mIdentifier + PREFERENCE_RECENT_FILE + index;
    }

    private void load() {
        this.getItems().clear();
        for (int x = 0; x < this.mSize; ++x) {
            File file;
            String path = this.mPreferences.get(this.getKey(x), null);
            if (path == null || !(file = new File(path)).isFile()) continue;
            MenuItem menuItem = new MenuItem(file.getName());
            menuItem.setUserData((Object)file);
            menuItem.setOnAction((EventHandler)this);
            this.getItems().add((Object)menuItem);
        }
        if (this.getItems().size() > 0) {
            this.setDisable(false);
            this.getItems().add((Object)new SeparatorMenuItem());
            MenuItem clearMenuItem = new MenuItem("Clear History");
            clearMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    RecentFilesMenu.this.clearHistory();
                }
            });
            this.getItems().add((Object)clearMenuItem);
        } else {
            this.setDisable(true);
        }
    }

    private void clearHistory() {
        for (int x = 0; x < this.mSize; ++x) {
            this.mPreferences.remove(this.getKey(x));
        }
        this.load();
    }

    public void handle(ActionEvent event) {
        Object fileObject;
        if (this.mFileSelectionListener != null && event.getSource() instanceof MenuItem && (fileObject = ((MenuItem)event.getSource()).getUserData()) instanceof File) {
            this.mFileSelectionListener.fileSelected((File)fileObject);
        }
    }

    public static interface IFileSelectionListener {
        public void fileSelected(File var1);
    }
}

