/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.icon;

import io.github.dsheirer.gui.playlist.Editor;
import io.github.dsheirer.icon.Icon;
import io.github.dsheirer.icon.IconModel;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.transformation.SortedList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconManager
extends Editor<Icon> {
    private static final Logger mLog = LoggerFactory.getLogger(IconManager.class);
    private IconModel mIconModel;
    private TableView<Icon> mIconTableView;
    private Button mAddButton;
    private Button mEditButton;
    private Button mDeleteButton;
    private Button mSetAsDefaultButton;
    private SortedList<Icon> mIconSortedList;
    private GridPane mEditorPane;
    private Button mSaveButton;
    private Button mCancelButton;
    private Button mFileButton;
    private TextField mFilePathTextField;
    private TextField mNameTextField;
    private TitledPane mContentTitledPane;
    private TitledPane mEditorTitledPane;
    private Accordion mAccordion;

    public IconManager(IconModel iconModel) {
        this.mIconModel = iconModel;
        this.getChildren().addAll((Object[])new Node[]{this.getAccordion()});
    }

    private Accordion getAccordion() {
        if (this.mAccordion == null) {
            this.mAccordion = new Accordion();
            this.mAccordion.getPanes().addAll((Object[])new TitledPane[]{this.getContentTitledPane(), this.getEditorTitledPane()});
            this.mAccordion.setExpandedPane(this.getContentTitledPane());
        }
        return this.mAccordion;
    }

    private TitledPane getContentTitledPane() {
        if (this.mContentTitledPane == null) {
            this.mContentTitledPane = new TitledPane();
            this.mContentTitledPane.setCollapsible(false);
            VBox buttonsBox = new VBox();
            buttonsBox.setSpacing(10.0);
            buttonsBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            buttonsBox.getChildren().addAll((Object[])new Node[]{this.getAddButton(), this.getEditButton(), this.getDeleteButton(), this.getSetAsDefaultButton()});
            HBox.setHgrow(this.getIconTableView(), (Priority)Priority.ALWAYS);
            HBox contentBox = new HBox();
            contentBox.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
            contentBox.getChildren().addAll((Object[])new Node[]{this.getIconTableView(), buttonsBox});
            this.mContentTitledPane.setContent((Node)contentBox);
        }
        return this.mContentTitledPane;
    }

    private TitledPane getEditorTitledPane() {
        if (this.mEditorTitledPane == null) {
            this.mEditorTitledPane = new TitledPane();
            this.mEditorTitledPane.setDisable(true);
            this.mEditorTitledPane.setExpanded(false);
            this.mEditorTitledPane.setContent((Node)this.getEditorPane());
        }
        return this.mEditorTitledPane;
    }

    private SortedList<Icon> getIconSortedList() {
        if (this.mIconSortedList == null) {
            this.mIconSortedList = new SortedList(this.mIconModel.iconsProperty(), (o1, o2) -> {
                if (o1.getName() == null && o2.getName() == null) {
                    return 0;
                }
                if (o1.getName() == null) {
                    return -1;
                }
                if (o2.getName() == null) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            });
        }
        return this.mIconSortedList;
    }

    private TableView<Icon> getIconTableView() {
        if (this.mIconTableView == null) {
            this.mIconTableView = new TableView(this.getIconSortedList());
            TableColumn iconColumn = new TableColumn("Icon");
            iconColumn.setCellValueFactory((Callback)new PropertyValueFactory("path"));
            iconColumn.setCellFactory((Callback)new IconTableCellFactory(this));
            TableColumn nameColumn = new TableColumn("Name");
            nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
            TableColumn typeColumn = new TableColumn("Type");
            typeColumn.setPrefWidth(100.0);
            typeColumn.setCellValueFactory((Callback)new PropertyValueFactory("defaultIcon"));
            typeColumn.setCellFactory(param -> {
                TableCell<Icon, Boolean> tableCell = new TableCell<Icon, Boolean>(this){

                    protected void updateItem(Boolean item, boolean empty) {
                        Icon icon;
                        Icon icon2 = icon = this.getTableRow() != null ? (Icon)this.getTableRow().getItem() : null;
                        if (icon != null) {
                            if (icon.getDefaultIcon()) {
                                this.setText("Default");
                            } else if (icon.getStandardIcon()) {
                                this.setText("Standard");
                            } else {
                                this.setText("Custom");
                            }
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return tableCell;
            });
            this.mIconTableView.getColumns().addAll((Object[])new TableColumn[]{typeColumn, iconColumn, nameColumn});
            this.mIconTableView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
                this.getDeleteButton().setDisable(newValue == null || newValue.getDefaultIcon() || newValue.getStandardIcon());
                this.getEditButton().setDisable(newValue == null || newValue.getDefaultIcon() || newValue.getStandardIcon());
                this.getSetAsDefaultButton().setDisable(newValue == null || newValue.getDefaultIcon());
            });
        }
        return this.mIconTableView;
    }

    private void showEditor(boolean show) {
        if (show) {
            this.getEditorTitledPane().setText("Add or Edit an Icon");
            this.getEditorTitledPane().setDisable(false);
            this.getContentTitledPane().setCollapsible(true);
            this.getAccordion().setExpandedPane(this.getEditorTitledPane());
            this.getEditorTitledPane().setCollapsible(false);
            this.getContentTitledPane().setDisable(true);
        } else {
            this.getEditorTitledPane().setText(null);
            this.getContentTitledPane().setDisable(false);
            this.getEditorTitledPane().setCollapsible(true);
            this.getAccordion().setExpandedPane(this.getContentTitledPane());
            this.getContentTitledPane().setCollapsible(false);
            this.getEditorTitledPane().setDisable(true);
        }
    }

    private Button getAddButton() {
        if (this.mAddButton == null) {
            this.mAddButton = new Button("Add");
            this.mAddButton.setMaxWidth(Double.MAX_VALUE);
            this.mAddButton.disableProperty().bind((ObservableValue)this.getEditorPane().visibleProperty());
            this.mAddButton.setOnAction(event -> {
                this.setItem(null);
                this.showEditor(true);
            });
        }
        return this.mAddButton;
    }

    private Button getEditButton() {
        if (this.mEditButton == null) {
            this.mEditButton = new Button("Edit");
            this.mEditButton.setDisable(true);
            this.mEditButton.setMaxWidth(Double.MAX_VALUE);
            this.mEditButton.setOnAction(event -> {
                Icon selected = (Icon)this.getIconTableView().getSelectionModel().getSelectedItem();
                if (selected != null && !selected.standardIconProperty().get()) {
                    this.setItem(selected);
                    this.showEditor(true);
                }
            });
        }
        return this.mEditButton;
    }

    private Button getDeleteButton() {
        if (this.mDeleteButton == null) {
            this.mDeleteButton = new Button("Delete");
            this.mDeleteButton.setDisable(true);
            this.mDeleteButton.setMaxWidth(Double.MAX_VALUE);
            this.mDeleteButton.setOnAction(event -> {
                Icon selected = (Icon)this.getIconTableView().getSelectionModel().getSelectedItem();
                if (selected != null) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Delete alias: " + selected.getName() + "?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
                    alert.setTitle("Delete Alias");
                    alert.setHeaderText("Deleting Alias");
                    alert.showAndWait().ifPresent(buttonType -> {
                        if (buttonType == ButtonType.YES) {
                            this.mIconModel.removeIcon(selected);
                        }
                    });
                }
            });
        }
        return this.mDeleteButton;
    }

    private Button getSetAsDefaultButton() {
        if (this.mSetAsDefaultButton == null) {
            this.mSetAsDefaultButton = new Button("Set As Default");
            this.mSetAsDefaultButton.setDisable(true);
            this.mSetAsDefaultButton.setMaxWidth(Double.MAX_VALUE);
            this.mSetAsDefaultButton.setOnAction(event -> {
                Icon selected = (Icon)this.getIconTableView().getSelectionModel().getSelectedItem();
                if (selected != null) {
                    this.mIconModel.setDefaultIcon(selected);
                }
            });
        }
        return this.mSetAsDefaultButton;
    }

    @Override
    public void save() {
        String name = this.getNameTextField().getText();
        String path = this.getFilePathTextField().getText();
        if (name == null || name.isEmpty()) {
            Alert alert = new Alert(Alert.AlertType.ERROR, "Please assign a name for the icon", new ButtonType[]{ButtonType.OK});
            alert.setHeaderText("Name is required");
            alert.setTitle("Save Icon");
            alert.showAndWait();
            return;
        }
        if (path == null || path.isEmpty() || !Files.exists(Path.of(path, new String[0]), new LinkOption[0])) {
            Alert alert = new Alert(Alert.AlertType.ERROR, "Please select a picture file for the icon", new ButtonType[]{ButtonType.OK});
            alert.setHeaderText("File is required");
            alert.setTitle("Save Icon");
            alert.showAndWait();
            return;
        }
        if (this.getItem() != null) {
            ((Icon)this.getItem()).setName(name);
            ((Icon)this.getItem()).setPath(path);
        } else {
            Icon icon = new Icon();
            icon.setName(name);
            icon.setPath(path);
            if (icon.getFxImage() != null && icon.getFxImage().getException() != null) {
                Alert alert = new Alert(Alert.AlertType.ERROR, "Unable to load icon image from selected file. Please select a valid image file for the icon", new ButtonType[]{ButtonType.OK});
                alert.setHeaderText("Invalid image file");
                alert.setTitle("Save Icon");
                alert.showAndWait();
                return;
            }
            this.mIconModel.addIcon(icon);
        }
        this.showEditor(false);
        this.modifiedProperty().set(false);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setItem(Icon item) {
        super.setItem(item);
        if (item != null) {
            this.getNameTextField().setText(item.getName());
            this.getFilePathTextField().setText(item.getPath());
        } else {
            this.getNameTextField().setText(null);
            this.getFilePathTextField().setText(null);
        }
        this.modifiedProperty().set(false);
    }

    private GridPane getEditorPane() {
        if (this.mEditorPane == null) {
            this.mEditorPane = new GridPane();
            this.mEditorPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            this.mEditorPane.setHgap(10.0);
            this.mEditorPane.setVgap(10.0);
            int row = 0;
            Label nameLabel = new Label("Name");
            GridPane.setConstraints((Node)nameLabel, (int)0, (int)row);
            GridPane.setHalignment((Node)nameLabel, (HPos)HPos.RIGHT);
            this.mEditorPane.getChildren().add((Object)nameLabel);
            GridPane.setConstraints((Node)this.getNameTextField(), (int)1, (int)row);
            GridPane.setHgrow((Node)this.getNameTextField(), (Priority)Priority.ALWAYS);
            this.mEditorPane.getChildren().add((Object)this.getNameTextField());
            GridPane.setConstraints((Node)this.getSaveButton(), (int)2, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getSaveButton());
            GridPane.setConstraints((Node)this.getFileButton(), (int)0, (int)(++row));
            this.mEditorPane.getChildren().add((Object)this.getFileButton());
            GridPane.setHgrow((Node)this.getFilePathTextField(), (Priority)Priority.ALWAYS);
            GridPane.setConstraints((Node)this.getFilePathTextField(), (int)1, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getFilePathTextField());
            GridPane.setConstraints((Node)this.getCancelButton(), (int)2, (int)row);
            this.mEditorPane.getChildren().add((Object)this.getCancelButton());
        }
        return this.mEditorPane;
    }

    private TextField getFilePathTextField() {
        if (this.mFilePathTextField == null) {
            this.mFilePathTextField = new TextField();
        }
        return this.mFilePathTextField;
    }

    private Button getFileButton() {
        if (this.mFileButton == null) {
            this.mFileButton = new Button("File");
            this.mFileButton.setMaxWidth(Double.MAX_VALUE);
            this.mFileButton.setOnAction(event -> {
                File selected;
                FileChooser fileChooser = new FileChooser();
                fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Picture Files", new String[]{"*.png", "*.tif", "*.tiff", "*.gif", "*.jpg", "*.jpeg"}), new FileChooser.ExtensionFilter("All Files (*.*)", new String[]{"*.*"})});
                if (this.getFilePathTextField().getText() != null) {
                    try {
                        Path path = Path.of(this.getFilePathTextField().getText(), new String[0]);
                        if (path.toFile().exists()) {
                            fileChooser.setInitialDirectory(path.getParent().toFile());
                            fileChooser.setInitialFileName(path.getFileName().toString());
                        }
                    }
                    catch (Exception e) {
                        mLog.error("Error assigning file text to file chooser");
                    }
                }
                if ((selected = fileChooser.showOpenDialog(this.getFileButton().getScene().getWindow())) != null) {
                    this.getFilePathTextField().setText(selected.getAbsolutePath());
                }
            });
        }
        return this.mFileButton;
    }

    private TextField getNameTextField() {
        if (this.mNameTextField == null) {
            this.mNameTextField = new TextField();
        }
        return this.mNameTextField;
    }

    private Button getSaveButton() {
        if (this.mSaveButton == null) {
            this.mSaveButton = new Button("Save");
            this.mSaveButton.setMaxWidth(Double.MAX_VALUE);
            this.mSaveButton.setOnAction(event -> this.save());
            this.mSaveButton.disableProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)Bindings.isNull((ObservableObjectValue)this.getNameTextField().textProperty()), (ObservableBooleanValue)Bindings.isNull((ObservableObjectValue)this.getFilePathTextField().textProperty())));
        }
        return this.mSaveButton;
    }

    private Button getCancelButton() {
        if (this.mCancelButton == null) {
            this.mCancelButton = new Button("Cancel");
            this.mCancelButton.setMaxWidth(Double.MAX_VALUE);
            this.mCancelButton.setOnAction(event -> this.showEditor(false));
        }
        return this.mCancelButton;
    }

    public class IconTableCellFactory
    implements Callback<TableColumn<Icon, String>, TableCell<Icon, String>> {
        public IconTableCellFactory(IconManager this$0) {
        }

        public TableCell<Icon, String> call(TableColumn<Icon, String> param) {
            TableCell<Icon, String> tableCell = new TableCell<Icon, String>(this){

                protected void updateItem(String item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    this.setAlignment(Pos.CENTER);
                    if (empty) {
                        this.setGraphic(null);
                    } else if (this.getTableRow() != null) {
                        Icon icon = (Icon)this.getTableRow().getItem();
                        if (icon != null && icon.getFxImage() != null) {
                            this.setGraphic((Node)new ImageView(icon.getFxImage()));
                            this.setText(null);
                        } else {
                            this.setGraphic(null);
                            this.setText("Can't load image");
                        }
                    }
                }
            };
            return tableCell;
        }
    }
}

