/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.control;

import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LtrFormatter
extends TextFormatter<Integer> {
    private static final Logger mLog = LoggerFactory.getLogger(LtrFormatter.class);

    public LtrFormatter(int minimum, int maximum) {
        super((StringConverter)new LtrIntegerStringConverter(), null, (UnaryOperator)new LtrFilter(minimum, maximum));
    }

    public static class LtrIntegerStringConverter
    extends StringConverter<Integer> {
        private static final Pattern LTR_PATTERN = Pattern.compile("([01]?)(?:-(\\d{0,2})(?:-(\\d{0,3}))?)?");
        private static final int AREA_MASK = 8192;
        private static final int LCN_MASK = 7936;
        private static final int TALKGROUP_MASK = 255;

        public String toString(Integer value) {
            if (value == null) {
                return "";
            }
            int area = (value & 0x2000) >> 13;
            int lcn = (value & 0x1F00) >> 8;
            int talkgroup = value & 0xFF;
            StringBuilder sb = new StringBuilder();
            sb.append(area);
            sb.append("-");
            sb.append(String.format("%02d", lcn));
            sb.append("-");
            sb.append(String.format("%03d", talkgroup));
            return sb.toString();
        }

        public Integer fromString(String value) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            Matcher m = LTR_PATTERN.matcher(value);
            if (m.matches()) {
                int a = 0;
                int b = 0;
                int c = 0;
                try {
                    a = Integer.parseInt(m.group(1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    b = Integer.parseInt(m.group(2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    c = Integer.parseInt(m.group(3));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int talkgroup = (a << 13) + (b << 8) + c;
                return talkgroup;
            }
            return null;
        }

        public static boolean isValid(String value) {
            if (value == null || value.isEmpty()) {
                return true;
            }
            Matcher m = LTR_PATTERN.matcher(value);
            if (m.matches()) {
                String part3;
                String part2 = m.group(2);
                if (part2 != null && !part2.isEmpty()) {
                    try {
                        int value2 = Integer.parseInt(part2);
                        if (value2 < 0 || value2 > 31) {
                            return false;
                        }
                    }
                    catch (Exception value2) {
                        // empty catch block
                    }
                }
                if ((part3 = m.group(3)) != null && !part3.isEmpty()) {
                    try {
                        int value3 = Integer.parseInt(part3);
                        if (value3 < 0 || value3 > 255) {
                            return false;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return true;
            }
            return false;
        }
    }

    public static class LtrFilter
    implements UnaryOperator<TextFormatter.Change> {
        private int mMinimum;
        private int mMaximum;

        public LtrFilter(int minimum, int maximum) {
            this.mMinimum = minimum;
            this.mMaximum = maximum;
        }

        private boolean isValid(Integer value) {
            return value != null && this.mMinimum <= value && value <= this.mMaximum;
        }

        @Override
        public TextFormatter.Change apply(TextFormatter.Change change) {
            String updatedText = change.getControlNewText();
            if (updatedText == null || updatedText.isEmpty()) {
                return change;
            }
            if (LtrIntegerStringConverter.isValid(updatedText)) {
                return change;
            }
            return null;
        }
    }
}

