/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.control;

import io.github.dsheirer.source.ISourceEventProcessor;
import io.github.dsheirer.source.InvalidFrequencyException;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceException;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFrequencyControl
extends JPanel
implements ISourceEventProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(JFrequencyControl.class);
    private List<ISourceEventProcessor> mProcessors = new ArrayList<ISourceEventProcessor>();
    private Color mHighlightColor = Color.YELLOW;
    private long mFrequency;
    private HashMap<Integer, Digit> mDigits = new HashMap();

    public JFrequencyControl() {
        this.init();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[]0[]", ""));
        Font font = new Font("Monospaced", 1, 30);
        for (int x = 9; x >= 0; --x) {
            Digit digit = null;
            try {
                digit = new Digit(x);
            }
            catch (ParseException e) {
                mLog.error("JFrequencyControl - parse exception constructing a digit - " + String.valueOf(e));
            }
            if (digit == null) continue;
            this.mDigits.put(x, digit);
            this.add(digit);
            digit.setFont(font);
            if (x != 6) continue;
            this.add(new JLabel(". "));
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Digit digit : this.mDigits.values()) {
            digit.setEnabled(enabled);
        }
    }

    @Override
    public void process(SourceEvent event) {
        switch (event.getEvent()) {
            case NOTIFICATION_FREQUENCY_CHANGE: {
                EventQueue.invokeLater(() -> this.setFrequency(event.getValue().longValue(), false));
            }
        }
    }

    public void setFrequency(long frequency, boolean fireChangeEvent) {
        this.mFrequency = frequency;
        for (Digit digit : this.mDigits.values()) {
            digit.setFrequency(frequency, fireChangeEvent);
        }
    }

    public long getFrequency() {
        return this.mFrequency;
    }

    private void updateFrequency() {
        long frequency = 0L;
        for (Digit digit : this.mDigits.values()) {
            frequency += digit.getFrequency();
        }
        this.mFrequency = frequency;
    }

    private void fireSourceChanged() throws SourceException {
        this.updateFrequency();
        Iterator<ISourceEventProcessor> it = this.mProcessors.iterator();
        SourceEvent event = SourceEvent.frequencyRequest(this.mFrequency);
        while (it.hasNext()) {
            it.next().process(event);
        }
    }

    public void addListener(ISourceEventProcessor processor) {
        if (!this.mProcessors.contains(processor)) {
            this.mProcessors.add(processor);
        }
    }

    public void clearListeners() {
        this.mProcessors.clear();
    }

    public void removeListener(ISourceEventProcessor processor) {
        this.mProcessors.remove(processor);
    }

    public class Digit
    extends JTextField {
        private static final long serialVersionUID = 1L;
        private int mPower;
        private long mValue;

        private Digit(int position) throws ParseException {
            super("0");
            this.mPower = 0;
            this.mValue = 0L;
            this.mPower = position;
            this.setToolTipText(Digit.getTooltip(this.mPower));
            Listener listener = new Listener();
            this.addKeyListener(listener);
            this.addMouseListener(listener);
            this.addMouseWheelListener(listener);
        }

        private static String getTooltip(int power) {
            StringBuilder sb = new StringBuilder();
            sb.append("Center frequency ");
            switch (power) {
                case 0: {
                    sb.append("1 Hertz");
                    break;
                }
                case 1: {
                    sb.append("10 Hertz");
                    break;
                }
                case 2: {
                    sb.append("100 Hertz");
                    break;
                }
                case 3: {
                    sb.append("1 Kilohertz");
                    break;
                }
                case 4: {
                    sb.append("10 Kilohertz");
                    break;
                }
                case 5: {
                    sb.append("100 Kilohertz");
                    break;
                }
                case 6: {
                    sb.append("1 Megahertz");
                    break;
                }
                case 7: {
                    sb.append("10 Megahertz");
                    break;
                }
                case 8: {
                    sb.append("100 Megahertz");
                    break;
                }
                case 9: {
                    sb.append("1 Gigahertz");
                }
            }
            sb.append(" units.  Type a number, use up/down arrows, or click the upper/lower digit control to adjust");
            return sb.toString();
        }

        public void setFrequency(long frequency, boolean fireChangeEvent) {
            long lower = frequency % (long)FastMath.pow((double)10.0, (int)(this.mPower + 1));
            long value = lower / (long)FastMath.pow((double)10.0, (int)this.mPower);
            this.set(value, fireChangeEvent);
        }

        public long getFrequency() {
            return this.mValue * (long)FastMath.pow((double)10.0, (int)this.mPower);
        }

        public void increment() {
            this.increment(true);
        }

        public void increment(boolean fireChangeEvent) {
            if (this.isEnabled()) {
                this.set(this.mValue + 1L, fireChangeEvent);
            }
        }

        public void decrement() {
            this.decrement(true);
        }

        public void decrement(boolean fireChangeEvent) {
            if (this.isEnabled()) {
                this.set(this.mValue - 1L, fireChangeEvent);
            }
        }

        private void set(long amount) {
            this.set(amount, true);
        }

        private void set(long amount, boolean fireChangeEvent) {
            block7: {
                Digit nextHigherDigit;
                long previous = this.mValue;
                boolean higherDigitIncremented = false;
                boolean higherDigitDecremented = false;
                this.mValue = amount;
                while (this.mValue < 0L) {
                    this.mValue += 10L;
                    nextHigherDigit = JFrequencyControl.this.mDigits.get(this.mPower + 1);
                    if (nextHigherDigit == null) continue;
                    nextHigherDigit.decrement(false);
                    higherDigitDecremented = true;
                }
                while (this.mValue > 9L) {
                    this.mValue -= 10L;
                    nextHigherDigit = JFrequencyControl.this.mDigits.get(this.mPower + 1);
                    if (nextHigherDigit == null) continue;
                    nextHigherDigit.increment(false);
                    higherDigitIncremented = true;
                }
                if (fireChangeEvent) {
                    try {
                        JFrequencyControl.this.fireSourceChanged();
                    }
                    catch (SourceException se) {
                        Digit nextHigherDigit2;
                        this.mValue = previous;
                        if (higherDigitIncremented && (nextHigherDigit2 = JFrequencyControl.this.mDigits.get(this.mPower + 1)) != null) {
                            nextHigherDigit2.decrement(false);
                        }
                        if (higherDigitDecremented && (nextHigherDigit2 = JFrequencyControl.this.mDigits.get(this.mPower + 1)) != null) {
                            nextHigherDigit2.increment(false);
                        }
                        if (!(se instanceof InvalidFrequencyException)) break block7;
                        InvalidFrequencyException ife = (InvalidFrequencyException)se;
                        JOptionPane.showMessageDialog(this, "Frequency [" + ife.getInvalidFrequency() + "] exceeds the frequency limit [" + ife.getValidFrequency() + "] for this tuner.");
                    }
                }
            }
            this.setText(String.valueOf(this.mValue));
            this.repaint();
        }

        private class Listener
        implements KeyListener,
        MouseListener,
        MouseWheelListener {
            private Listener() {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 48: 
                    case 96: {
                        Digit.this.set(0L);
                        Digit.this.transferFocus();
                        break;
                    }
                    case 49: 
                    case 97: {
                        Digit.this.set(1L);
                        Digit.this.transferFocus();
                        break;
                    }
                    case 50: 
                    case 98: {
                        Digit.this.set(2L);
                        Digit.this.transferFocus();
                        break;
                    }
                    case 51: 
                    case 99: {
                        Digit.this.set(3L);
                        Digit.this.transferFocus();
                        break;
                    }
                    case 52: 
                    case 100: {
                        Digit.this.set(4L);
                        Digit.this.transferFocus();
                        break;
                    }
                    case 53: 
                    case 101: {
                        Digit.this.set(5L);
                        Digit.this.transferFocus();
                        break;
                    }
                    case 54: 
                    case 102: {
                        Digit.this.set(6L);
                        Digit.this.transferFocus();
                        break;
                    }
                    case 55: 
                    case 103: {
                        Digit.this.set(7L);
                        Digit.this.transferFocus();
                        break;
                    }
                    case 56: 
                    case 104: {
                        Digit.this.set(8L);
                        Digit.this.transferFocus();
                        break;
                    }
                    case 57: 
                    case 105: {
                        Digit.this.set(9L);
                        Digit.this.transferFocus();
                        break;
                    }
                    case 37: {
                        Digit.this.transferFocusBackward();
                        break;
                    }
                    case 39: {
                        Digit.this.transferFocus();
                        break;
                    }
                    case 38: {
                        Digit.this.increment();
                        break;
                    }
                    case 40: {
                        Digit.this.decrement();
                        break;
                    }
                    case 9: {
                        break;
                    }
                    default: {
                        Digit.this.set(Digit.this.mValue);
                    }
                }
                Digit.this.repaint();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                switch (e.getButton()) {
                    case 1: {
                        Digit.this.increment();
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        Digit.this.decrement();
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Digit.this.setBackground(JFrequencyControl.this.mHighlightColor);
                Digit.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Digit.this.setBackground(Color.WHITE);
                Digit.this.repaint();
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Digit.this.set(Digit.this.mValue - (long)e.getWheelRotation());
            }
        }
    }
}

