/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.control;

import java.util.function.UnaryOperator;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;

public class IntegerTextField
extends TextField {
    private static final String REGEX = "[1-9][0-9]*";

    public IntegerTextField() {
        UnaryOperator filter = change -> {
            String newText = change.getControlNewText();
            if (newText.isEmpty() || newText.matches(REGEX)) {
                return change;
            }
            return null;
        };
        this.setTextFormatter(new TextFormatter((StringConverter)new IntegerStringConverter(), null, filter));
    }

    public Integer get() {
        String rawText = this.getText();
        try {
            return Integer.parseInt(rawText);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void set(int value) {
        this.setText(String.valueOf(value));
    }
}

