/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.control;

import java.util.function.UnaryOperator;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexFormatter
extends TextFormatter<Integer> {
    private static final Logger mLog = LoggerFactory.getLogger(HexFormatter.class);

    public HexFormatter(int minimum, int maximum) {
        super((StringConverter)new HexIntegerStringConverter(), null, (UnaryOperator)new HexFilter(minimum, maximum));
    }

    public static class HexIntegerStringConverter
    extends StringConverter<Integer> {
        public String toString(Integer value) {
            if (value == null) {
                return "";
            }
            return Integer.toHexString(value).toUpperCase();
        }

        public Integer fromString(String value) {
            return HexIntegerStringConverter.getValue(value);
        }

        public static Integer getValue(String value) {
            if (value == null) {
                return null;
            }
            if ((value = value.trim()).length() < 1) {
                return null;
            }
            return Integer.valueOf(value, 16);
        }
    }

    public static class HexFilter
    implements UnaryOperator<TextFormatter.Change> {
        private String HEXADECIMAL_REGEX = "[0-9A-Fa-f].*";
        private int mMinimum;
        private int mMaximum;

        public HexFilter(int minimum, int maximum) {
            this.mMinimum = minimum;
            this.mMaximum = maximum;
        }

        private boolean isValid(Integer value) {
            return value != null && this.mMinimum <= value && value <= this.mMaximum;
        }

        @Override
        public TextFormatter.Change apply(TextFormatter.Change change) {
            if (change.getText() != null) {
                String updatedText = change.getControlNewText();
                if (updatedText == null || updatedText.isEmpty()) {
                    return change;
                }
                if (!updatedText.matches(this.HEXADECIMAL_REGEX) || !this.isValid(HexIntegerStringConverter.getValue(change.getControlNewText()))) {
                    return null;
                }
                if (change.getText().matches("[a-f].*")) {
                    change.setText(change.getText().toUpperCase());
                }
            }
            return change;
        }
    }
}

