/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.channelizer;

import io.github.dsheirer.buffer.FloatNativeBuffer;
import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.dsp.filter.channelizer.PolyphaseChannelSource;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.settings.SettingsManager;
import io.github.dsheirer.source.ISourceEventProcessor;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.LoggingTunerErrorListener;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.channel.ChannelSpecification;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import io.github.dsheirer.source.tuner.channel.TunerChannelSource;
import io.github.dsheirer.source.tuner.test.TestTuner;
import io.github.dsheirer.spectrum.ComplexDftProcessor;
import io.github.dsheirer.spectrum.DFTSize;
import io.github.dsheirer.spectrum.SpectrumPanel;
import io.github.dsheirer.spectrum.converter.ComplexDecibelConverter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelizerViewer2
extends JFrame {
    private static final Logger mLog = LoggerFactory.getLogger(ChannelizerViewer2.class);
    private static final int CHANNEL_BANDWIDTH = 12500;
    private SettingsManager mSettingsManager = new SettingsManager();
    private JPanel mPrimaryPanel;
    private JPanel mControlPanel;
    private JButton mTopFrameAddChannelButton;
    private JButton mBottomFrameAddChannelButton;
    private JLabel mToneFrequencyLabel;
    private JLabel mCenterFrequencyLabel;
    private PrimarySpectrumPanel mPrimarySpectrumPanel;
    private ChannelArrayPanel mTopChannelArrayPanel;
    private ChannelArrayPanel mBottomChannelArrayPanel;
    private DFTSize mMainPanelDFTSize = DFTSize.FFT32768;
    private DFTSize mChannelPanelDFTSize = DFTSize.FFT04096;
    private TestTuner mTestTuner = new TestTuner(new LoggingTunerErrorListener());

    public ChannelizerViewer2() {
        this.init();
    }

    private void init() {
        this.setTitle("Polyphase Channelizer Viewer");
        this.setSize(1200, 700);
        this.setDefaultCloseOperation(3);
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[grow,fill]"));
        this.setLocationRelativeTo(null);
        this.add(this.getPrimaryPanel());
    }

    private JPanel getPrimaryPanel() {
        if (this.mPrimaryPanel == null) {
            this.mPrimaryPanel = new JPanel();
            this.mPrimaryPanel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[][][grow,fill][grow,fill]"));
            this.mPrimaryPanel.add((Component)this.getSpectrumPanel(), "wrap");
            this.mPrimaryPanel.add((Component)this.getControlPanel(), "wrap");
            this.mPrimaryPanel.add((Component)this.getTopChannelArrayPanel(), "wrap");
            this.mPrimaryPanel.add(this.getBottomChannelArrayPanel());
        }
        return this.mPrimaryPanel;
    }

    private PrimarySpectrumPanel getSpectrumPanel() {
        if (this.mPrimarySpectrumPanel == null) {
            this.mPrimarySpectrumPanel = new PrimarySpectrumPanel(this.mSettingsManager, this.mTestTuner.getTunerController().getSampleRate());
            this.mPrimarySpectrumPanel.setPreferredSize(new Dimension(1200, 200));
            this.mPrimarySpectrumPanel.setDFTSize(this.mMainPanelDFTSize);
            this.mTestTuner.getTunerController().addBufferListener(this.mPrimarySpectrumPanel);
        }
        return this.mPrimarySpectrumPanel;
    }

    private JPanel getControlPanel() {
        if (this.mControlPanel == null) {
            this.mControlPanel = new JPanel();
            this.mControlPanel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "", ""));
            this.mControlPanel.add((Component)new JLabel("Tone:"), "align left");
            long minimumFrequency = -((long)this.mTestTuner.getTunerController().getSampleRate()) / 2L + 1L;
            long maximumFrequency = (long)this.mTestTuner.getTunerController().getSampleRate() / 2L - 1L;
            long toneFrequency = 0L;
            final SpinnerNumberModel model = new SpinnerNumberModel(toneFrequency, minimumFrequency, maximumFrequency, 100.0);
            model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    long toneFrequency = model.getNumber().longValue();
                    ChannelizerViewer2.this.mTestTuner.getTunerController().setToneFrequency(toneFrequency);
                    ChannelizerViewer2.this.mToneFrequencyLabel.setText(String.valueOf(ChannelizerViewer2.this.getToneFrequency()));
                    ChannelizerViewer2.this.mCenterFrequencyLabel.setText(String.valueOf(ChannelizerViewer2.this.getCenterFrequency()));
                }
            });
            JSpinner spinner = new JSpinner(model);
            this.mControlPanel.add(spinner);
            this.mControlPanel.add(new JLabel("Hz"));
            this.mControlPanel.add((Component)new JLabel("Tone Frequency:"), "push,align right");
            this.mToneFrequencyLabel = new JLabel(String.valueOf(this.getToneFrequency()));
            this.mControlPanel.add((Component)this.mToneFrequencyLabel, "push,align left");
            this.mControlPanel.add((Component)new JLabel("Center Frequency:"), "push,align right");
            this.mCenterFrequencyLabel = new JLabel(String.valueOf(this.getCenterFrequency()));
            this.mControlPanel.add((Component)this.mCenterFrequencyLabel, "push,align left");
            this.mControlPanel.add((Component)this.getBottomFrameAddChannelButton(), "push,align right");
            this.mControlPanel.add((Component)this.getTopFrameAddChannelButton(), "push,align right");
        }
        return this.mControlPanel;
    }

    private JButton getTopFrameAddChannelButton() {
        if (this.mTopFrameAddChannelButton == null) {
            this.mTopFrameAddChannelButton = new JButton("Top - Add Channel");
            this.mTopFrameAddChannelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String value = JOptionPane.showInputDialog(ChannelizerViewer2.this, (Object)"Frequency?");
                    if (value != null && !value.isEmpty()) {
                        try {
                            int frequency = Integer.parseInt(value);
                            TunerChannel tunerChannel = new TunerChannel(frequency, 12500);
                            ChannelizerViewer2.this.getTopChannelArrayPanel().addChannel(tunerChannel);
                        }
                        catch (Exception e1) {
                            mLog.error("Can't parse frequency from value: " + value, (Throwable)e1);
                        }
                    }
                }
            });
        }
        return this.mTopFrameAddChannelButton;
    }

    private JButton getBottomFrameAddChannelButton() {
        if (this.mBottomFrameAddChannelButton == null) {
            this.mBottomFrameAddChannelButton = new JButton("Bottom - Add Channel");
            this.mBottomFrameAddChannelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String value = JOptionPane.showInputDialog(ChannelizerViewer2.this, (Object)"Frequency?");
                    if (value != null && !value.isEmpty()) {
                        try {
                            int frequency = Integer.parseInt(value);
                            TunerChannel tunerChannel = new TunerChannel(frequency, 12500);
                            ChannelizerViewer2.this.getBottomChannelArrayPanel().addChannel(tunerChannel);
                        }
                        catch (Exception e1) {
                            mLog.error("Can't parse frequency from value: " + value, (Throwable)e1);
                        }
                    }
                }
            });
        }
        return this.mBottomFrameAddChannelButton;
    }

    private long getToneFrequency() {
        return this.mTestTuner.getTunerController().getFrequency() + this.mTestTuner.getTunerController().getToneFrequency();
    }

    private long getCenterFrequency() {
        return this.mTestTuner.getTunerController().getFrequency();
    }

    private ChannelArrayPanel getTopChannelArrayPanel() {
        if (this.mTopChannelArrayPanel == null) {
            this.mTopChannelArrayPanel = new ChannelArrayPanel();
        }
        return this.mTopChannelArrayPanel;
    }

    private ChannelArrayPanel getBottomChannelArrayPanel() {
        if (this.mBottomChannelArrayPanel == null) {
            this.mBottomChannelArrayPanel = new ChannelArrayPanel();
        }
        return this.mBottomChannelArrayPanel;
    }

    public static List<TunerChannel> getTunerChannels(Tuner tuner) {
        ArrayList<TunerChannel> tunerChannels = new ArrayList<TunerChannel>();
        long baseFrequency = tuner.getTunerController().getFrequency();
        baseFrequency = (long)((double)baseFrequency - tuner.getTunerController().getSampleRate() / 2.0);
        baseFrequency += 6250L;
        int channelCount = (int)(tuner.getTunerController().getSampleRate() / 12500.0) - 1;
        for (int x = 0; x < channelCount; ++x) {
            long frequency = baseFrequency + (long)(x * 12500);
            TunerChannel tunerChannel = new TunerChannel(frequency, 12500);
            tunerChannels.add(tunerChannel);
        }
        return tunerChannels;
    }

    public static void main(String[] args) {
        final ChannelizerViewer2 frame = new ChannelizerViewer2();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
    }

    public class PrimarySpectrumPanel
    extends JPanel
    implements Listener<INativeBuffer>,
    ISourceEventProcessor {
        private ComplexDftProcessor mComplexDftProcessor = new ComplexDftProcessor();
        private ComplexDecibelConverter mComplexDecibelConverter = new ComplexDecibelConverter();
        private SpectrumPanel mSpectrumPanel;

        public PrimarySpectrumPanel(SettingsManager settingsManager, double sampleRate) {
            this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[grow,fill]"));
            this.mSpectrumPanel = new SpectrumPanel(settingsManager);
            this.mSpectrumPanel.setSampleSize(16.0);
            this.add(this.mSpectrumPanel);
            this.mComplexDftProcessor.addConverter(this.mComplexDecibelConverter);
            this.mComplexDecibelConverter.addListener(this.mSpectrumPanel);
        }

        public void setDFTSize(DFTSize dftSize) {
            this.mComplexDftProcessor.setDFTSize(dftSize);
        }

        @Override
        public void receive(INativeBuffer nativeBuffer) {
            this.mComplexDftProcessor.receive(nativeBuffer);
        }

        @Override
        public void process(SourceEvent event) throws SourceException {
            mLog.debug("Source Event!  Add handler support for this to channelizer viewer");
        }
    }

    public class ChannelArrayPanel
    extends JPanel {
        public ChannelArrayPanel() {
            this.init();
        }

        private void init() {
            this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "fill", "fill"));
        }

        public void addChannel(TunerChannel tunerChannel) {
            ChannelPanel channelPanel = new ChannelPanel(ChannelizerViewer2.this.mSettingsManager, 25000.0, tunerChannel.getFrequency(), 12500);
            channelPanel.setDFTSize(ChannelizerViewer2.this.mChannelPanelDFTSize);
            this.add((Component)channelPanel, "grow,push");
            this.validate();
            this.repaint();
        }
    }

    public class ChannelPanel
    extends JPanel
    implements Listener<INativeBuffer>,
    ISourceEventProcessor {
        private TunerChannelSource mSource;
        private ComplexDftProcessor mComplexDftProcessor = new ComplexDftProcessor();
        private ComplexDecibelConverter mComplexDecibelConverter = new ComplexDecibelConverter();
        private SpectrumPanel mSpectrumPanel;
        private JToggleButton mLoggingButton;
        private boolean mLoggingEnabled;

        public ChannelPanel(SettingsManager settingsManager, double sampleRate, long frequency, int bandwidth) {
            this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill][grow,fill][grow,fill]", "[grow,fill][]"));
            this.mSpectrumPanel = new SpectrumPanel(settingsManager);
            this.mSpectrumPanel.setSampleSize(16.0);
            this.add((Component)this.mSpectrumPanel, "span");
            this.mComplexDftProcessor.addConverter(this.mComplexDecibelConverter);
            this.mComplexDecibelConverter.addListener(this.mSpectrumPanel);
            TunerChannel tunerChannel = new TunerChannel(frequency, bandwidth);
            this.mSource = ChannelizerViewer2.this.mTestTuner.getChannelSourceManager().getSource(tunerChannel, new ChannelSpecification(50000.0, 12500, 6000.0, 7000.0));
            if (this.mSource != null) {
                mLog.debug("Channel: " + String.valueOf(this.mSource.getTunerChannel()) + " Rate:" + this.mSource.getSampleRate());
                this.mSource.setListener(complexSamples -> this.mComplexDftProcessor.receive(new FloatNativeBuffer(complexSamples.toInterleaved())));
                TunerChannelSource tunerChannelSource = this.mSource;
                if (tunerChannelSource instanceof PolyphaseChannelSource) {
                    PolyphaseChannelSource pcs = (PolyphaseChannelSource)tunerChannelSource;
                    List<Integer> indexes = pcs.getOutputProcessorIndexes();
                    double sRate = pcs.getSampleRate();
                    long indexCenterFrequency = pcs.getIndexCenterFrequency();
                    long appliedFrequencyOffset = pcs.getFrequencyOffset();
                    long requestedCenterFrequency = pcs.getFrequency();
                    StringBuilder sb = new StringBuilder();
                    sb.append("Polyphase Channel - Bandwidth: ").append(sRate);
                    sb.append(" Channel/Requested/Offset: ").append(indexCenterFrequency);
                    sb.append("/").append(requestedCenterFrequency);
                    sb.append("/").append(appliedFrequencyOffset);
                    sb.append(" Indexes: ").append(indexes);
                    sb.append(" Tuner SR:").append(pcs.getTunerSampleRate());
                    sb.append(" Tuner CF:").append(pcs.getTunerCenterFrequency());
                    mLog.info(sb.toString());
                }
                this.mSource.start();
            } else {
                mLog.error("Couldn't get a source from the tuner for frequency: " + frequency);
            }
            if (this.mSource != null) {
                int half = (int)(sampleRate / 2.0);
                this.add((Component)new JLabel("Min:" + (frequency - (long)half)), "align left");
                this.add(new JLabel("Center:" + frequency));
                this.add((Component)new JLabel("Max:" + (frequency + (long)half)), "align right");
            } else {
                this.add(new JLabel("NO SRC:" + frequency));
            }
            this.mLoggingButton = new JToggleButton("Logging");
            this.mLoggingButton.addActionListener(e -> {
                this.mLoggingEnabled = this.mLoggingButton.isSelected();
            });
        }

        public TunerChannelSource getSource() {
            return this.mSource;
        }

        public void setDFTSize(DFTSize dftSize) {
            this.mComplexDftProcessor.setDFTSize(dftSize);
        }

        @Override
        public void receive(INativeBuffer nativeBuffer) {
            this.mComplexDftProcessor.receive(nativeBuffer);
        }

        @Override
        public void process(SourceEvent event) throws SourceException {
            mLog.debug("Source Event!  Add handler support for this to channelizer viewer");
        }
    }
}

