/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui.channelizer;

import io.github.dsheirer.buffer.FloatNativeBuffer;
import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.settings.SettingsManager;
import io.github.dsheirer.source.ISourceEventProcessor;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.LoggingTunerErrorListener;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import io.github.dsheirer.source.tuner.channel.TunerChannelSource;
import io.github.dsheirer.source.tuner.test.TestTuner;
import io.github.dsheirer.spectrum.ComplexDftProcessor;
import io.github.dsheirer.spectrum.DFTSize;
import io.github.dsheirer.spectrum.SpectrumPanel;
import io.github.dsheirer.spectrum.converter.ComplexDecibelConverter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelizerViewer
extends JFrame {
    private static final Logger mLog = LoggerFactory.getLogger(ChannelizerViewer.class);
    private static final int CHANNEL_BANDWIDTH = 12500;
    private static final int CHANNEL_FFT_FRAME_RATE = 20;
    private SettingsManager mSettingsManager = new SettingsManager();
    private JPanel mPrimaryPanel;
    private JPanel mControlPanel;
    private JLabel mToneFrequencyLabel;
    private PrimarySpectrumPanel mPrimarySpectrumPanel;
    private ChannelArrayPanel mChannelPanel;
    private DiscreteIndexChannelArrayPanel mDiscreteIndexChannelPanel;
    private int mChannelCount;
    private int mChannelsPerRow;
    private long mBaseFrequency = 100000000L;
    private DFTSize mMainPanelDFTSize = DFTSize.FFT32768;
    private DFTSize mChannelPanelDFTSize = DFTSize.FFT04096;
    private TestTuner mTestTuner = new TestTuner(new LoggingTunerErrorListener());

    public ChannelizerViewer(int channelsPerRow) {
        this.mChannelCount = this.mTestTuner.getTunerController().getBandwidth() / 12500;
        this.mChannelsPerRow = channelsPerRow;
        this.init();
    }

    private void init() {
        this.setTitle("Polyphase Channelizer Viewer");
        this.setSize(1200, 800);
        this.setDefaultCloseOperation(3);
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[grow,fill]"));
        this.setLocationRelativeTo(null);
        this.add(this.getPrimaryPanel());
    }

    private JPanel getPrimaryPanel() {
        if (this.mPrimaryPanel == null) {
            this.mPrimaryPanel = new JPanel();
            this.mPrimaryPanel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[][][grow,fill][grow,fill]"));
            this.mPrimaryPanel.add((Component)this.getSpectrumPanel(), "wrap");
            this.mPrimaryPanel.add((Component)this.getControlPanel(), "wrap");
            this.mPrimaryPanel.add((Component)this.getChannelArrayPanel(), "wrap");
            this.mPrimaryPanel.add(this.getDiscreteIndexChannelPanel());
        }
        return this.mPrimaryPanel;
    }

    private PrimarySpectrumPanel getSpectrumPanel() {
        if (this.mPrimarySpectrumPanel == null) {
            this.mPrimarySpectrumPanel = new PrimarySpectrumPanel(this.mSettingsManager, this.mTestTuner.getTunerController().getSampleRate());
            this.mPrimarySpectrumPanel.setPreferredSize(new Dimension(1200, 200));
            this.mPrimarySpectrumPanel.setDFTSize(this.mMainPanelDFTSize);
            this.mTestTuner.getTunerController().addBufferListener(this.mPrimarySpectrumPanel);
        }
        return this.mPrimarySpectrumPanel;
    }

    private JPanel getControlPanel() {
        if (this.mControlPanel == null) {
            this.mControlPanel = new JPanel();
            this.mControlPanel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "", ""));
            this.mControlPanel.add((Component)new JLabel("Tone:"), "align left");
            long minimumFrequency = -((long)this.mTestTuner.getTunerController().getSampleRate()) / 2L + 1L;
            long maximumFrequency = (long)this.mTestTuner.getTunerController().getSampleRate() / 2L - 1L;
            long toneFrequency = 0L;
            final SpinnerNumberModel model = new SpinnerNumberModel(toneFrequency, minimumFrequency, maximumFrequency, 100.0);
            model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    long toneFrequency = model.getNumber().longValue();
                    ChannelizerViewer.this.mTestTuner.getTunerController().setToneFrequency(toneFrequency);
                    ChannelizerViewer.this.mToneFrequencyLabel.setText(String.valueOf(ChannelizerViewer.this.getToneFrequency()));
                }
            });
            JSpinner spinner = new JSpinner(model);
            this.mControlPanel.add(spinner);
            this.mControlPanel.add(new JLabel("Hz"));
            this.mControlPanel.add((Component)new JLabel("Frequency:"), "push,align right");
            this.mToneFrequencyLabel = new JLabel(String.valueOf(this.getToneFrequency()));
            this.mControlPanel.add((Component)this.mToneFrequencyLabel, "push,align left");
            this.mControlPanel.add((Component)new JLabel("Channels: " + this.mChannelCount), "push,align right");
        }
        return this.mControlPanel;
    }

    private long getToneFrequency() {
        return this.mTestTuner.getTunerController().getFrequency() + this.mTestTuner.getTunerController().getToneFrequency();
    }

    private ChannelArrayPanel getChannelArrayPanel() {
        if (this.mChannelPanel == null) {
            this.mChannelPanel = new ChannelArrayPanel();
        }
        return this.mChannelPanel;
    }

    private DiscreteIndexChannelArrayPanel getDiscreteIndexChannelPanel() {
        if (this.mDiscreteIndexChannelPanel == null) {
            this.mDiscreteIndexChannelPanel = new DiscreteIndexChannelArrayPanel();
        }
        return this.mDiscreteIndexChannelPanel;
    }

    public static List<TunerChannel> getTunerChannels(Tuner tuner) {
        ArrayList<TunerChannel> tunerChannels = new ArrayList<TunerChannel>();
        long baseFrequency = tuner.getTunerController().getFrequency();
        baseFrequency = (long)((double)baseFrequency - tuner.getTunerController().getSampleRate() / 2.0);
        baseFrequency += 6250L;
        int channelCount = (int)(tuner.getTunerController().getSampleRate() / 12500.0) - 1;
        for (int x = 0; x < channelCount; ++x) {
            long frequency = baseFrequency + (long)(x * 12500);
            TunerChannel tunerChannel = new TunerChannel(frequency, 12500);
            tunerChannels.add(tunerChannel);
        }
        return tunerChannels;
    }

    public static void main(String[] args) {
        boolean useGUI = true;
        if (!useGUI) {
            TestTuner tuner = new TestTuner(new LoggingTunerErrorListener());
            List<TunerChannel> tunerChannels = ChannelizerViewer.getTunerChannels(tuner);
            ArrayList<TunerChannelSource> sources = new ArrayList<TunerChannelSource>();
            int maxSourceCount = 30;
            int sourceCount = 0;
            for (TunerChannel tunerChannel : tunerChannels) {
                if (sourceCount >= maxSourceCount) continue;
                TunerChannelSource source = tuner.getChannelSourceManager().getSource(tunerChannel, null);
                if (source != null) {
                    sources.add(source);
                    ++sourceCount;
                    continue;
                }
                mLog.debug("Couldn't get source for: " + String.valueOf(tunerChannel));
            }
            mLog.debug("Starting [" + sources.size() + "] tuner channel sources");
            for (TunerChannelSource tunerChannelSource : sources) {
                tunerChannelSource.setListener(new Listener<ComplexSamples>(){

                    @Override
                    public void receive(ComplexSamples complexSamples) {
                    }
                });
                tunerChannelSource.start();
            }
            while (true) {
                // Infinite loop
            }
        }
        int channelsPerRow = 16;
        final ChannelizerViewer frame = new ChannelizerViewer(channelsPerRow);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
    }

    public class PrimarySpectrumPanel
    extends JPanel
    implements Listener<INativeBuffer>,
    ISourceEventProcessor {
        private ComplexDftProcessor mComplexDftProcessor = new ComplexDftProcessor();
        private ComplexDecibelConverter mComplexDecibelConverter = new ComplexDecibelConverter();
        private SpectrumPanel mSpectrumPanel;

        public PrimarySpectrumPanel(SettingsManager settingsManager, double sampleRate) {
            this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[grow,fill]"));
            this.mSpectrumPanel = new SpectrumPanel(settingsManager);
            this.mSpectrumPanel.setSampleSize(28.0);
            this.add(this.mSpectrumPanel);
            this.mComplexDftProcessor.addConverter(this.mComplexDecibelConverter);
            this.mComplexDecibelConverter.addListener(this.mSpectrumPanel);
        }

        public void setDFTSize(DFTSize dftSize) {
            this.mComplexDftProcessor.setDFTSize(dftSize);
        }

        @Override
        public void receive(INativeBuffer nativeBuffer) {
            this.mComplexDftProcessor.receive(nativeBuffer);
        }

        @Override
        public void process(SourceEvent event) throws SourceException {
            mLog.debug("Source Event!  Add handler support for this to channelizer viewer");
        }
    }

    public class ChannelArrayPanel
    extends JPanel {
        private final Logger mLog = LoggerFactory.getLogger(ChannelArrayPanel.class);

        public ChannelArrayPanel() {
            int bufferSize = 625;
            if (bufferSize % 2 == 1) {
                ++bufferSize;
            }
            this.init();
        }

        private void init() {
            this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "fill", "fill"));
            double spectralBandwidth = ChannelizerViewer.this.mTestTuner.getTunerController().getSampleRate();
            double halfSpectralBandwidth = spectralBandwidth / 2.0;
            int channelToLog = -1;
            long baseFrequency = ChannelizerViewer.this.mBaseFrequency + 6250L;
            for (int x = 0; x < ChannelizerViewer.this.mChannelCount; ++x) {
                long frequency = baseFrequency + (long)(x * 12500);
                this.mLog.debug("Channel " + x + "/" + ChannelizerViewer.this.mChannelCount + " Frequency: " + frequency);
                ChannelPanel channelPanel = new ChannelPanel(ChannelizerViewer.this.mSettingsManager, 25000.0, frequency, 12500, x == channelToLog);
                channelPanel.setDFTSize(ChannelizerViewer.this.mChannelPanelDFTSize);
                if (x % ChannelizerViewer.this.mChannelsPerRow == ChannelizerViewer.this.mChannelsPerRow - 1) {
                    this.add((Component)channelPanel, "grow,push,wrap 2px");
                    continue;
                }
                this.add((Component)channelPanel, "grow,push");
            }
        }
    }

    public class DiscreteIndexChannelArrayPanel
    extends JPanel {
        public DiscreteIndexChannelArrayPanel() {
            int bufferSize = 625;
            if (bufferSize % 2 == 1) {
                ++bufferSize;
            }
            this.init();
        }

        private void init() {
            this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "fill", "fill"));
            for (int x = 0; x < ChannelizerViewer.this.mChannelCount; ++x) {
                TunerChannel tunerChannel = new TunerChannel(100000000L, 12500);
                TunerChannelSource source = ChannelizerViewer.this.mTestTuner.getChannelSourceManager().getSource(tunerChannel, null);
                DiscreteChannelPanel channelPanel = new DiscreteChannelPanel(ChannelizerViewer.this.mSettingsManager, source, x);
                channelPanel.setDFTSize(ChannelizerViewer.this.mChannelPanelDFTSize);
                mLog.debug("Testing Channel [" + x + "] is set to [" + source.getTunerChannel().getFrequency() + "]");
                if (x % ChannelizerViewer.this.mChannelsPerRow == ChannelizerViewer.this.mChannelsPerRow - 1) {
                    this.add((Component)channelPanel, "grow,push,wrap 2px");
                    continue;
                }
                this.add((Component)channelPanel, "grow,push");
            }
        }
    }

    public class DiscreteChannelPanel
    extends JPanel
    implements Listener<ComplexSamples>,
    ISourceEventProcessor {
        private final Logger mLog = LoggerFactory.getLogger(DiscreteChannelPanel.class);
        private TunerChannelSource mSource;
        private ComplexDftProcessor mComplexDftProcessor = new ComplexDftProcessor();
        private ComplexDecibelConverter mComplexDecibelConverter = new ComplexDecibelConverter();
        private SpectrumPanel mSpectrumPanel;
        private JToggleButton mLoggingButton;
        private boolean mLoggingEnabled;

        public DiscreteChannelPanel(SettingsManager settingsManager, TunerChannelSource source, int index) {
            this.mSource = source;
            this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[center,grow,fill][]", "[grow,fill][]"));
            this.mSpectrumPanel = new SpectrumPanel(settingsManager);
            this.mSpectrumPanel.setSampleSize(32.0);
            this.add((Component)this.mSpectrumPanel, "span");
            this.add(new JLabel("Index:" + index));
            this.mLoggingButton = new JToggleButton("Logging");
            this.mLoggingButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DiscreteChannelPanel.this.mLoggingEnabled = DiscreteChannelPanel.this.mLoggingButton.isSelected();
                }
            });
            this.mComplexDftProcessor.addConverter(this.mComplexDecibelConverter);
            this.mComplexDecibelConverter.addListener(this.mSpectrumPanel);
            if (this.mSource != null) {
                this.mSource.setListener(new Listener<ComplexSamples>(){

                    @Override
                    public void receive(ComplexSamples complexSamples) {
                        if (DiscreteChannelPanel.this.mLoggingEnabled) {
                            DiscreteChannelPanel.this.mLog.debug("Samples:" + Arrays.toString(complexSamples.toInterleaved().samples()));
                        }
                        DiscreteChannelPanel.this.mComplexDftProcessor.receive(new FloatNativeBuffer(complexSamples.toInterleaved()));
                    }
                });
                this.mSource.start();
            } else {
                this.mLog.error("Couldn't get a source from the tuner for index: " + index);
            }
        }

        public TunerChannelSource getSource() {
            return this.mSource;
        }

        public void setDFTSize(DFTSize dftSize) {
            this.mComplexDftProcessor.setDFTSize(dftSize);
        }

        @Override
        public void receive(ComplexSamples complexSamples) {
            this.mComplexDftProcessor.receive(new FloatNativeBuffer(complexSamples.toInterleaved()));
        }

        @Override
        public void process(SourceEvent event) throws SourceException {
            this.mLog.debug("Source Event!  Add handler support for this to channelizer viewer");
        }
    }

    public class ChannelPanel
    extends JPanel
    implements Listener<ComplexSamples>,
    ISourceEventProcessor {
        private TunerChannelSource mSource;
        private ComplexDftProcessor mComplexDftProcessor = new ComplexDftProcessor();
        private ComplexDecibelConverter mComplexDecibelConverter = new ComplexDecibelConverter();
        private SpectrumPanel mSpectrumPanel;
        private JToggleButton mLoggingButton;
        private boolean mLoggingEnabled;

        public ChannelPanel(SettingsManager settingsManager, double sampleRate, long frequency, int bandwidth, boolean enableLogging) {
            this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[center,grow,fill][]", "[grow,fill][]"));
            this.mSpectrumPanel = new SpectrumPanel(settingsManager);
            this.mSpectrumPanel.setSampleSize(32.0);
            this.add((Component)this.mSpectrumPanel, "span");
            this.mComplexDftProcessor.addConverter(this.mComplexDecibelConverter);
            this.mComplexDecibelConverter.addListener(this.mSpectrumPanel);
            TunerChannel tunerChannel = new TunerChannel(frequency, bandwidth);
            this.mSource = ChannelizerViewer.this.mTestTuner.getChannelSourceManager().getSource(tunerChannel, null);
            if (this.mSource != null) {
                this.mSource.setListener(complexSamples -> this.mComplexDftProcessor.receive(new FloatNativeBuffer(complexSamples.toInterleaved())));
                this.mSource.start();
            } else {
                mLog.error("Couldn't get a source from the tuner for frequency: " + frequency);
            }
            if (this.mSource != null) {
                this.add(new JLabel("Center:" + frequency));
            } else {
                this.add(new JLabel("NO SRC:" + frequency));
            }
            this.mLoggingButton = new JToggleButton("Logging");
            this.mLoggingButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChannelPanel.this.mLoggingEnabled = ChannelPanel.this.mLoggingButton.isSelected();
                }
            });
        }

        public TunerChannelSource getSource() {
            return this.mSource;
        }

        public void setDFTSize(DFTSize dftSize) {
            this.mComplexDftProcessor.setDFTSize(dftSize);
        }

        @Override
        public void receive(ComplexSamples complexSamples) {
            this.mComplexDftProcessor.receive(new FloatNativeBuffer(complexSamples.toInterleaved()));
        }

        @Override
        public void process(SourceEvent event) throws SourceException {
            mLog.debug("Source Event!  Add handler support for this to channelizer viewer");
        }
    }
}

