/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.gui;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelEvent;
import io.github.dsheirer.controller.channel.ChannelEventListener;
import java.text.NumberFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelMemoryLogger
implements Runnable,
ChannelEventListener {
    private static final Logger mLog = LoggerFactory.getLogger(ChannelMemoryLogger.class);
    public int mChannelCount;
    public int mChannelProcessingCount;
    public int mTrafficChannelCount;

    @Override
    public void run() {
        Runtime runtime = Runtime.getRuntime();
        NumberFormat format = NumberFormat.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append("CHAN TOT:").append(this.mChannelCount);
        sb.append(" TRFC:").append(this.mTrafficChannelCount);
        sb.append(" PROC:").append(this.mChannelProcessingCount);
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        sb.append(" MEM FREE: ").append(format.format(freeMemory / 1024L));
        sb.append(" ALLOC: ").append(format.format(allocatedMemory / 1024L));
        sb.append(" MAX: ").append(format.format(maxMemory / 1024L));
        sb.append(" TOTAL: ").append(format.format((freeMemory + (maxMemory - allocatedMemory)) / 1024L));
        mLog.debug(sb.toString());
    }

    @Override
    public void channelChanged(ChannelEvent event) {
        switch (event.getEvent()) {
            case NOTIFICATION_ADD: {
                if (event.getChannel().getChannelType() == Channel.ChannelType.TRAFFIC) {
                    ++this.mTrafficChannelCount;
                    break;
                }
                ++this.mChannelCount;
                break;
            }
            case NOTIFICATION_DELETE: {
                if (event.getChannel().getChannelType() == Channel.ChannelType.TRAFFIC) {
                    --this.mTrafficChannelCount;
                    break;
                }
                --this.mChannelCount;
                break;
            }
            case REQUEST_DISABLE: {
                break;
            }
            case REQUEST_ENABLE: {
                break;
            }
            case NOTIFICATION_PROCESSING_START: {
                ++this.mChannelProcessingCount;
                break;
            }
            case NOTIFICATION_PROCESSING_STOP: {
                --this.mChannelProcessingCount;
                break;
            }
            case NOTIFICATION_STATE_RESET: {
                break;
            }
        }
    }
}

