/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.filter;

import io.github.dsheirer.filter.IFilterChangeListener;

public class FilterElement<T>
implements Comparable<FilterElement<T>> {
    private boolean mEnabled;
    private final T mElement;
    private IFilterChangeListener mFilterChangeListener;

    public FilterElement(T element, boolean enabled) {
        this.mElement = element;
        this.mEnabled = enabled;
    }

    public FilterElement(T t) {
        this(t, true);
    }

    public void register(IFilterChangeListener listener) {
        this.mFilterChangeListener = listener;
    }

    public T getElement() {
        return this.mElement;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
        if (this.mFilterChangeListener != null) {
            this.mFilterChangeListener.filterChanged();
        }
    }

    public String getName() {
        return this.mElement.toString();
    }

    @Override
    public int compareTo(FilterElement<T> other) {
        return this.toString().compareTo(other.toString());
    }

    public boolean equals(Object o) {
        if (o instanceof FilterElement) {
            FilterElement fe = (FilterElement)o;
            return this.compareTo(fe) == 0;
        }
        return false;
    }
}

