/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.filter;

import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.filter.IFilter;
import io.github.dsheirer.filter.IFilterChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Filter<T, K>
implements IFilter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Filter.class);
    private String mName;
    private Map<K, FilterElement<K>> mFilterElementMap = new HashMap<K, FilterElement<K>>();
    private IFilterChangeListener mFilterChangeListener;

    public Filter(String name) {
        this.mName = name;
    }

    protected boolean hasKey(K key) {
        return this.mFilterElementMap.containsKey(key);
    }

    public abstract Function<T, K> getKeyExtractor();

    @Override
    public boolean passes(T t) {
        K key = this.getKeyExtractor().apply(t);
        if (this.mFilterElementMap.containsKey(key)) {
            return this.mFilterElementMap.get(key).isEnabled();
        }
        return false;
    }

    @Override
    public boolean canProcess(T t) {
        return this.hasKey(this.getKeyExtractor().apply(t));
    }

    @Override
    public boolean isEnabled() {
        for (FilterElement<K> filterElement : this.mFilterElementMap.values()) {
            if (!filterElement.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public void add(FilterElement<K> filterElement) {
        if (this.mFilterElementMap.containsKey(filterElement.getElement())) {
            LOG.warn("Filter element for key [" + String.valueOf(filterElement.getElement()) + "] named [" + filterElement.getName() + "] already exists - overwriting existing value");
        }
        this.mFilterElementMap.put(filterElement.getElement(), filterElement);
        filterElement.register(this.mFilterChangeListener);
    }

    public final List<FilterElement<K>> getFilterElements() {
        return new ArrayList<FilterElement<K>>(this.mFilterElementMap.values());
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String toString() {
        return this.mName;
    }

    @Override
    public int getEnabledCount() {
        int count = 0;
        for (FilterElement<K> filterElement : this.mFilterElementMap.values()) {
            if (!filterElement.isEnabled()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getElementCount() {
        return this.mFilterElementMap.size();
    }

    @Override
    public void register(IFilterChangeListener listener) {
        this.mFilterChangeListener = listener;
        for (FilterElement<K> child : this.mFilterElementMap.values()) {
            child.register(listener);
        }
    }
}

