/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac.trellis;

import com.google.common.base.Joiner;
import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.trellis.DMR_3_4_Node;
import io.github.dsheirer.edac.trellis.Node;
import io.github.dsheirer.edac.trellis.Path;
import io.github.dsheirer.edac.trellis.ViterbiDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ViterbiDecoder_3_4_DMR
extends ViterbiDecoder {
    private static final int[] DEINTERLEAVE_DIBITS = new int[]{0, 1, 8, 9, 16, 17, 24, 25, 32, 33, 40, 41, 48, 49, 56, 57, 64, 65, 72, 73, 80, 81, 88, 89, 96, 97, 2, 3, 10, 11, 18, 19, 26, 27, 34, 35, 42, 43, 50, 51, 58, 59, 66, 67, 74, 75, 82, 83, 90, 91, 4, 5, 12, 13, 20, 21, 28, 29, 36, 37, 44, 45, 52, 53, 60, 61, 68, 69, 76, 77, 84, 85, 92, 93, 6, 7, 14, 15, 22, 23, 30, 31, 38, 39, 46, 47, 54, 55, 62, 63, 70, 71, 78, 79, 86, 87, 94, 95};
    private static final int[] DEINTERLEAVE_INDEXES = new int[]{0, 1, 2, 3, 16, 17, 18, 19, 32, 33, 34, 35, 48, 49, 50, 51, 64, 65, 66, 67, 80, 81, 82, 83, 96, 97, 98, 99, 112, 113, 114, 115, 128, 129, 130, 131, 144, 145, 146, 147, 160, 161, 162, 163, 176, 177, 178, 179, 192, 193, 194, 195, 4, 5, 6, 7, 20, 21, 22, 23, 36, 37, 38, 39, 52, 53, 54, 55, 68, 69, 70, 71, 84, 85, 86, 87, 100, 101, 102, 103, 116, 117, 118, 119, 132, 133, 134, 135, 148, 149, 150, 151, 164, 165, 166, 167, 180, 181, 182, 183, 8, 9, 10, 11, 24, 25, 26, 27, 40, 41, 42, 43, 56, 57, 58, 59, 72, 73, 74, 75, 88, 89, 90, 91, 104, 105, 106, 107, 120, 121, 122, 123, 136, 137, 138, 139, 152, 153, 154, 155, 168, 169, 170, 171, 184, 185, 186, 187, 12, 13, 14, 15, 28, 29, 30, 31, 44, 45, 46, 47, 60, 61, 62, 63, 76, 77, 78, 79, 92, 93, 94, 95, 108, 109, 110, 111, 124, 125, 126, 127, 140, 141, 142, 143, 156, 157, 158, 159, 172, 173, 174, 175, 188, 189, 190, 191};

    public ViterbiDecoder_3_4_DMR() {
        super(3, 4);
    }

    public static void main(String[] args) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i : DEINTERLEAVE_DIBITS) {
            indexes.add(i * 2);
            indexes.add(i * 2 + 1);
        }
        System.out.println(Joiner.on((String)",").join(indexes));
        Collections.sort(indexes);
        System.out.println(Joiner.on((String)",").join(indexes));
    }

    private static CorrectedBinaryMessage deinterleave(CorrectedBinaryMessage interleaved) {
        CorrectedBinaryMessage deinterleaved = new CorrectedBinaryMessage(196);
        for (int x = 0; x < 196; ++x) {
            if (!interleaved.get(x)) continue;
            deinterleaved.set(DEINTERLEAVE_INDEXES[x]);
        }
        return deinterleaved;
    }

    public CorrectedBinaryMessage decode(CorrectedBinaryMessage encodedMessage) {
        CorrectedBinaryMessage deinterleaved = ViterbiDecoder_3_4_DMR.deinterleave(encodedMessage);
        int[] symbols = this.getSymbols(deinterleaved);
        Path mostLikelyPath = this.decode(symbols);
        return ViterbiDecoder_3_4_DMR.getMessage(mostLikelyPath);
    }

    private static CorrectedBinaryMessage getMessage(Path path) {
        List<Node> mNodes = path.getNodes();
        CorrectedBinaryMessage message = new CorrectedBinaryMessage((mNodes.size() - 2) * 3);
        if (mNodes.size() > 2) {
            for (int x = 1; x < mNodes.size() - 1; ++x) {
                int inputValue = mNodes.get(x).getInputValue();
                int messageOffset = 3 * (x - 1);
                if ((inputValue & 4) == 4) {
                    message.set(messageOffset);
                }
                if ((inputValue & 2) == 2) {
                    message.set(messageOffset + 1);
                }
                if ((inputValue & 1) != 1) continue;
                message.set(messageOffset + 2);
            }
        }
        message.setCorrectedBitCount(path.getError());
        return message;
    }

    public int[] getSymbols(BinaryMessage encodedMessage) {
        if (encodedMessage.size() % this.getOutputBitLength() != 0) {
            throw new IllegalArgumentException("Encoded message must contain an integral number of 4-bit symbols - message size: " + encodedMessage.size());
        }
        int[] symbols = new int[encodedMessage.size() / this.getOutputBitLength()];
        int pointer = 0;
        for (int index = 0; index < encodedMessage.size(); index += this.getOutputBitLength()) {
            int symbol = encodedMessage.getInt(index, index + (this.getOutputBitLength() - 1));
            symbols[pointer++] = symbol;
        }
        return symbols;
    }

    @Override
    protected Node createNode(int inputValue, int transmittedOutputValue) {
        return new DMR_3_4_Node(inputValue, transmittedOutputValue);
    }

    @Override
    protected Node createFlushingNode(int transmittedOutputValue) {
        return new DMR_3_4_Node(0, transmittedOutputValue);
    }

    @Override
    protected Node createStartingNode() {
        return new DMR_3_4_Node(0, 0);
    }
}

