/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac.trellis;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.trellis.Node;
import io.github.dsheirer.edac.trellis.P25_1_2_Node;
import io.github.dsheirer.edac.trellis.Path;
import io.github.dsheirer.edac.trellis.ViterbiDecoder;
import java.util.List;

public class ViterbiDecoder_1_2_P25
extends ViterbiDecoder {
    public ViterbiDecoder_1_2_P25() {
        super(2, 4);
    }

    public CorrectedBinaryMessage decode(BinaryMessage encodedMessage) {
        int[] symbols = this.getSymbols(encodedMessage);
        Path mostLikelyPath = this.decode(symbols);
        return this.getMessage(mostLikelyPath);
    }

    private CorrectedBinaryMessage getMessage(Path path) {
        List<Node> mNodes = path.getNodes();
        CorrectedBinaryMessage message = new CorrectedBinaryMessage((mNodes.size() - 2) * this.getInputBitLength());
        if (mNodes.size() > 2) {
            for (int x = 1; x < mNodes.size() - 1; ++x) {
                int inputValue = mNodes.get(x).getInputValue();
                int messageOffset = this.getInputBitLength() * (x - 1);
                if ((inputValue & 2) == 2) {
                    message.set(messageOffset);
                }
                if ((inputValue & 1) != 1) continue;
                message.set(messageOffset + 1);
            }
        }
        message.setCorrectedBitCount(path.getError());
        return message;
    }

    public int[] getSymbols(BinaryMessage encodedMessage) {
        if (encodedMessage.size() % this.getOutputBitLength() != 0) {
            throw new IllegalArgumentException("Encoded message must contain an integral number of 4-bit symbols - message size: " + encodedMessage.size());
        }
        int[] symbols = new int[encodedMessage.size() / this.getOutputBitLength()];
        int pointer = 0;
        for (int index = 0; index < encodedMessage.size(); index += this.getOutputBitLength()) {
            int symbol = encodedMessage.getInt(index, index + (this.getOutputBitLength() - 1));
            symbols[pointer++] = symbol;
        }
        return symbols;
    }

    @Override
    protected Node createNode(int inputValue, int transmittedOutputValue) {
        return new P25_1_2_Node(inputValue, transmittedOutputValue);
    }

    @Override
    protected Node createFlushingNode(int transmittedOutputValue) {
        return new P25_1_2_Node(0, transmittedOutputValue);
    }

    @Override
    protected Node createStartingNode() {
        return new P25_1_2_Node(0, 0);
    }
}

