/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac.trellis;

import io.github.dsheirer.edac.trellis.Node;

public class P25_3_4_Node
extends Node {
    public static final int[] HAMMING_ERROR_COUNT = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
    public static final int[][] TRANSITION_MATRIX = new int[][]{{2, 13, 14, 1, 7, 8, 11, 4}, {14, 1, 7, 8, 11, 4, 2, 13}, {10, 5, 6, 9, 15, 0, 3, 12}, {6, 9, 15, 0, 3, 12, 10, 5}, {15, 0, 3, 12, 10, 5, 6, 9}, {3, 12, 10, 5, 6, 9, 15, 0}, {7, 8, 11, 4, 2, 13, 14, 1}, {11, 4, 2, 13, 14, 1, 7, 8}};

    public P25_3_4_Node(int inputValue, int transmittedOutputValue) {
        super(inputValue, transmittedOutputValue);
    }

    @Override
    public int getError(Node precedingNode) {
        if (precedingNode != null) {
            int expectedOutputValue = this.getOutputValue(precedingNode);
            int errorMask = expectedOutputValue ^ this.getTransmittedOutputValue();
            return HAMMING_ERROR_COUNT[errorMask];
        }
        return 0;
    }

    @Override
    public int getOutputValue(Node precedingNode) {
        return TRANSITION_MATRIX[precedingNode.getInputValue()][this.getInputValue()];
    }
}

