/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac.trellis;

import io.github.dsheirer.edac.trellis.Node;

public class P25_1_2_Node
extends Node {
    public static final int[] HAMMING_ERROR_COUNT = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
    public static final int[][] TRANSITION_MATRIX = new int[][]{{2, 12, 1, 15}, {14, 0, 13, 3}, {9, 7, 10, 4}, {5, 11, 6, 8}};

    public P25_1_2_Node(int inputValue, int transmittedOutputValue) {
        super(inputValue, transmittedOutputValue);
    }

    @Override
    public int getError(Node precedingNode) {
        if (precedingNode != null) {
            int expectedOutputValue = this.getOutputValue(precedingNode);
            int errorMask = expectedOutputValue ^ this.getTransmittedOutputValue();
            return HAMMING_ERROR_COUNT[errorMask];
        }
        return 0;
    }

    @Override
    public int getOutputValue(Node precedingNode) {
        return TRANSITION_MATRIX[precedingNode.getInputValue()][this.getInputValue()];
    }
}

