/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.edac;

import io.github.dsheirer.bits.BinaryMessage;

public class Hamming15 {
    private static int[] CHECKSUMS = new int[]{9, 13, 15, 14, 7, 10, 5, 11, 12, 6, 3};
    private static int[] ERROR_INDEX = new int[]{-1, 14, 13, 10, 12, 6, 9, 4, 11, 0, 5, 7, 8, 1, 3, 2};

    public static int getErrorIndex(BinaryMessage message, int offset) {
        int syndrome = Hamming15.getSyndrome(message, offset);
        if (syndrome > 0) {
            return offset + ERROR_INDEX[syndrome];
        }
        return -1;
    }

    private static int calculateChecksum(BinaryMessage message, int offset) {
        int calculated = 0;
        int i = message.nextSetBit(offset);
        while (i >= offset && i < offset + 11) {
            calculated ^= CHECKSUMS[i - offset];
            i = message.nextSetBit(i + 1);
        }
        return calculated;
    }

    private static int getSyndrome(BinaryMessage message, int offset) {
        int calculated = Hamming15.calculateChecksum(message, offset);
        int checksum = message.getInt(offset + 11, offset + 14);
        return checksum ^ calculated;
    }
}

